/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomPluginRequest extends KafkaConnectRequest implements
        ToCopyableBuilder<DescribeCustomPluginRequest.Builder, DescribeCustomPluginRequest> {
    private static final SdkField<String> CUSTOM_PLUGIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customPluginArn").getter(getter(DescribeCustomPluginRequest::customPluginArn))
            .setter(setter(Builder::customPluginArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("customPluginArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_PLUGIN_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String customPluginArn;

    private DescribeCustomPluginRequest(BuilderImpl builder) {
        super(builder);
        this.customPluginArn = builder.customPluginArn;
    }

    /**
     * <p>
     * Returns information about a custom plugin.
     * </p>
     * 
     * @return Returns information about a custom plugin.
     */
    public final String customPluginArn() {
        return customPluginArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customPluginArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomPluginRequest)) {
            return false;
        }
        DescribeCustomPluginRequest other = (DescribeCustomPluginRequest) obj;
        return Objects.equals(customPluginArn(), other.customPluginArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCustomPluginRequest").add("CustomPluginArn", customPluginArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customPluginArn":
            return Optional.ofNullable(clazz.cast(customPluginArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customPluginArn", CUSTOM_PLUGIN_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomPluginRequest, T> g) {
        return obj -> g.apply((DescribeCustomPluginRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCustomPluginRequest> {
        /**
         * <p>
         * Returns information about a custom plugin.
         * </p>
         * 
         * @param customPluginArn
         *        Returns information about a custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPluginArn(String customPluginArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaConnectRequest.BuilderImpl implements Builder {
        private String customPluginArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomPluginRequest model) {
            super(model);
            customPluginArn(model.customPluginArn);
        }

        public final String getCustomPluginArn() {
            return customPluginArn;
        }

        public final void setCustomPluginArn(String customPluginArn) {
            this.customPluginArn = customPluginArn;
        }

        @Override
        public final Builder customPluginArn(String customPluginArn) {
            this.customPluginArn = customPluginArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCustomPluginRequest build() {
            return new DescribeCustomPluginRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
