/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the settings for delivering logs to Amazon Kinesis Data Firehose.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirehoseLogDeliveryDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<FirehoseLogDeliveryDescription.Builder, FirehoseLogDeliveryDescription> {
    private static final SdkField<String> DELIVERY_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deliveryStream").getter(getter(FirehoseLogDeliveryDescription::deliveryStream))
            .setter(setter(Builder::deliveryStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryStream").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(FirehoseLogDeliveryDescription::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_FIELD,
            ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deliveryStream;

    private final Boolean enabled;

    private FirehoseLogDeliveryDescription(BuilderImpl builder) {
        this.deliveryStream = builder.deliveryStream;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
     * </p>
     * 
     * @return The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
     */
    public final String deliveryStream() {
        return deliveryStream;
    }

    /**
     * <p>
     * Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
     * </p>
     * 
     * @return Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStream());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirehoseLogDeliveryDescription)) {
            return false;
        }
        FirehoseLogDeliveryDescription other = (FirehoseLogDeliveryDescription) obj;
        return Objects.equals(deliveryStream(), other.deliveryStream()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirehoseLogDeliveryDescription").add("DeliveryStream", deliveryStream())
                .add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deliveryStream":
            return Optional.ofNullable(clazz.cast(deliveryStream()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deliveryStream", DELIVERY_STREAM_FIELD);
        map.put("enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirehoseLogDeliveryDescription, T> g) {
        return obj -> g.apply((FirehoseLogDeliveryDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirehoseLogDeliveryDescription> {
        /**
         * <p>
         * The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
         * </p>
         * 
         * @param deliveryStream
         *        The name of the Kinesis Data Firehose delivery stream that is the destination for log delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStream(String deliveryStream);

        /**
         * <p>
         * Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
         * </p>
         * 
         * @param enabled
         *        Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryStream;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(FirehoseLogDeliveryDescription model) {
            deliveryStream(model.deliveryStream);
            enabled(model.enabled);
        }

        public final String getDeliveryStream() {
            return deliveryStream;
        }

        public final void setDeliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
        }

        @Override
        public final Builder deliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public FirehoseLogDeliveryDescription build() {
            return new FirehoseLogDeliveryDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
