/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of encryption in transit to the Apache Kafka cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KafkaClusterEncryptionInTransit implements SdkPojo, Serializable,
        ToCopyableBuilder<KafkaClusterEncryptionInTransit.Builder, KafkaClusterEncryptionInTransit> {
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionType").getter(getter(KafkaClusterEncryptionInTransit::encryptionTypeAsString))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String encryptionType;

    private KafkaClusterEncryptionInTransit(BuilderImpl builder) {
        this.encryptionType = builder.encryptionType;
    }

    /**
     * <p>
     * The type of encryption in transit to the Apache Kafka cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link KafkaClusterEncryptionInTransitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The type of encryption in transit to the Apache Kafka cluster.
     * @see KafkaClusterEncryptionInTransitType
     */
    public final KafkaClusterEncryptionInTransitType encryptionType() {
        return KafkaClusterEncryptionInTransitType.fromValue(encryptionType);
    }

    /**
     * <p>
     * The type of encryption in transit to the Apache Kafka cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link KafkaClusterEncryptionInTransitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The type of encryption in transit to the Apache Kafka cluster.
     * @see KafkaClusterEncryptionInTransitType
     */
    public final String encryptionTypeAsString() {
        return encryptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaClusterEncryptionInTransit)) {
            return false;
        }
        KafkaClusterEncryptionInTransit other = (KafkaClusterEncryptionInTransit) obj;
        return Objects.equals(encryptionTypeAsString(), other.encryptionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KafkaClusterEncryptionInTransit").add("EncryptionType", encryptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encryptionType":
            return Optional.ofNullable(clazz.cast(encryptionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("encryptionType", ENCRYPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KafkaClusterEncryptionInTransit, T> g) {
        return obj -> g.apply((KafkaClusterEncryptionInTransit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KafkaClusterEncryptionInTransit> {
        /**
         * <p>
         * The type of encryption in transit to the Apache Kafka cluster.
         * </p>
         * 
         * @param encryptionType
         *        The type of encryption in transit to the Apache Kafka cluster.
         * @see KafkaClusterEncryptionInTransitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KafkaClusterEncryptionInTransitType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The type of encryption in transit to the Apache Kafka cluster.
         * </p>
         * 
         * @param encryptionType
         *        The type of encryption in transit to the Apache Kafka cluster.
         * @see KafkaClusterEncryptionInTransitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KafkaClusterEncryptionInTransitType
         */
        Builder encryptionType(KafkaClusterEncryptionInTransitType encryptionType);
    }

    static final class BuilderImpl implements Builder {
        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaClusterEncryptionInTransit model) {
            encryptionType(model.encryptionType);
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(KafkaClusterEncryptionInTransitType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        @Override
        public KafkaClusterEncryptionInTransit build() {
            return new KafkaClusterEncryptionInTransit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
