/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A plugin is an Amazon Web Services resource that contains the code that defines your connector logic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Plugin implements SdkPojo, Serializable, ToCopyableBuilder<Plugin.Builder, Plugin> {
    private static final SdkField<CustomPlugin> CUSTOM_PLUGIN_FIELD = SdkField.<CustomPlugin> builder(MarshallingType.SDK_POJO)
            .memberName("customPlugin").getter(getter(Plugin::customPlugin)).setter(setter(Builder::customPlugin))
            .constructor(CustomPlugin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPlugin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_PLUGIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomPlugin customPlugin;

    private Plugin(BuilderImpl builder) {
        this.customPlugin = builder.customPlugin;
    }

    /**
     * <p>
     * Details about a custom plugin.
     * </p>
     * 
     * @return Details about a custom plugin.
     */
    public final CustomPlugin customPlugin() {
        return customPlugin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customPlugin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Plugin)) {
            return false;
        }
        Plugin other = (Plugin) obj;
        return Objects.equals(customPlugin(), other.customPlugin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Plugin").add("CustomPlugin", customPlugin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customPlugin":
            return Optional.ofNullable(clazz.cast(customPlugin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customPlugin", CUSTOM_PLUGIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Plugin, T> g) {
        return obj -> g.apply((Plugin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Plugin> {
        /**
         * <p>
         * Details about a custom plugin.
         * </p>
         * 
         * @param customPlugin
         *        Details about a custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPlugin(CustomPlugin customPlugin);

        /**
         * <p>
         * Details about a custom plugin.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPlugin.Builder} avoiding the need
         * to create one manually via {@link CustomPlugin#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomPlugin.Builder#build()} is called immediately and its
         * result is passed to {@link #customPlugin(CustomPlugin)}.
         * 
         * @param customPlugin
         *        a consumer that will call methods on {@link CustomPlugin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPlugin(CustomPlugin)
         */
        default Builder customPlugin(Consumer<CustomPlugin.Builder> customPlugin) {
            return customPlugin(CustomPlugin.builder().applyMutation(customPlugin).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomPlugin customPlugin;

        private BuilderImpl() {
        }

        private BuilderImpl(Plugin model) {
            customPlugin(model.customPlugin);
        }

        public final CustomPlugin.Builder getCustomPlugin() {
            return customPlugin != null ? customPlugin.toBuilder() : null;
        }

        public final void setCustomPlugin(CustomPlugin.BuilderImpl customPlugin) {
            this.customPlugin = customPlugin != null ? customPlugin.build() : null;
        }

        @Override
        public final Builder customPlugin(CustomPlugin customPlugin) {
            this.customPlugin = customPlugin;
            return this;
        }

        @Override
        public Plugin build() {
            return new Plugin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
