/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.FeaturedResultsSetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeaturedResultsSetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FeaturedResultsSetSummary> {
    private static final SdkField<String> FEATURED_RESULTS_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeaturedResultsSetId").getter(FeaturedResultsSetSummary.getter(FeaturedResultsSetSummary::featuredResultsSetId)).setter(FeaturedResultsSetSummary.setter(Builder::featuredResultsSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetId").build()}).build();
    private static final SdkField<String> FEATURED_RESULTS_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeaturedResultsSetName").getter(FeaturedResultsSetSummary.getter(FeaturedResultsSetSummary::featuredResultsSetName)).setter(FeaturedResultsSetSummary.setter(Builder::featuredResultsSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FeaturedResultsSetSummary.getter(FeaturedResultsSetSummary::statusAsString)).setter(FeaturedResultsSetSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Long> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastUpdatedTimestamp").getter(FeaturedResultsSetSummary.getter(FeaturedResultsSetSummary::lastUpdatedTimestamp)).setter(FeaturedResultsSetSummary.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<Long> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreationTimestamp").getter(FeaturedResultsSetSummary.getter(FeaturedResultsSetSummary::creationTimestamp)).setter(FeaturedResultsSetSummary.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURED_RESULTS_SET_ID_FIELD, FEATURED_RESULTS_SET_NAME_FIELD, STATUS_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, CREATION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FeaturedResultsSetSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String featuredResultsSetId;
    private final String featuredResultsSetName;
    private final String status;
    private final Long lastUpdatedTimestamp;
    private final Long creationTimestamp;

    private FeaturedResultsSetSummary(BuilderImpl builder) {
        this.featuredResultsSetId = builder.featuredResultsSetId;
        this.featuredResultsSetName = builder.featuredResultsSetName;
        this.status = builder.status;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.creationTimestamp = builder.creationTimestamp;
    }

    public final String featuredResultsSetId() {
        return this.featuredResultsSetId;
    }

    public final String featuredResultsSetName() {
        return this.featuredResultsSetName;
    }

    public final FeaturedResultsSetStatus status() {
        return FeaturedResultsSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Long lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final Long creationTimestamp() {
        return this.creationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featuredResultsSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.featuredResultsSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeaturedResultsSetSummary)) {
            return false;
        }
        FeaturedResultsSetSummary other = (FeaturedResultsSetSummary)obj;
        return Objects.equals(this.featuredResultsSetId(), other.featuredResultsSetId()) && Objects.equals(this.featuredResultsSetName(), other.featuredResultsSetName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"FeaturedResultsSetSummary").add("FeaturedResultsSetId", (Object)this.featuredResultsSetId()).add("FeaturedResultsSetName", (Object)this.featuredResultsSetName()).add("Status", (Object)this.statusAsString()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("CreationTimestamp", (Object)this.creationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeaturedResultsSetId": {
                return Optional.ofNullable(clazz.cast(this.featuredResultsSetId()));
            }
            case "FeaturedResultsSetName": {
                return Optional.ofNullable(clazz.cast(this.featuredResultsSetName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FeaturedResultsSetId", FEATURED_RESULTS_SET_ID_FIELD);
        map.put("FeaturedResultsSetName", FEATURED_RESULTS_SET_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FeaturedResultsSetSummary, T> g) {
        return obj -> g.apply((FeaturedResultsSetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featuredResultsSetId;
        private String featuredResultsSetName;
        private String status;
        private Long lastUpdatedTimestamp;
        private Long creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(FeaturedResultsSetSummary model) {
            this.featuredResultsSetId(model.featuredResultsSetId);
            this.featuredResultsSetName(model.featuredResultsSetName);
            this.status(model.status);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.creationTimestamp(model.creationTimestamp);
        }

        public final String getFeaturedResultsSetId() {
            return this.featuredResultsSetId;
        }

        public final void setFeaturedResultsSetId(String featuredResultsSetId) {
            this.featuredResultsSetId = featuredResultsSetId;
        }

        @Override
        public final Builder featuredResultsSetId(String featuredResultsSetId) {
            this.featuredResultsSetId = featuredResultsSetId;
            return this;
        }

        public final String getFeaturedResultsSetName() {
            return this.featuredResultsSetName;
        }

        public final void setFeaturedResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
        }

        @Override
        public final Builder featuredResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeaturedResultsSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Long lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Long lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final Long getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public FeaturedResultsSetSummary build() {
            return new FeaturedResultsSetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeaturedResultsSetSummary> {
        public Builder featuredResultsSetId(String var1);

        public Builder featuredResultsSetName(String var1);

        public Builder status(String var1);

        public Builder status(FeaturedResultsSetStatus var1);

        public Builder lastUpdatedTimestamp(Long var1);

        public Builder creationTimestamp(Long var1);
    }
}

