/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WebCrawlerMode {
    HOST_ONLY("HOST_ONLY"),
    SUBDOMAINS("SUBDOMAINS"),
    EVERYTHING("EVERYTHING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WebCrawlerMode> VALUE_MAP;
    private final String value;

    private WebCrawlerMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WebCrawlerMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WebCrawlerMode> knownValues() {
        EnumSet<WebCrawlerMode> knownValues = EnumSet.allOf(WebCrawlerMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WebCrawlerMode.class, WebCrawlerMode::toString);
    }
}

