/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Keyspaces has two read/write capacity modes for processing reads and writes on your tables:
 * </p>
 * <ul>
 * <li>
 * <p>
 * On-demand (default)
 * </p>
 * </li>
 * <li>
 * <p>
 * Provisioned
 * </p>
 * </li>
 * </ul>
 * <p>
 * The read/write capacity mode that you choose controls how you are charged for read and write throughput and how table
 * throughput capacity is managed.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity modes</a>
 * in the <i>Amazon Keyspaces Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacitySpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacitySpecification.Builder, CapacitySpecification> {
    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("throughputMode").getter(getter(CapacitySpecification::throughputModeAsString))
            .setter(setter(Builder::throughputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughputMode").build()).build();

    private static final SdkField<Long> READ_CAPACITY_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("readCapacityUnits").getter(getter(CapacitySpecification::readCapacityUnits))
            .setter(setter(Builder::readCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readCapacityUnits").build()).build();

    private static final SdkField<Long> WRITE_CAPACITY_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("writeCapacityUnits").getter(getter(CapacitySpecification::writeCapacityUnits))
            .setter(setter(Builder::writeCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeCapacityUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THROUGHPUT_MODE_FIELD,
            READ_CAPACITY_UNITS_FIELD, WRITE_CAPACITY_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String throughputMode;

    private final Long readCapacityUnits;

    private final Long writeCapacityUnits;

    private CapacitySpecification(BuilderImpl builder) {
        this.throughputMode = builder.throughputMode;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    /**
     * <p>
     * The read/write throughput capacity mode for a table. The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>throughputMode:PAY_PER_REQUEST</code> and
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and
     * <code>writeCapacityUnits</code> as input.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
     * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #throughputMode}
     * will return {@link ThroughputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #throughputModeAsString}.
     * </p>
     * 
     * @return The read/write throughput capacity mode for a table. The options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>throughputMode:PAY_PER_REQUEST</code> and
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires
     *         <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write
     *         capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * @see ThroughputMode
     */
    public final ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(throughputMode);
    }

    /**
     * <p>
     * The read/write throughput capacity mode for a table. The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>throughputMode:PAY_PER_REQUEST</code> and
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and
     * <code>writeCapacityUnits</code> as input.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
     * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #throughputMode}
     * will return {@link ThroughputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #throughputModeAsString}.
     * </p>
     * 
     * @return The read/write throughput capacity mode for a table. The options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>throughputMode:PAY_PER_REQUEST</code> and
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires
     *         <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write
     *         capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * @see ThroughputMode
     */
    public final String throughputModeAsString() {
        return throughputMode;
    }

    /**
     * <p>
     * The throughput capacity specified for <code>read</code> operations defined in <code>read capacity units</code>
     * <code>(RCUs)</code>.
     * </p>
     * 
     * @return The throughput capacity specified for <code>read</code> operations defined in
     *         <code>read capacity units</code> <code>(RCUs)</code>.
     */
    public final Long readCapacityUnits() {
        return readCapacityUnits;
    }

    /**
     * <p>
     * The throughput capacity specified for <code>write</code> operations defined in <code>write capacity units</code>
     * <code>(WCUs)</code>.
     * </p>
     * 
     * @return The throughput capacity specified for <code>write</code> operations defined in
     *         <code>write capacity units</code> <code>(WCUs)</code>.
     */
    public final Long writeCapacityUnits() {
        return writeCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(writeCapacityUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacitySpecification)) {
            return false;
        }
        CapacitySpecification other = (CapacitySpecification) obj;
        return Objects.equals(throughputModeAsString(), other.throughputModeAsString())
                && Objects.equals(readCapacityUnits(), other.readCapacityUnits())
                && Objects.equals(writeCapacityUnits(), other.writeCapacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacitySpecification").add("ThroughputMode", throughputModeAsString())
                .add("ReadCapacityUnits", readCapacityUnits()).add("WriteCapacityUnits", writeCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "throughputMode":
            return Optional.ofNullable(clazz.cast(throughputModeAsString()));
        case "readCapacityUnits":
            return Optional.ofNullable(clazz.cast(readCapacityUnits()));
        case "writeCapacityUnits":
            return Optional.ofNullable(clazz.cast(writeCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("throughputMode", THROUGHPUT_MODE_FIELD);
        map.put("readCapacityUnits", READ_CAPACITY_UNITS_FIELD);
        map.put("writeCapacityUnits", WRITE_CAPACITY_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacitySpecification, T> g) {
        return obj -> g.apply((CapacitySpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacitySpecification> {
        /**
         * <p>
         * The read/write throughput capacity mode for a table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>throughputMode:PAY_PER_REQUEST</code> and
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code>
         * and <code>writeCapacityUnits</code> as input.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
         * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param throughputMode
         *        The read/write throughput capacity mode for a table. The options are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>throughputMode:PAY_PER_REQUEST</code> and
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires
         *        <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write
         *        capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @see ThroughputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThroughputMode
         */
        Builder throughputMode(String throughputMode);

        /**
         * <p>
         * The read/write throughput capacity mode for a table. The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>throughputMode:PAY_PER_REQUEST</code> and
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code>
         * and <code>writeCapacityUnits</code> as input.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
         * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param throughputMode
         *        The read/write throughput capacity mode for a table. The options are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>throughputMode:PAY_PER_REQUEST</code> and
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires
         *        <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write
         *        capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @see ThroughputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThroughputMode
         */
        Builder throughputMode(ThroughputMode throughputMode);

        /**
         * <p>
         * The throughput capacity specified for <code>read</code> operations defined in
         * <code>read capacity units</code> <code>(RCUs)</code>.
         * </p>
         * 
         * @param readCapacityUnits
         *        The throughput capacity specified for <code>read</code> operations defined in
         *        <code>read capacity units</code> <code>(RCUs)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityUnits(Long readCapacityUnits);

        /**
         * <p>
         * The throughput capacity specified for <code>write</code> operations defined in
         * <code>write capacity units</code> <code>(WCUs)</code>.
         * </p>
         * 
         * @param writeCapacityUnits
         *        The throughput capacity specified for <code>write</code> operations defined in
         *        <code>write capacity units</code> <code>(WCUs)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeCapacityUnits(Long writeCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private String throughputMode;

        private Long readCapacityUnits;

        private Long writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacitySpecification model) {
            throughputMode(model.throughputMode);
            readCapacityUnits(model.readCapacityUnits);
            writeCapacityUnits(model.writeCapacityUnits);
        }

        public final String getThroughputMode() {
            return throughputMode;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode == null ? null : throughputMode.toString());
            return this;
        }

        public final Long getReadCapacityUnits() {
            return readCapacityUnits;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final Long getWriteCapacityUnits() {
            return writeCapacityUnits;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        @Override
        public CapacitySpecification build() {
            return new CapacitySpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
