/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableAutoScalingSettingsResponse extends KeyspacesResponse implements
        ToCopyableBuilder<GetTableAutoScalingSettingsResponse.Builder, GetTableAutoScalingSettingsResponse> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(GetTableAutoScalingSettingsResponse::keyspaceName))
            .setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(GetTableAutoScalingSettingsResponse::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(GetTableAutoScalingSettingsResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<AutoScalingSpecification> AUTO_SCALING_SPECIFICATION_FIELD = SdkField
            .<AutoScalingSpecification> builder(MarshallingType.SDK_POJO).memberName("autoScalingSpecification")
            .getter(getter(GetTableAutoScalingSettingsResponse::autoScalingSpecification))
            .setter(setter(Builder::autoScalingSpecification)).constructor(AutoScalingSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingSpecification").build())
            .build();

    private static final SdkField<List<ReplicaAutoScalingSpecification>> REPLICA_SPECIFICATIONS_FIELD = SdkField
            .<List<ReplicaAutoScalingSpecification>> builder(MarshallingType.LIST)
            .memberName("replicaSpecifications")
            .getter(getter(GetTableAutoScalingSettingsResponse::replicaSpecifications))
            .setter(setter(Builder::replicaSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaAutoScalingSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaAutoScalingSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            TABLE_NAME_FIELD, RESOURCE_ARN_FIELD, AUTO_SCALING_SPECIFICATION_FIELD, REPLICA_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyspaceName;

    private final String tableName;

    private final String resourceArn;

    private final AutoScalingSpecification autoScalingSpecification;

    private final List<ReplicaAutoScalingSpecification> replicaSpecifications;

    private GetTableAutoScalingSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.resourceArn = builder.resourceArn;
        this.autoScalingSpecification = builder.autoScalingSpecification;
        this.replicaSpecifications = builder.replicaSpecifications;
    }

    /**
     * <p>
     * The name of the keyspace.
     * </p>
     * 
     * @return The name of the keyspace.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The auto scaling settings of the table.
     * </p>
     * 
     * @return The auto scaling settings of the table.
     */
    public final AutoScalingSpecification autoScalingSpecification() {
        return autoScalingSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicaSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReplicaSpecifications() {
        return replicaSpecifications != null && !(replicaSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Region specific settings of a multi-Region table. Returns the settings for all Regions
     * the table is replicated in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicaSpecifications} method.
     * </p>
     * 
     * @return The Amazon Web Services Region specific settings of a multi-Region table. Returns the settings for all
     *         Regions the table is replicated in.
     */
    public final List<ReplicaAutoScalingSpecification> replicaSpecifications() {
        return replicaSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicaSpecifications() ? replicaSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableAutoScalingSettingsResponse)) {
            return false;
        }
        GetTableAutoScalingSettingsResponse other = (GetTableAutoScalingSettingsResponse) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(autoScalingSpecification(), other.autoScalingSpecification())
                && hasReplicaSpecifications() == other.hasReplicaSpecifications()
                && Objects.equals(replicaSpecifications(), other.replicaSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableAutoScalingSettingsResponse").add("KeyspaceName", keyspaceName())
                .add("TableName", tableName()).add("ResourceArn", resourceArn())
                .add("AutoScalingSpecification", autoScalingSpecification())
                .add("ReplicaSpecifications", hasReplicaSpecifications() ? replicaSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "autoScalingSpecification":
            return Optional.ofNullable(clazz.cast(autoScalingSpecification()));
        case "replicaSpecifications":
            return Optional.ofNullable(clazz.cast(replicaSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("autoScalingSpecification", AUTO_SCALING_SPECIFICATION_FIELD);
        map.put("replicaSpecifications", REPLICA_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableAutoScalingSettingsResponse, T> g) {
        return obj -> g.apply((GetTableAutoScalingSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTableAutoScalingSettingsResponse> {
        /**
         * <p>
         * The name of the keyspace.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The auto scaling settings of the table.
         * </p>
         * 
         * @param autoScalingSpecification
         *        The auto scaling settings of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingSpecification(AutoScalingSpecification autoScalingSpecification);

        /**
         * <p>
         * The auto scaling settings of the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingSpecification.Builder}
         * avoiding the need to create one manually via {@link AutoScalingSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #autoScalingSpecification(AutoScalingSpecification)}.
         * 
         * @param autoScalingSpecification
         *        a consumer that will call methods on {@link AutoScalingSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingSpecification(AutoScalingSpecification)
         */
        default Builder autoScalingSpecification(Consumer<AutoScalingSpecification.Builder> autoScalingSpecification) {
            return autoScalingSpecification(AutoScalingSpecification.builder().applyMutation(autoScalingSpecification).build());
        }

        /**
         * <p>
         * The Amazon Web Services Region specific settings of a multi-Region table. Returns the settings for all
         * Regions the table is replicated in.
         * </p>
         * 
         * @param replicaSpecifications
         *        The Amazon Web Services Region specific settings of a multi-Region table. Returns the settings for all
         *        Regions the table is replicated in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaSpecifications(Collection<ReplicaAutoScalingSpecification> replicaSpecifications);

        /**
         * <p>
         * The Amazon Web Services Region specific settings of a multi-Region table. Returns the settings for all
         * Regions the table is replicated in.
         * </p>
         * 
         * @param replicaSpecifications
         *        The Amazon Web Services Region specific settings of a multi-Region table. Returns the settings for all
         *        Regions the table is replicated in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaSpecifications(ReplicaAutoScalingSpecification... replicaSpecifications);

        /**
         * <p>
         * The Amazon Web Services Region specific settings of a multi-Region table. Returns the settings for all
         * Regions the table is replicated in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecification.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecification.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #replicaSpecifications(List<ReplicaAutoScalingSpecification>)}.
         * 
         * @param replicaSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaSpecifications(java.util.Collection<ReplicaAutoScalingSpecification>)
         */
        Builder replicaSpecifications(Consumer<ReplicaAutoScalingSpecification.Builder>... replicaSpecifications);
    }

    static final class BuilderImpl extends KeyspacesResponse.BuilderImpl implements Builder {
        private String keyspaceName;

        private String tableName;

        private String resourceArn;

        private AutoScalingSpecification autoScalingSpecification;

        private List<ReplicaAutoScalingSpecification> replicaSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableAutoScalingSettingsResponse model) {
            super(model);
            keyspaceName(model.keyspaceName);
            tableName(model.tableName);
            resourceArn(model.resourceArn);
            autoScalingSpecification(model.autoScalingSpecification);
            replicaSpecifications(model.replicaSpecifications);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final AutoScalingSpecification.Builder getAutoScalingSpecification() {
            return autoScalingSpecification != null ? autoScalingSpecification.toBuilder() : null;
        }

        public final void setAutoScalingSpecification(AutoScalingSpecification.BuilderImpl autoScalingSpecification) {
            this.autoScalingSpecification = autoScalingSpecification != null ? autoScalingSpecification.build() : null;
        }

        @Override
        public final Builder autoScalingSpecification(AutoScalingSpecification autoScalingSpecification) {
            this.autoScalingSpecification = autoScalingSpecification;
            return this;
        }

        public final List<ReplicaAutoScalingSpecification.Builder> getReplicaSpecifications() {
            List<ReplicaAutoScalingSpecification.Builder> result = ReplicaAutoScalingSpecificationListCopier
                    .copyToBuilder(this.replicaSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaSpecifications(Collection<ReplicaAutoScalingSpecification.BuilderImpl> replicaSpecifications) {
            this.replicaSpecifications = ReplicaAutoScalingSpecificationListCopier.copyFromBuilder(replicaSpecifications);
        }

        @Override
        public final Builder replicaSpecifications(Collection<ReplicaAutoScalingSpecification> replicaSpecifications) {
            this.replicaSpecifications = ReplicaAutoScalingSpecificationListCopier.copy(replicaSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSpecifications(ReplicaAutoScalingSpecification... replicaSpecifications) {
            replicaSpecifications(Arrays.asList(replicaSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSpecifications(Consumer<ReplicaAutoScalingSpecification.Builder>... replicaSpecifications) {
            replicaSpecifications(Stream.of(replicaSpecifications)
                    .map(c -> ReplicaAutoScalingSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetTableAutoScalingSettingsResponse build() {
            return new GetTableAutoScalingSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
