/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This shows the summary status of the keyspace after a new Amazon Web Services Region was added.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationGroupStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationGroupStatus.Builder, ReplicationGroupStatus> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(ReplicationGroupStatus::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> KEYSPACE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceStatus").getter(getter(ReplicationGroupStatus::keyspaceStatusAsString))
            .setter(setter(Builder::keyspaceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceStatus").build()).build();

    private static final SdkField<String> TABLES_REPLICATION_PROGRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tablesReplicationProgress").getter(getter(ReplicationGroupStatus::tablesReplicationProgress))
            .setter(setter(Builder::tablesReplicationProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tablesReplicationProgress").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            KEYSPACE_STATUS_FIELD, TABLES_REPLICATION_PROGRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String keyspaceStatus;

    private final String tablesReplicationProgress;

    private ReplicationGroupStatus(BuilderImpl builder) {
        this.region = builder.region;
        this.keyspaceStatus = builder.keyspaceStatus;
        this.tablesReplicationProgress = builder.tablesReplicationProgress;
    }

    /**
     * <p>
     * The name of the Region that was added to the keyspace.
     * </p>
     * 
     * @return The name of the Region that was added to the keyspace.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The status of the keyspace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyspaceStatus}
     * will return {@link KeyspaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyspaceStatusAsString}.
     * </p>
     * 
     * @return The status of the keyspace.
     * @see KeyspaceStatus
     */
    public final KeyspaceStatus keyspaceStatus() {
        return KeyspaceStatus.fromValue(keyspaceStatus);
    }

    /**
     * <p>
     * The status of the keyspace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyspaceStatus}
     * will return {@link KeyspaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyspaceStatusAsString}.
     * </p>
     * 
     * @return The status of the keyspace.
     * @see KeyspaceStatus
     */
    public final String keyspaceStatusAsString() {
        return keyspaceStatus;
    }

    /**
     * <p>
     * This shows the replication progress of tables in the keyspace. The value is expressed as a percentage of the
     * newly replicated tables with status <code>Active</code> compared to the total number of tables in the keyspace.
     * </p>
     * 
     * @return This shows the replication progress of tables in the keyspace. The value is expressed as a percentage of
     *         the newly replicated tables with status <code>Active</code> compared to the total number of tables in the
     *         keyspace.
     */
    public final String tablesReplicationProgress() {
        return tablesReplicationProgress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tablesReplicationProgress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroupStatus)) {
            return false;
        }
        ReplicationGroupStatus other = (ReplicationGroupStatus) obj;
        return Objects.equals(region(), other.region())
                && Objects.equals(keyspaceStatusAsString(), other.keyspaceStatusAsString())
                && Objects.equals(tablesReplicationProgress(), other.tablesReplicationProgress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationGroupStatus").add("Region", region()).add("KeyspaceStatus", keyspaceStatusAsString())
                .add("TablesReplicationProgress", tablesReplicationProgress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "keyspaceStatus":
            return Optional.ofNullable(clazz.cast(keyspaceStatusAsString()));
        case "tablesReplicationProgress":
            return Optional.ofNullable(clazz.cast(tablesReplicationProgress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("region", REGION_FIELD);
        map.put("keyspaceStatus", KEYSPACE_STATUS_FIELD);
        map.put("tablesReplicationProgress", TABLES_REPLICATION_PROGRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroupStatus, T> g) {
        return obj -> g.apply((ReplicationGroupStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationGroupStatus> {
        /**
         * <p>
         * The name of the Region that was added to the keyspace.
         * </p>
         * 
         * @param region
         *        The name of the Region that was added to the keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The status of the keyspace.
         * </p>
         * 
         * @param keyspaceStatus
         *        The status of the keyspace.
         * @see KeyspaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyspaceStatus
         */
        Builder keyspaceStatus(String keyspaceStatus);

        /**
         * <p>
         * The status of the keyspace.
         * </p>
         * 
         * @param keyspaceStatus
         *        The status of the keyspace.
         * @see KeyspaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyspaceStatus
         */
        Builder keyspaceStatus(KeyspaceStatus keyspaceStatus);

        /**
         * <p>
         * This shows the replication progress of tables in the keyspace. The value is expressed as a percentage of the
         * newly replicated tables with status <code>Active</code> compared to the total number of tables in the
         * keyspace.
         * </p>
         * 
         * @param tablesReplicationProgress
         *        This shows the replication progress of tables in the keyspace. The value is expressed as a percentage
         *        of the newly replicated tables with status <code>Active</code> compared to the total number of tables
         *        in the keyspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesReplicationProgress(String tablesReplicationProgress);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String keyspaceStatus;

        private String tablesReplicationProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroupStatus model) {
            region(model.region);
            keyspaceStatus(model.keyspaceStatus);
            tablesReplicationProgress(model.tablesReplicationProgress);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getKeyspaceStatus() {
            return keyspaceStatus;
        }

        public final void setKeyspaceStatus(String keyspaceStatus) {
            this.keyspaceStatus = keyspaceStatus;
        }

        @Override
        public final Builder keyspaceStatus(String keyspaceStatus) {
            this.keyspaceStatus = keyspaceStatus;
            return this;
        }

        @Override
        public final Builder keyspaceStatus(KeyspaceStatus keyspaceStatus) {
            this.keyspaceStatus(keyspaceStatus == null ? null : keyspaceStatus.toString());
            return this;
        }

        public final String getTablesReplicationProgress() {
            return tablesReplicationProgress;
        }

        public final void setTablesReplicationProgress(String tablesReplicationProgress) {
            this.tablesReplicationProgress = tablesReplicationProgress;
        }

        @Override
        public final Builder tablesReplicationProgress(String tablesReplicationProgress) {
            this.tablesReplicationProgress = tablesReplicationProgress;
            return this;
        }

        @Override
        public ReplicationGroupStatus build() {
            return new ReplicationGroupStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
