/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The replication specification of the keyspace includes:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>regionList</code> - up to six Amazon Web Services Regions where the keyspace is replicated in.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>replicationStrategy</code> - the required value is <code>SINGLE_REGION</code> or <code>MULTI_REGION</code>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationSpecification.Builder, ReplicationSpecification> {
    private static final SdkField<String> REPLICATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationStrategy").getter(getter(ReplicationSpecification::replicationStrategyAsString))
            .setter(setter(Builder::replicationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStrategy").build())
            .build();

    private static final SdkField<List<String>> REGION_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regionList")
            .getter(getter(ReplicationSpecification::regionList))
            .setter(setter(Builder::regionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_STRATEGY_FIELD,
            REGION_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String replicationStrategy;

    private final List<String> regionList;

    private ReplicationSpecification(BuilderImpl builder) {
        this.replicationStrategy = builder.replicationStrategy;
        this.regionList = builder.regionList;
    }

    /**
     * <p>
     * The <code>replicationStrategy</code> of a keyspace, the required value is <code>SINGLE_REGION</code> or
     * <code>MULTI_REGION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationStrategy} will return {@link Rs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #replicationStrategyAsString}.
     * </p>
     * 
     * @return The <code>replicationStrategy</code> of a keyspace, the required value is <code>SINGLE_REGION</code> or
     *         <code>MULTI_REGION</code>.
     * @see Rs
     */
    public final Rs replicationStrategy() {
        return Rs.fromValue(replicationStrategy);
    }

    /**
     * <p>
     * The <code>replicationStrategy</code> of a keyspace, the required value is <code>SINGLE_REGION</code> or
     * <code>MULTI_REGION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationStrategy} will return {@link Rs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #replicationStrategyAsString}.
     * </p>
     * 
     * @return The <code>replicationStrategy</code> of a keyspace, the required value is <code>SINGLE_REGION</code> or
     *         <code>MULTI_REGION</code>.
     * @see Rs
     */
    public final String replicationStrategyAsString() {
        return replicationStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegionList() {
        return regionList != null && !(regionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>regionList</code> can contain up to six Amazon Web Services Regions where the keyspace is replicated
     * in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionList} method.
     * </p>
     * 
     * @return The <code>regionList</code> can contain up to six Amazon Web Services Regions where the keyspace is
     *         replicated in.
     */
    public final List<String> regionList() {
        return regionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionList() ? regionList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationSpecification)) {
            return false;
        }
        ReplicationSpecification other = (ReplicationSpecification) obj;
        return Objects.equals(replicationStrategyAsString(), other.replicationStrategyAsString())
                && hasRegionList() == other.hasRegionList() && Objects.equals(regionList(), other.regionList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationSpecification").add("ReplicationStrategy", replicationStrategyAsString())
                .add("RegionList", hasRegionList() ? regionList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replicationStrategy":
            return Optional.ofNullable(clazz.cast(replicationStrategyAsString()));
        case "regionList":
            return Optional.ofNullable(clazz.cast(regionList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("replicationStrategy", REPLICATION_STRATEGY_FIELD);
        map.put("regionList", REGION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationSpecification, T> g) {
        return obj -> g.apply((ReplicationSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationSpecification> {
        /**
         * <p>
         * The <code>replicationStrategy</code> of a keyspace, the required value is <code>SINGLE_REGION</code> or
         * <code>MULTI_REGION</code>.
         * </p>
         * 
         * @param replicationStrategy
         *        The <code>replicationStrategy</code> of a keyspace, the required value is <code>SINGLE_REGION</code>
         *        or <code>MULTI_REGION</code>.
         * @see Rs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Rs
         */
        Builder replicationStrategy(String replicationStrategy);

        /**
         * <p>
         * The <code>replicationStrategy</code> of a keyspace, the required value is <code>SINGLE_REGION</code> or
         * <code>MULTI_REGION</code>.
         * </p>
         * 
         * @param replicationStrategy
         *        The <code>replicationStrategy</code> of a keyspace, the required value is <code>SINGLE_REGION</code>
         *        or <code>MULTI_REGION</code>.
         * @see Rs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Rs
         */
        Builder replicationStrategy(Rs replicationStrategy);

        /**
         * <p>
         * The <code>regionList</code> can contain up to six Amazon Web Services Regions where the keyspace is
         * replicated in.
         * </p>
         * 
         * @param regionList
         *        The <code>regionList</code> can contain up to six Amazon Web Services Regions where the keyspace is
         *        replicated in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionList(Collection<String> regionList);

        /**
         * <p>
         * The <code>regionList</code> can contain up to six Amazon Web Services Regions where the keyspace is
         * replicated in.
         * </p>
         * 
         * @param regionList
         *        The <code>regionList</code> can contain up to six Amazon Web Services Regions where the keyspace is
         *        replicated in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionList(String... regionList);
    }

    static final class BuilderImpl implements Builder {
        private String replicationStrategy;

        private List<String> regionList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationSpecification model) {
            replicationStrategy(model.replicationStrategy);
            regionList(model.regionList);
        }

        public final String getReplicationStrategy() {
            return replicationStrategy;
        }

        public final void setReplicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
        }

        @Override
        public final Builder replicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
            return this;
        }

        @Override
        public final Builder replicationStrategy(Rs replicationStrategy) {
            this.replicationStrategy(replicationStrategy == null ? null : replicationStrategy.toString());
            return this;
        }

        public final Collection<String> getRegionList() {
            if (regionList instanceof SdkAutoConstructList) {
                return null;
            }
            return regionList;
        }

        public final void setRegionList(Collection<String> regionList) {
            this.regionList = RegionListCopier.copy(regionList);
        }

        @Override
        public final Builder regionList(Collection<String> regionList) {
            this.regionList = RegionListCopier.copy(regionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionList(String... regionList) {
            regionList(Arrays.asList(regionList));
            return this;
        }

        @Override
        public ReplicationSpecification build() {
            return new ReplicationSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
