/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum KeyManagerType {
    AWS("AWS"),
    CUSTOMER("CUSTOMER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private KeyManagerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyManagerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(KeyManagerType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyManagerType> knownValues() {
        return Stream.of(KeyManagerType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

