/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KeyMetadata;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeyResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, CreateKeyResponse> {
    private static final SdkField<KeyMetadata> KEY_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyMetadata").getter(CreateKeyResponse.getter(CreateKeyResponse::keyMetadata)).setter(CreateKeyResponse.setter(Builder::keyMetadata)).constructor(KeyMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateKeyResponse.memberNameToFieldInitializer();
    private final KeyMetadata keyMetadata;

    private CreateKeyResponse(BuilderImpl builder) {
        super(builder);
        this.keyMetadata = builder.keyMetadata;
    }

    public final KeyMetadata keyMetadata() {
        return this.keyMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyResponse)) {
            return false;
        }
        CreateKeyResponse other = (CreateKeyResponse)((Object)obj);
        return Objects.equals(this.keyMetadata(), other.keyMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKeyResponse").add("KeyMetadata", (Object)this.keyMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyMetadata": {
                return Optional.ofNullable(clazz.cast(this.keyMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<KeyMetadata>> map = new HashMap<String, SdkField<KeyMetadata>>();
        map.put("KeyMetadata", KEY_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyResponse, T> g) {
        return obj -> g.apply((CreateKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private KeyMetadata keyMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyResponse model) {
            super(model);
            this.keyMetadata(model.keyMetadata);
        }

        public final KeyMetadata.Builder getKeyMetadata() {
            return this.keyMetadata != null ? this.keyMetadata.toBuilder() : null;
        }

        public final void setKeyMetadata(KeyMetadata.BuilderImpl keyMetadata) {
            this.keyMetadata = keyMetadata != null ? keyMetadata.build() : null;
        }

        @Override
        public final Builder keyMetadata(KeyMetadata keyMetadata) {
            this.keyMetadata = keyMetadata;
            return this;
        }

        @Override
        public CreateKeyResponse build() {
            return new CreateKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKeyResponse> {
        public Builder keyMetadata(KeyMetadata var1);

        default public Builder keyMetadata(Consumer<KeyMetadata.Builder> keyMetadata) {
            return this.keyMetadata((KeyMetadata)((KeyMetadata.Builder)KeyMetadata.builder().applyMutation(keyMetadata)).build());
        }
    }
}

