/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.MultiRegionKey;
import software.amazon.awssdk.services.kms.model.MultiRegionKeyListCopier;
import software.amazon.awssdk.services.kms.model.MultiRegionKeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiRegionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiRegionConfiguration> {
    private static final SdkField<String> MULTI_REGION_KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiRegionKeyType").getter(MultiRegionConfiguration.getter(MultiRegionConfiguration::multiRegionKeyTypeAsString)).setter(MultiRegionConfiguration.setter(Builder::multiRegionKeyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionKeyType").build()}).build();
    private static final SdkField<MultiRegionKey> PRIMARY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryKey").getter(MultiRegionConfiguration.getter(MultiRegionConfiguration::primaryKey)).setter(MultiRegionConfiguration.setter(Builder::primaryKey)).constructor(MultiRegionKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryKey").build()}).build();
    private static final SdkField<List<MultiRegionKey>> REPLICA_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicaKeys").getter(MultiRegionConfiguration.getter(MultiRegionConfiguration::replicaKeys)).setter(MultiRegionConfiguration.setter(Builder::replicaKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiRegionKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_REGION_KEY_TYPE_FIELD, PRIMARY_KEY_FIELD, REPLICA_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MultiRegionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String multiRegionKeyType;
    private final MultiRegionKey primaryKey;
    private final List<MultiRegionKey> replicaKeys;

    private MultiRegionConfiguration(BuilderImpl builder) {
        this.multiRegionKeyType = builder.multiRegionKeyType;
        this.primaryKey = builder.primaryKey;
        this.replicaKeys = builder.replicaKeys;
    }

    public final MultiRegionKeyType multiRegionKeyType() {
        return MultiRegionKeyType.fromValue(this.multiRegionKeyType);
    }

    public final String multiRegionKeyTypeAsString() {
        return this.multiRegionKeyType;
    }

    public final MultiRegionKey primaryKey() {
        return this.primaryKey;
    }

    public final boolean hasReplicaKeys() {
        return this.replicaKeys != null && !(this.replicaKeys instanceof SdkAutoConstructList);
    }

    public final List<MultiRegionKey> replicaKeys() {
        return this.replicaKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionKeyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicaKeys() ? this.replicaKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiRegionConfiguration)) {
            return false;
        }
        MultiRegionConfiguration other = (MultiRegionConfiguration)obj;
        return Objects.equals(this.multiRegionKeyTypeAsString(), other.multiRegionKeyTypeAsString()) && Objects.equals(this.primaryKey(), other.primaryKey()) && this.hasReplicaKeys() == other.hasReplicaKeys() && Objects.equals(this.replicaKeys(), other.replicaKeys());
    }

    public final String toString() {
        return ToString.builder((String)"MultiRegionConfiguration").add("MultiRegionKeyType", (Object)this.multiRegionKeyTypeAsString()).add("PrimaryKey", (Object)this.primaryKey()).add("ReplicaKeys", this.hasReplicaKeys() ? this.replicaKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiRegionKeyType": {
                return Optional.ofNullable(clazz.cast(this.multiRegionKeyTypeAsString()));
            }
            case "PrimaryKey": {
                return Optional.ofNullable(clazz.cast(this.primaryKey()));
            }
            case "ReplicaKeys": {
                return Optional.ofNullable(clazz.cast(this.replicaKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MultiRegionKeyType", MULTI_REGION_KEY_TYPE_FIELD);
        map.put("PrimaryKey", PRIMARY_KEY_FIELD);
        map.put("ReplicaKeys", REPLICA_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiRegionConfiguration, T> g) {
        return obj -> g.apply((MultiRegionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String multiRegionKeyType;
        private MultiRegionKey primaryKey;
        private List<MultiRegionKey> replicaKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MultiRegionConfiguration model) {
            this.multiRegionKeyType(model.multiRegionKeyType);
            this.primaryKey(model.primaryKey);
            this.replicaKeys(model.replicaKeys);
        }

        public final String getMultiRegionKeyType() {
            return this.multiRegionKeyType;
        }

        public final void setMultiRegionKeyType(String multiRegionKeyType) {
            this.multiRegionKeyType = multiRegionKeyType;
        }

        @Override
        public final Builder multiRegionKeyType(String multiRegionKeyType) {
            this.multiRegionKeyType = multiRegionKeyType;
            return this;
        }

        @Override
        public final Builder multiRegionKeyType(MultiRegionKeyType multiRegionKeyType) {
            this.multiRegionKeyType(multiRegionKeyType == null ? null : multiRegionKeyType.toString());
            return this;
        }

        public final MultiRegionKey.Builder getPrimaryKey() {
            return this.primaryKey != null ? this.primaryKey.toBuilder() : null;
        }

        public final void setPrimaryKey(MultiRegionKey.BuilderImpl primaryKey) {
            this.primaryKey = primaryKey != null ? primaryKey.build() : null;
        }

        @Override
        public final Builder primaryKey(MultiRegionKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public final List<MultiRegionKey.Builder> getReplicaKeys() {
            List<MultiRegionKey.Builder> result = MultiRegionKeyListCopier.copyToBuilder(this.replicaKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaKeys(Collection<MultiRegionKey.BuilderImpl> replicaKeys) {
            this.replicaKeys = MultiRegionKeyListCopier.copyFromBuilder(replicaKeys);
        }

        @Override
        public final Builder replicaKeys(Collection<MultiRegionKey> replicaKeys) {
            this.replicaKeys = MultiRegionKeyListCopier.copy(replicaKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaKeys(MultiRegionKey ... replicaKeys) {
            this.replicaKeys(Arrays.asList(replicaKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaKeys(Consumer<MultiRegionKey.Builder> ... replicaKeys) {
            this.replicaKeys(Stream.of(replicaKeys).map(c -> (MultiRegionKey)((MultiRegionKey.Builder)MultiRegionKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MultiRegionConfiguration build() {
            return new MultiRegionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiRegionConfiguration> {
        public Builder multiRegionKeyType(String var1);

        public Builder multiRegionKeyType(MultiRegionKeyType var1);

        public Builder primaryKey(MultiRegionKey var1);

        default public Builder primaryKey(Consumer<MultiRegionKey.Builder> primaryKey) {
            return this.primaryKey((MultiRegionKey)((MultiRegionKey.Builder)MultiRegionKey.builder().applyMutation(primaryKey)).build());
        }

        public Builder replicaKeys(Collection<MultiRegionKey> var1);

        public Builder replicaKeys(MultiRegionKey ... var1);

        public Builder replicaKeys(Consumer<MultiRegionKey.Builder> ... var1);
    }
}

