/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeHook
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeHook> {
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CodeHook.getter(CodeHook::uri)).setter(CodeHook.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final SdkField<String> MESSAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CodeHook.getter(CodeHook::messageVersion)).setter(CodeHook.setter(Builder::messageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URI_FIELD, MESSAGE_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String uri;
    private final String messageVersion;

    private CodeHook(BuilderImpl builder) {
        this.uri = builder.uri;
        this.messageVersion = builder.messageVersion;
    }

    public String uri() {
        return this.uri;
    }

    public String messageVersion() {
        return this.messageVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeHook)) {
            return false;
        }
        CodeHook other = (CodeHook)obj;
        return Objects.equals(this.uri(), other.uri()) && Objects.equals(this.messageVersion(), other.messageVersion());
    }

    public String toString() {
        return ToString.builder((String)"CodeHook").add("Uri", (Object)this.uri()).add("MessageVersion", (Object)this.messageVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "messageVersion": {
                return Optional.ofNullable(clazz.cast(this.messageVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeHook, T> g) {
        return obj -> g.apply((CodeHook)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uri;
        private String messageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeHook model) {
            this.uri(model.uri);
            this.messageVersion(model.messageVersion);
        }

        public final String getUri() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getMessageVersion() {
            return this.messageVersion;
        }

        @Override
        public final Builder messageVersion(String messageVersion) {
            this.messageVersion = messageVersion;
            return this;
        }

        public final void setMessageVersion(String messageVersion) {
            this.messageVersion = messageVersion;
        }

        public CodeHook build() {
            return new CodeHook(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeHook> {
        public Builder uri(String var1);

        public Builder messageVersion(String var1);
    }
}

