/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelbuilding.model.Destination;
import software.amazon.awssdk.services.lexmodelbuilding.model.LogType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogSettingsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogSettingsRequest> {
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LogSettingsRequest.getter(LogSettingsRequest::logTypeAsString)).setter(LogSettingsRequest.setter(Builder::logType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logType").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LogSettingsRequest.getter(LogSettingsRequest::destinationAsString)).setter(LogSettingsRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LogSettingsRequest.getter(LogSettingsRequest::kmsKeyArn)).setter(LogSettingsRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LogSettingsRequest.getter(LogSettingsRequest::resourceArn)).setter(LogSettingsRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPE_FIELD, DESTINATION_FIELD, KMS_KEY_ARN_FIELD, RESOURCE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logType;
    private final String destination;
    private final String kmsKeyArn;
    private final String resourceArn;

    private LogSettingsRequest(BuilderImpl builder) {
        this.logType = builder.logType;
        this.destination = builder.destination;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.resourceArn = builder.resourceArn;
    }

    public LogType logType() {
        return LogType.fromValue(this.logType);
    }

    public String logTypeAsString() {
        return this.logType;
    }

    public Destination destination() {
        return Destination.fromValue(this.destination);
    }

    public String destinationAsString() {
        return this.destination;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSettingsRequest)) {
            return false;
        }
        LogSettingsRequest other = (LogSettingsRequest)obj;
        return Objects.equals(this.logTypeAsString(), other.logTypeAsString()) && Objects.equals(this.destinationAsString(), other.destinationAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public String toString() {
        return ToString.builder((String)"LogSettingsRequest").add("LogType", (Object)this.logTypeAsString()).add("Destination", (Object)this.destinationAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logType": {
                return Optional.ofNullable(clazz.cast(this.logTypeAsString()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destinationAsString()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogSettingsRequest, T> g) {
        return obj -> g.apply((LogSettingsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logType;
        private String destination;
        private String kmsKeyArn;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LogSettingsRequest model) {
            this.logType(model.logType);
            this.destination(model.destination);
            this.kmsKeyArn(model.kmsKeyArn);
            this.resourceArn(model.resourceArn);
        }

        public final String getLogTypeAsString() {
            return this.logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        public final String getDestinationAsString() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public LogSettingsRequest build() {
            return new LogSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogSettingsRequest> {
        public Builder logType(String var1);

        public Builder logType(LogType var1);

        public Builder destination(String var1);

        public Builder destination(Destination var1);

        public Builder kmsKeyArn(String var1);

        public Builder resourceArn(String var1);
    }
}

