/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChannelType {
    FACEBOOK("Facebook"),
    SLACK("Slack"),
    TWILIO_SMS("Twilio-Sms"),
    KIK("Kik"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChannelType> VALUE_MAP;
    private final String value;

    private ChannelType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChannelType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChannelType> knownValues() {
        EnumSet<ChannelType> knownValues = EnumSet.allOf(ChannelType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChannelType.class, ChannelType::toString);
    }
}

