/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteKeyPairRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, DeleteKeyPairRequest> {
    private static final SdkField<String> KEY_PAIR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyPairName").getter(DeleteKeyPairRequest.getter(DeleteKeyPairRequest::keyPairName)).setter(DeleteKeyPairRequest.setter(Builder::keyPairName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairName").build()}).build();
    private static final SdkField<String> EXPECTED_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expectedFingerprint").getter(DeleteKeyPairRequest.getter(DeleteKeyPairRequest::expectedFingerprint)).setter(DeleteKeyPairRequest.setter(Builder::expectedFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedFingerprint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIR_NAME_FIELD, EXPECTED_FINGERPRINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteKeyPairRequest.memberNameToFieldInitializer();
    private final String keyPairName;
    private final String expectedFingerprint;

    private DeleteKeyPairRequest(BuilderImpl builder) {
        super(builder);
        this.keyPairName = builder.keyPairName;
        this.expectedFingerprint = builder.expectedFingerprint;
    }

    public final String keyPairName() {
        return this.keyPairName;
    }

    public final String expectedFingerprint() {
        return this.expectedFingerprint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairName());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedFingerprint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteKeyPairRequest)) {
            return false;
        }
        DeleteKeyPairRequest other = (DeleteKeyPairRequest)((Object)obj);
        return Objects.equals(this.keyPairName(), other.keyPairName()) && Objects.equals(this.expectedFingerprint(), other.expectedFingerprint());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteKeyPairRequest").add("KeyPairName", (Object)this.keyPairName()).add("ExpectedFingerprint", (Object)this.expectedFingerprint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyPairName": {
                return Optional.ofNullable(clazz.cast(this.keyPairName()));
            }
            case "expectedFingerprint": {
                return Optional.ofNullable(clazz.cast(this.expectedFingerprint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("keyPairName", KEY_PAIR_NAME_FIELD);
        map.put("expectedFingerprint", EXPECTED_FINGERPRINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteKeyPairRequest, T> g) {
        return obj -> g.apply((DeleteKeyPairRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String keyPairName;
        private String expectedFingerprint;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteKeyPairRequest model) {
            super(model);
            this.keyPairName(model.keyPairName);
            this.expectedFingerprint(model.expectedFingerprint);
        }

        public final String getKeyPairName() {
            return this.keyPairName;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final String getExpectedFingerprint() {
            return this.expectedFingerprint;
        }

        public final void setExpectedFingerprint(String expectedFingerprint) {
            this.expectedFingerprint = expectedFingerprint;
        }

        @Override
        public final Builder expectedFingerprint(String expectedFingerprint) {
            this.expectedFingerprint = expectedFingerprint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteKeyPairRequest build() {
            return new DeleteKeyPairRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteKeyPairRequest> {
        public Builder keyPairName(String var1);

        public Builder expectedFingerprint(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

