/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.TruckDimensions;
import software.amazon.awssdk.services.location.model.TruckWeight;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRouteTruckModeOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CalculateRouteTruckModeOptions> {
    private static final SdkField<Boolean> AVOID_FERRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AvoidFerries").getter(CalculateRouteTruckModeOptions.getter(CalculateRouteTruckModeOptions::avoidFerries)).setter(CalculateRouteTruckModeOptions.setter(Builder::avoidFerries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidFerries").build()}).build();
    private static final SdkField<Boolean> AVOID_TOLLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AvoidTolls").getter(CalculateRouteTruckModeOptions.getter(CalculateRouteTruckModeOptions::avoidTolls)).setter(CalculateRouteTruckModeOptions.setter(Builder::avoidTolls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidTolls").build()}).build();
    private static final SdkField<TruckDimensions> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Dimensions").getter(CalculateRouteTruckModeOptions.getter(CalculateRouteTruckModeOptions::dimensions)).setter(CalculateRouteTruckModeOptions.setter(Builder::dimensions)).constructor(TruckDimensions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()}).build();
    private static final SdkField<TruckWeight> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Weight").getter(CalculateRouteTruckModeOptions.getter(CalculateRouteTruckModeOptions::weight)).setter(CalculateRouteTruckModeOptions.setter(Builder::weight)).constructor(TruckWeight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVOID_FERRIES_FIELD, AVOID_TOLLS_FIELD, DIMENSIONS_FIELD, WEIGHT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AvoidFerries", AVOID_FERRIES_FIELD);
            this.put("AvoidTolls", AVOID_TOLLS_FIELD);
            this.put("Dimensions", DIMENSIONS_FIELD);
            this.put("Weight", WEIGHT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean avoidFerries;
    private final Boolean avoidTolls;
    private final TruckDimensions dimensions;
    private final TruckWeight weight;

    private CalculateRouteTruckModeOptions(BuilderImpl builder) {
        this.avoidFerries = builder.avoidFerries;
        this.avoidTolls = builder.avoidTolls;
        this.dimensions = builder.dimensions;
        this.weight = builder.weight;
    }

    public final Boolean avoidFerries() {
        return this.avoidFerries;
    }

    public final Boolean avoidTolls() {
        return this.avoidTolls;
    }

    public final TruckDimensions dimensions() {
        return this.dimensions;
    }

    public final TruckWeight weight() {
        return this.weight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.avoidFerries());
        hashCode = 31 * hashCode + Objects.hashCode(this.avoidTolls());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteTruckModeOptions)) {
            return false;
        }
        CalculateRouteTruckModeOptions other = (CalculateRouteTruckModeOptions)obj;
        return Objects.equals(this.avoidFerries(), other.avoidFerries()) && Objects.equals(this.avoidTolls(), other.avoidTolls()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.weight(), other.weight());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRouteTruckModeOptions").add("AvoidFerries", (Object)this.avoidFerries()).add("AvoidTolls", (Object)this.avoidTolls()).add("Dimensions", (Object)this.dimensions()).add("Weight", (Object)this.weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvoidFerries": {
                return Optional.ofNullable(clazz.cast(this.avoidFerries()));
            }
            case "AvoidTolls": {
                return Optional.ofNullable(clazz.cast(this.avoidTolls()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteTruckModeOptions, T> g) {
        return obj -> g.apply((CalculateRouteTruckModeOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean avoidFerries;
        private Boolean avoidTolls;
        private TruckDimensions dimensions;
        private TruckWeight weight;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteTruckModeOptions model) {
            this.avoidFerries(model.avoidFerries);
            this.avoidTolls(model.avoidTolls);
            this.dimensions(model.dimensions);
            this.weight(model.weight);
        }

        public final Boolean getAvoidFerries() {
            return this.avoidFerries;
        }

        public final void setAvoidFerries(Boolean avoidFerries) {
            this.avoidFerries = avoidFerries;
        }

        @Override
        public final Builder avoidFerries(Boolean avoidFerries) {
            this.avoidFerries = avoidFerries;
            return this;
        }

        public final Boolean getAvoidTolls() {
            return this.avoidTolls;
        }

        public final void setAvoidTolls(Boolean avoidTolls) {
            this.avoidTolls = avoidTolls;
        }

        @Override
        public final Builder avoidTolls(Boolean avoidTolls) {
            this.avoidTolls = avoidTolls;
            return this;
        }

        public final TruckDimensions.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        public final void setDimensions(TruckDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(TruckDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final TruckWeight.Builder getWeight() {
            return this.weight != null ? this.weight.toBuilder() : null;
        }

        public final void setWeight(TruckWeight.BuilderImpl weight) {
            this.weight = weight != null ? weight.build() : null;
        }

        @Override
        public final Builder weight(TruckWeight weight) {
            this.weight = weight;
            return this;
        }

        public CalculateRouteTruckModeOptions build() {
            return new CalculateRouteTruckModeOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CalculateRouteTruckModeOptions> {
        public Builder avoidFerries(Boolean var1);

        public Builder avoidTolls(Boolean var1);

        public Builder dimensions(TruckDimensions var1);

        default public Builder dimensions(Consumer<TruckDimensions.Builder> dimensions) {
            return this.dimensions((TruckDimensions)((TruckDimensions.Builder)TruckDimensions.builder().applyMutation(dimensions)).build());
        }

        public Builder weight(TruckWeight var1);

        default public Builder weight(Consumer<TruckWeight.Builder> weight) {
            return this.weight((TruckWeight)((TruckWeight.Builder)TruckWeight.builder().applyMutation(weight)).build());
        }
    }
}

