/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.DistanceUnit;
import software.amazon.awssdk.services.location.model.ForecastedEvent;
import software.amazon.awssdk.services.location.model.ForecastedEventsListCopier;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.SpeedUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForecastGeofenceEventsResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, ForecastGeofenceEventsResponse> {
    private static final SdkField<List<ForecastedEvent>> FORECASTED_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastedEvents").getter(ForecastGeofenceEventsResponse.getter(ForecastGeofenceEventsResponse::forecastedEvents)).setter(ForecastGeofenceEventsResponse.setter(Builder::forecastedEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastedEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ForecastedEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ForecastGeofenceEventsResponse.getter(ForecastGeofenceEventsResponse::nextToken)).setter(ForecastGeofenceEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistanceUnit").getter(ForecastGeofenceEventsResponse.getter(ForecastGeofenceEventsResponse::distanceUnitAsString)).setter(ForecastGeofenceEventsResponse.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final SdkField<String> SPEED_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpeedUnit").getter(ForecastGeofenceEventsResponse.getter(ForecastGeofenceEventsResponse::speedUnitAsString)).setter(ForecastGeofenceEventsResponse.setter(Builder::speedUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeedUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECASTED_EVENTS_FIELD, NEXT_TOKEN_FIELD, DISTANCE_UNIT_FIELD, SPEED_UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ForecastedEvents", FORECASTED_EVENTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("DistanceUnit", DISTANCE_UNIT_FIELD);
            this.put("SpeedUnit", SPEED_UNIT_FIELD);
        }
    });
    private final List<ForecastedEvent> forecastedEvents;
    private final String nextToken;
    private final String distanceUnit;
    private final String speedUnit;

    private ForecastGeofenceEventsResponse(BuilderImpl builder) {
        super(builder);
        this.forecastedEvents = builder.forecastedEvents;
        this.nextToken = builder.nextToken;
        this.distanceUnit = builder.distanceUnit;
        this.speedUnit = builder.speedUnit;
    }

    public final boolean hasForecastedEvents() {
        return this.forecastedEvents != null && !(this.forecastedEvents instanceof SdkAutoConstructList);
    }

    public final List<ForecastedEvent> forecastedEvents() {
        return this.forecastedEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public final String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public final SpeedUnit speedUnit() {
        return SpeedUnit.fromValue(this.speedUnit);
    }

    public final String speedUnitAsString() {
        return this.speedUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastedEvents() ? this.forecastedEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.speedUnitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastGeofenceEventsResponse)) {
            return false;
        }
        ForecastGeofenceEventsResponse other = (ForecastGeofenceEventsResponse)((Object)obj);
        return this.hasForecastedEvents() == other.hasForecastedEvents() && Objects.equals(this.forecastedEvents(), other.forecastedEvents()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString()) && Objects.equals(this.speedUnitAsString(), other.speedUnitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ForecastGeofenceEventsResponse").add("ForecastedEvents", this.hasForecastedEvents() ? this.forecastedEvents() : null).add("NextToken", (Object)this.nextToken()).add("DistanceUnit", (Object)this.distanceUnitAsString()).add("SpeedUnit", (Object)this.speedUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastedEvents": {
                return Optional.ofNullable(clazz.cast(this.forecastedEvents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
            case "SpeedUnit": {
                return Optional.ofNullable(clazz.cast(this.speedUnitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ForecastGeofenceEventsResponse, T> g) {
        return obj -> g.apply((ForecastGeofenceEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private List<ForecastedEvent> forecastedEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String distanceUnit;
        private String speedUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastGeofenceEventsResponse model) {
            super(model);
            this.forecastedEvents(model.forecastedEvents);
            this.nextToken(model.nextToken);
            this.distanceUnit(model.distanceUnit);
            this.speedUnit(model.speedUnit);
        }

        public final List<ForecastedEvent.Builder> getForecastedEvents() {
            List<ForecastedEvent.Builder> result = ForecastedEventsListCopier.copyToBuilder(this.forecastedEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForecastedEvents(Collection<ForecastedEvent.BuilderImpl> forecastedEvents) {
            this.forecastedEvents = ForecastedEventsListCopier.copyFromBuilder(forecastedEvents);
        }

        @Override
        public final Builder forecastedEvents(Collection<ForecastedEvent> forecastedEvents) {
            this.forecastedEvents = ForecastedEventsListCopier.copy(forecastedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastedEvents(ForecastedEvent ... forecastedEvents) {
            this.forecastedEvents(Arrays.asList(forecastedEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastedEvents(Consumer<ForecastedEvent.Builder> ... forecastedEvents) {
            this.forecastedEvents(Stream.of(forecastedEvents).map(c -> (ForecastedEvent)((ForecastedEvent.Builder)ForecastedEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final String getSpeedUnit() {
            return this.speedUnit;
        }

        public final void setSpeedUnit(String speedUnit) {
            this.speedUnit = speedUnit;
        }

        @Override
        public final Builder speedUnit(String speedUnit) {
            this.speedUnit = speedUnit;
            return this;
        }

        @Override
        public final Builder speedUnit(SpeedUnit speedUnit) {
            this.speedUnit(speedUnit == null ? null : speedUnit.toString());
            return this;
        }

        @Override
        public ForecastGeofenceEventsResponse build() {
            return new ForecastGeofenceEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ForecastGeofenceEventsResponse> {
        public Builder forecastedEvents(Collection<ForecastedEvent> var1);

        public Builder forecastedEvents(ForecastedEvent ... var1);

        public Builder forecastedEvents(Consumer<ForecastedEvent.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder speedUnit(String var1);

        public Builder speedUnit(SpeedUnit var1);
    }
}

