/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPlaceIndexForPositionRequest extends LocationRequest implements
        ToCopyableBuilder<SearchPlaceIndexForPositionRequest.Builder, SearchPlaceIndexForPositionRequest> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(SearchPlaceIndexForPositionRequest::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IndexName").build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(SearchPlaceIndexForPositionRequest::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchPlaceIndexForPositionRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(SearchPlaceIndexForPositionRequest::language))
            .setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(SearchPlaceIndexForPositionRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            POSITION_FIELD, MAX_RESULTS_FIELD, LANGUAGE_FIELD, KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexName;

    private final List<Double> position;

    private final Integer maxResults;

    private final String language;

    private final String key;

    private SearchPlaceIndexForPositionRequest(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.position = builder.position;
        this.maxResults = builder.maxResults;
        this.language = builder.language;
        this.key = builder.key;
    }

    /**
     * <p>
     * The name of the place index resource you want to use for the search.
     * </p>
     * 
     * @return The name of the place index resource you want to use for the search.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the longitude and latitude of the position to query.
     * </p>
     * <p>
     * This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the
     * second number represents the Y coordinate, or latitude.
     * </p>
     * <p>
     * For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code> and
     * latitude <code>49.2847</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return Specifies the longitude and latitude of the position to query.</p>
     *         <p>
     *         This parameter must contain a pair of numbers. The first number represents the X coordinate, or
     *         longitude; the second number represents the Y coordinate, or latitude.
     *         </p>
     *         <p>
     *         For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude
     *         <code>-123.1174</code> and latitude <code>49.2847</code>.
     */
    public final List<Double> position() {
        return position;
    }

    /**
     * <p>
     * An optional parameter. The maximum number of results returned per request.
     * </p>
     * <p>
     * Default value: <code>50</code>
     * </p>
     * 
     * @return An optional parameter. The maximum number of results returned per request.</p>
     *         <p>
     *         Default value: <code>50</code>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The preferred language used to return results. The value must be a valid <a
     * href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.
     * </p>
     * <p>
     * This setting affects the languages used in the results, but not the results themselves. If no language is
     * specified, or not supported for a particular result, the partner automatically chooses a language for the result.
     * </p>
     * <p>
     * For an example, we'll use the Greek language. You search for a location around Athens, Greece, with the
     * <code>language</code> parameter set to <code>en</code>. The <code>city</code> in the results will most likely be
     * returned as <code>Athens</code>.
     * </p>
     * <p>
     * If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the <code>city</code> in the
     * results will more likely be returned as <code>Αθήνα</code>.
     * </p>
     * <p>
     * If the data provider does not have a value for Greek, the result will be in a language that the provider does
     * support.
     * </p>
     * 
     * @return The preferred language used to return results. The value must be a valid <a
     *         href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for
     *         English.</p>
     *         <p>
     *         This setting affects the languages used in the results, but not the results themselves. If no language is
     *         specified, or not supported for a particular result, the partner automatically chooses a language for the
     *         result.
     *         </p>
     *         <p>
     *         For an example, we'll use the Greek language. You search for a location around Athens, Greece, with the
     *         <code>language</code> parameter set to <code>en</code>. The <code>city</code> in the results will most
     *         likely be returned as <code>Athens</code>.
     *         </p>
     *         <p>
     *         If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the <code>city</code>
     *         in the results will more likely be returned as <code>Αθήνα</code>.
     *         </p>
     *         <p>
     *         If the data provider does not have a value for Greek, the result will be in a language that the provider
     *         does support.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The optional <a href="https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html">API key</a>
     * to authorize the request.
     * </p>
     * 
     * @return The optional <a href="https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html">API
     *         key</a> to authorize the request.
     */
    public final String key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForPositionRequest)) {
            return false;
        }
        SearchPlaceIndexForPositionRequest other = (SearchPlaceIndexForPositionRequest) obj;
        return Objects.equals(indexName(), other.indexName()) && hasPosition() == other.hasPosition()
                && Objects.equals(position(), other.position()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(language(), other.language()) && Objects.equals(key(), other.key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPlaceIndexForPositionRequest").add("IndexName", indexName())
                .add("Position", position() == null ? null : "*** Sensitive Data Redacted ***").add("MaxResults", maxResults())
                .add("Language", language()).add("Key", key() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForPositionRequest, T> g) {
        return obj -> g.apply((SearchPlaceIndexForPositionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchPlaceIndexForPositionRequest> {
        /**
         * <p>
         * The name of the place index resource you want to use for the search.
         * </p>
         * 
         * @param indexName
         *        The name of the place index resource you want to use for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * Specifies the longitude and latitude of the position to query.
         * </p>
         * <p>
         * This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude;
         * the second number represents the Y coordinate, or latitude.
         * </p>
         * <p>
         * For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code>
         * and latitude <code>49.2847</code>.
         * </p>
         * 
         * @param position
         *        Specifies the longitude and latitude of the position to query.</p>
         *        <p>
         *        This parameter must contain a pair of numbers. The first number represents the X coordinate, or
         *        longitude; the second number represents the Y coordinate, or latitude.
         *        </p>
         *        <p>
         *        For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude
         *        <code>-123.1174</code> and latitude <code>49.2847</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * Specifies the longitude and latitude of the position to query.
         * </p>
         * <p>
         * This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude;
         * the second number represents the Y coordinate, or latitude.
         * </p>
         * <p>
         * For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code>
         * and latitude <code>49.2847</code>.
         * </p>
         * 
         * @param position
         *        Specifies the longitude and latitude of the position to query.</p>
         *        <p>
         *        This parameter must contain a pair of numbers. The first number represents the X coordinate, or
         *        longitude; the second number represents the Y coordinate, or latitude.
         *        </p>
         *        <p>
         *        For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude
         *        <code>-123.1174</code> and latitude <code>49.2847</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);

        /**
         * <p>
         * An optional parameter. The maximum number of results returned per request.
         * </p>
         * <p>
         * Default value: <code>50</code>
         * </p>
         * 
         * @param maxResults
         *        An optional parameter. The maximum number of results returned per request.</p>
         *        <p>
         *        Default value: <code>50</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The preferred language used to return results. The value must be a valid <a
         * href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.
         * </p>
         * <p>
         * This setting affects the languages used in the results, but not the results themselves. If no language is
         * specified, or not supported for a particular result, the partner automatically chooses a language for the
         * result.
         * </p>
         * <p>
         * For an example, we'll use the Greek language. You search for a location around Athens, Greece, with the
         * <code>language</code> parameter set to <code>en</code>. The <code>city</code> in the results will most likely
         * be returned as <code>Athens</code>.
         * </p>
         * <p>
         * If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the <code>city</code> in
         * the results will more likely be returned as <code>Αθήνα</code>.
         * </p>
         * <p>
         * If the data provider does not have a value for Greek, the result will be in a language that the provider does
         * support.
         * </p>
         * 
         * @param language
         *        The preferred language used to return results. The value must be a valid <a
         *        href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for
         *        English.</p>
         *        <p>
         *        This setting affects the languages used in the results, but not the results themselves. If no language
         *        is specified, or not supported for a particular result, the partner automatically chooses a language
         *        for the result.
         *        </p>
         *        <p>
         *        For an example, we'll use the Greek language. You search for a location around Athens, Greece, with
         *        the <code>language</code> parameter set to <code>en</code>. The <code>city</code> in the results will
         *        most likely be returned as <code>Athens</code>.
         *        </p>
         *        <p>
         *        If you set the <code>language</code> parameter to <code>el</code>, for Greek, then the
         *        <code>city</code> in the results will more likely be returned as <code>Αθήνα</code>.
         *        </p>
         *        <p>
         *        If the data provider does not have a value for Greek, the result will be in a language that the
         *        provider does support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The optional <a href="https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html">API
         * key</a> to authorize the request.
         * </p>
         * 
         * @param key
         *        The optional <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html">API key</a> to
         *        authorize the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String indexName;

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String language;

        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForPositionRequest model) {
            super(model);
            indexName(model.indexName);
            position(model.position);
            maxResults(model.maxResults);
            language(model.language);
            key(model.key);
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchPlaceIndexForPositionRequest build() {
            return new SearchPlaceIndexForPositionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
