/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Wi-Fi access point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WiFiAccessPoint implements SdkPojo, Serializable, ToCopyableBuilder<WiFiAccessPoint.Builder, WiFiAccessPoint> {
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MacAddress").getter(getter(WiFiAccessPoint::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").build()).build();

    private static final SdkField<Integer> RSS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rss")
            .getter(getter(WiFiAccessPoint::rss)).setter(setter(Builder::rss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rss").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAC_ADDRESS_FIELD, RSS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String macAddress;

    private final Integer rss;

    private WiFiAccessPoint(BuilderImpl builder) {
        this.macAddress = builder.macAddress;
        this.rss = builder.rss;
    }

    /**
     * <p>
     * Medium access control address (Mac).
     * </p>
     * 
     * @return Medium access control address (Mac).
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * Received signal strength (dBm) of the WLAN measurement data.
     * </p>
     * 
     * @return Received signal strength (dBm) of the WLAN measurement data.
     */
    public final Integer rss() {
        return rss;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(rss());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WiFiAccessPoint)) {
            return false;
        }
        WiFiAccessPoint other = (WiFiAccessPoint) obj;
        return Objects.equals(macAddress(), other.macAddress()) && Objects.equals(rss(), other.rss());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WiFiAccessPoint").add("MacAddress", macAddress()).add("Rss", rss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "Rss":
            return Optional.ofNullable(clazz.cast(rss()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MacAddress", MAC_ADDRESS_FIELD);
        map.put("Rss", RSS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WiFiAccessPoint, T> g) {
        return obj -> g.apply((WiFiAccessPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WiFiAccessPoint> {
        /**
         * <p>
         * Medium access control address (Mac).
         * </p>
         * 
         * @param macAddress
         *        Medium access control address (Mac).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * Received signal strength (dBm) of the WLAN measurement data.
         * </p>
         * 
         * @param rss
         *        Received signal strength (dBm) of the WLAN measurement data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rss(Integer rss);
    }

    static final class BuilderImpl implements Builder {
        private String macAddress;

        private Integer rss;

        private BuilderImpl() {
        }

        private BuilderImpl(WiFiAccessPoint model) {
            macAddress(model.macAddress);
            rss(model.rss);
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final Integer getRss() {
            return rss;
        }

        public final void setRss(Integer rss) {
            this.rss = rss;
        }

        @Override
        public final Builder rss(Integer rss) {
            this.rss = rss;
            return this;
        }

        @Override
        public WiFiAccessPoint build() {
            return new WiFiAccessPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
