/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse;

public class ListInferenceExecutionsPublisher
implements SdkPublisher<ListInferenceExecutionsResponse> {
    private final LookoutEquipmentAsyncClient client;
    private final ListInferenceExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInferenceExecutionsPublisher(LookoutEquipmentAsyncClient client, ListInferenceExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInferenceExecutionsPublisher(LookoutEquipmentAsyncClient client, ListInferenceExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInferenceExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInferenceExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListInferenceExecutionsResponseFetcher
    implements AsyncPageFetcher<ListInferenceExecutionsResponse> {
        private ListInferenceExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInferenceExecutionsResponse> nextPage(ListInferenceExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceExecutionsPublisher.this.client.listInferenceExecutions(ListInferenceExecutionsPublisher.this.firstRequest);
            }
            return ListInferenceExecutionsPublisher.this.client.listInferenceExecutions((ListInferenceExecutionsRequest)((Object)ListInferenceExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

