/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.DataQualitySummary;
import software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus;
import software.amazon.awssdk.services.lookoutequipment.model.IngestedFilesSummary;
import software.amazon.awssdk.services.lookoutequipment.model.IngestionInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDatasetResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, DescribeDatasetResponse> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetName)).setter(DescribeDatasetResponse.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::datasetArn)).setter(DescribeDatasetResponse.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::createdAt)).setter(DescribeDatasetResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::lastUpdatedAt)).setter(DescribeDatasetResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::statusAsString)).setter(DescribeDatasetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::schema)).setter(DescribeDatasetResponse.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSideKmsKeyId").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::serverSideKmsKeyId)).setter(DescribeDatasetResponse.setter(Builder::serverSideKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build()}).build();
    private static final SdkField<IngestionInputConfiguration> INGESTION_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngestionInputConfiguration").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::ingestionInputConfiguration)).setter(DescribeDatasetResponse.setter(Builder::ingestionInputConfiguration)).constructor(IngestionInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionInputConfiguration").build()}).build();
    private static final SdkField<DataQualitySummary> DATA_QUALITY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualitySummary").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::dataQualitySummary)).setter(DescribeDatasetResponse.setter(Builder::dataQualitySummary)).constructor(DataQualitySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySummary").build()}).build();
    private static final SdkField<IngestedFilesSummary> INGESTED_FILES_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngestedFilesSummary").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::ingestedFilesSummary)).setter(DescribeDatasetResponse.setter(Builder::ingestedFilesSummary)).constructor(IngestedFilesSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestedFilesSummary").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::roleArn)).setter(DescribeDatasetResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Instant> DATA_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataStartTime").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::dataStartTime)).setter(DescribeDatasetResponse.setter(Builder::dataStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStartTime").build()}).build();
    private static final SdkField<Instant> DATA_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataEndTime").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::dataEndTime)).setter(DescribeDatasetResponse.setter(Builder::dataEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEndTime").build()}).build();
    private static final SdkField<String> SOURCE_DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDatasetArn").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::sourceDatasetArn)).setter(DescribeDatasetResponse.setter(Builder::sourceDatasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDatasetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD, DATASET_ARN_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, STATUS_FIELD, SCHEMA_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, INGESTION_INPUT_CONFIGURATION_FIELD, DATA_QUALITY_SUMMARY_FIELD, INGESTED_FILES_SUMMARY_FIELD, ROLE_ARN_FIELD, DATA_START_TIME_FIELD, DATA_END_TIME_FIELD, SOURCE_DATASET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatasetName", DATASET_NAME_FIELD);
            this.put("DatasetArn", DATASET_ARN_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Schema", SCHEMA_FIELD);
            this.put("ServerSideKmsKeyId", SERVER_SIDE_KMS_KEY_ID_FIELD);
            this.put("IngestionInputConfiguration", INGESTION_INPUT_CONFIGURATION_FIELD);
            this.put("DataQualitySummary", DATA_QUALITY_SUMMARY_FIELD);
            this.put("IngestedFilesSummary", INGESTED_FILES_SUMMARY_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("DataStartTime", DATA_START_TIME_FIELD);
            this.put("DataEndTime", DATA_END_TIME_FIELD);
            this.put("SourceDatasetArn", SOURCE_DATASET_ARN_FIELD);
        }
    });
    private final String datasetName;
    private final String datasetArn;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String status;
    private final String schema;
    private final String serverSideKmsKeyId;
    private final IngestionInputConfiguration ingestionInputConfiguration;
    private final DataQualitySummary dataQualitySummary;
    private final IngestedFilesSummary ingestedFilesSummary;
    private final String roleArn;
    private final Instant dataStartTime;
    private final Instant dataEndTime;
    private final String sourceDatasetArn;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.status = builder.status;
        this.schema = builder.schema;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.ingestionInputConfiguration = builder.ingestionInputConfiguration;
        this.dataQualitySummary = builder.dataQualitySummary;
        this.ingestedFilesSummary = builder.ingestedFilesSummary;
        this.roleArn = builder.roleArn;
        this.dataStartTime = builder.dataStartTime;
        this.dataEndTime = builder.dataEndTime;
        this.sourceDatasetArn = builder.sourceDatasetArn;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final DatasetStatus status() {
        return DatasetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String schema() {
        return this.schema;
    }

    public final String serverSideKmsKeyId() {
        return this.serverSideKmsKeyId;
    }

    public final IngestionInputConfiguration ingestionInputConfiguration() {
        return this.ingestionInputConfiguration;
    }

    public final DataQualitySummary dataQualitySummary() {
        return this.dataQualitySummary;
    }

    public final IngestedFilesSummary ingestedFilesSummary() {
        return this.ingestedFilesSummary;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant dataStartTime() {
        return this.dataStartTime;
    }

    public final Instant dataEndTime() {
        return this.dataEndTime;
    }

    public final String sourceDatasetArn() {
        return this.sourceDatasetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualitySummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestedFilesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDatasetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse)((Object)obj);
        return Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.serverSideKmsKeyId(), other.serverSideKmsKeyId()) && Objects.equals(this.ingestionInputConfiguration(), other.ingestionInputConfiguration()) && Objects.equals(this.dataQualitySummary(), other.dataQualitySummary()) && Objects.equals(this.ingestedFilesSummary(), other.ingestedFilesSummary()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.dataStartTime(), other.dataStartTime()) && Objects.equals(this.dataEndTime(), other.dataEndTime()) && Objects.equals(this.sourceDatasetArn(), other.sourceDatasetArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDatasetResponse").add("DatasetName", (Object)this.datasetName()).add("DatasetArn", (Object)this.datasetArn()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Status", (Object)this.statusAsString()).add("Schema", (Object)this.schema()).add("ServerSideKmsKeyId", (Object)this.serverSideKmsKeyId()).add("IngestionInputConfiguration", (Object)this.ingestionInputConfiguration()).add("DataQualitySummary", (Object)this.dataQualitySummary()).add("IngestedFilesSummary", (Object)this.ingestedFilesSummary()).add("RoleArn", (Object)this.roleArn()).add("DataStartTime", (Object)this.dataStartTime()).add("DataEndTime", (Object)this.dataEndTime()).add("SourceDatasetArn", (Object)this.sourceDatasetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "ServerSideKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideKmsKeyId()));
            }
            case "IngestionInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingestionInputConfiguration()));
            }
            case "DataQualitySummary": {
                return Optional.ofNullable(clazz.cast(this.dataQualitySummary()));
            }
            case "IngestedFilesSummary": {
                return Optional.ofNullable(clazz.cast(this.ingestedFilesSummary()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "DataStartTime": {
                return Optional.ofNullable(clazz.cast(this.dataStartTime()));
            }
            case "DataEndTime": {
                return Optional.ofNullable(clazz.cast(this.dataEndTime()));
            }
            case "SourceDatasetArn": {
                return Optional.ofNullable(clazz.cast(this.sourceDatasetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String datasetName;
        private String datasetArn;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String status;
        private String schema;
        private String serverSideKmsKeyId;
        private IngestionInputConfiguration ingestionInputConfiguration;
        private DataQualitySummary dataQualitySummary;
        private IngestedFilesSummary ingestedFilesSummary;
        private String roleArn;
        private Instant dataStartTime;
        private Instant dataEndTime;
        private String sourceDatasetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            this.datasetName(model.datasetName);
            this.datasetArn(model.datasetArn);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.status(model.status);
            this.schema(model.schema);
            this.serverSideKmsKeyId(model.serverSideKmsKeyId);
            this.ingestionInputConfiguration(model.ingestionInputConfiguration);
            this.dataQualitySummary(model.dataQualitySummary);
            this.ingestedFilesSummary(model.ingestedFilesSummary);
            this.roleArn(model.roleArn);
            this.dataStartTime(model.dataStartTime);
            this.dataEndTime(model.dataEndTime);
            this.sourceDatasetArn(model.sourceDatasetArn);
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return this.serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final IngestionInputConfiguration.Builder getIngestionInputConfiguration() {
            return this.ingestionInputConfiguration != null ? this.ingestionInputConfiguration.toBuilder() : null;
        }

        public final void setIngestionInputConfiguration(IngestionInputConfiguration.BuilderImpl ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration != null ? ingestionInputConfiguration.build() : null;
        }

        @Override
        public final Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration;
            return this;
        }

        public final DataQualitySummary.Builder getDataQualitySummary() {
            return this.dataQualitySummary != null ? this.dataQualitySummary.toBuilder() : null;
        }

        public final void setDataQualitySummary(DataQualitySummary.BuilderImpl dataQualitySummary) {
            this.dataQualitySummary = dataQualitySummary != null ? dataQualitySummary.build() : null;
        }

        @Override
        public final Builder dataQualitySummary(DataQualitySummary dataQualitySummary) {
            this.dataQualitySummary = dataQualitySummary;
            return this;
        }

        public final IngestedFilesSummary.Builder getIngestedFilesSummary() {
            return this.ingestedFilesSummary != null ? this.ingestedFilesSummary.toBuilder() : null;
        }

        public final void setIngestedFilesSummary(IngestedFilesSummary.BuilderImpl ingestedFilesSummary) {
            this.ingestedFilesSummary = ingestedFilesSummary != null ? ingestedFilesSummary.build() : null;
        }

        @Override
        public final Builder ingestedFilesSummary(IngestedFilesSummary ingestedFilesSummary) {
            this.ingestedFilesSummary = ingestedFilesSummary;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getDataStartTime() {
            return this.dataStartTime;
        }

        public final void setDataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
        }

        @Override
        public final Builder dataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
            return this;
        }

        public final Instant getDataEndTime() {
            return this.dataEndTime;
        }

        public final void setDataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
        }

        @Override
        public final Builder dataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
            return this;
        }

        public final String getSourceDatasetArn() {
            return this.sourceDatasetArn;
        }

        public final void setSourceDatasetArn(String sourceDatasetArn) {
            this.sourceDatasetArn = sourceDatasetArn;
        }

        @Override
        public final Builder sourceDatasetArn(String sourceDatasetArn) {
            this.sourceDatasetArn = sourceDatasetArn;
            return this;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDatasetResponse> {
        public Builder datasetName(String var1);

        public Builder datasetArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(DatasetStatus var1);

        public Builder schema(String var1);

        public Builder serverSideKmsKeyId(String var1);

        public Builder ingestionInputConfiguration(IngestionInputConfiguration var1);

        default public Builder ingestionInputConfiguration(Consumer<IngestionInputConfiguration.Builder> ingestionInputConfiguration) {
            return this.ingestionInputConfiguration((IngestionInputConfiguration)((IngestionInputConfiguration.Builder)IngestionInputConfiguration.builder().applyMutation(ingestionInputConfiguration)).build());
        }

        public Builder dataQualitySummary(DataQualitySummary var1);

        default public Builder dataQualitySummary(Consumer<DataQualitySummary.Builder> dataQualitySummary) {
            return this.dataQualitySummary((DataQualitySummary)((DataQualitySummary.Builder)DataQualitySummary.builder().applyMutation(dataQualitySummary)).build());
        }

        public Builder ingestedFilesSummary(IngestedFilesSummary var1);

        default public Builder ingestedFilesSummary(Consumer<IngestedFilesSummary.Builder> ingestedFilesSummary) {
            return this.ingestedFilesSummary((IngestedFilesSummary)((IngestedFilesSummary.Builder)IngestedFilesSummary.builder().applyMutation(ingestedFilesSummary)).build());
        }

        public Builder roleArn(String var1);

        public Builder dataStartTime(Instant var1);

        public Builder dataEndTime(Instant var1);

        public Builder sourceDatasetArn(String var1);
    }
}

