/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.RelationshipType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InterMetricImpactDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InterMetricImpactDetails> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(InterMetricImpactDetails.getter(InterMetricImpactDetails::metricName)).setter(InterMetricImpactDetails.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyGroupId").getter(InterMetricImpactDetails.getter(InterMetricImpactDetails::anomalyGroupId)).setter(InterMetricImpactDetails.setter(Builder::anomalyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()}).build();
    private static final SdkField<String> RELATIONSHIP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelationshipType").getter(InterMetricImpactDetails.getter(InterMetricImpactDetails::relationshipTypeAsString)).setter(InterMetricImpactDetails.setter(Builder::relationshipType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationshipType").build()}).build();
    private static final SdkField<Double> CONTRIBUTION_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ContributionPercentage").getter(InterMetricImpactDetails.getter(InterMetricImpactDetails::contributionPercentage)).setter(InterMetricImpactDetails.setter(Builder::contributionPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, ANOMALY_GROUP_ID_FIELD, RELATIONSHIP_TYPE_FIELD, CONTRIBUTION_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MetricName", METRIC_NAME_FIELD);
            this.put("AnomalyGroupId", ANOMALY_GROUP_ID_FIELD);
            this.put("RelationshipType", RELATIONSHIP_TYPE_FIELD);
            this.put("ContributionPercentage", CONTRIBUTION_PERCENTAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String anomalyGroupId;
    private final String relationshipType;
    private final Double contributionPercentage;

    private InterMetricImpactDetails(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.anomalyGroupId = builder.anomalyGroupId;
        this.relationshipType = builder.relationshipType;
        this.contributionPercentage = builder.contributionPercentage;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String anomalyGroupId() {
        return this.anomalyGroupId;
    }

    public final RelationshipType relationshipType() {
        return RelationshipType.fromValue(this.relationshipType);
    }

    public final String relationshipTypeAsString() {
        return this.relationshipType;
    }

    public final Double contributionPercentage() {
        return this.contributionPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contributionPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterMetricImpactDetails)) {
            return false;
        }
        InterMetricImpactDetails other = (InterMetricImpactDetails)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.anomalyGroupId(), other.anomalyGroupId()) && Objects.equals(this.relationshipTypeAsString(), other.relationshipTypeAsString()) && Objects.equals(this.contributionPercentage(), other.contributionPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"InterMetricImpactDetails").add("MetricName", (Object)this.metricName()).add("AnomalyGroupId", (Object)this.anomalyGroupId()).add("RelationshipType", (Object)this.relationshipTypeAsString()).add("ContributionPercentage", (Object)this.contributionPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "AnomalyGroupId": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupId()));
            }
            case "RelationshipType": {
                return Optional.ofNullable(clazz.cast(this.relationshipTypeAsString()));
            }
            case "ContributionPercentage": {
                return Optional.ofNullable(clazz.cast(this.contributionPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InterMetricImpactDetails, T> g) {
        return obj -> g.apply((InterMetricImpactDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String anomalyGroupId;
        private String relationshipType;
        private Double contributionPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(InterMetricImpactDetails model) {
            this.metricName(model.metricName);
            this.anomalyGroupId(model.anomalyGroupId);
            this.relationshipType(model.relationshipType);
            this.contributionPercentage(model.contributionPercentage);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getAnomalyGroupId() {
            return this.anomalyGroupId;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        @Override
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final String getRelationshipType() {
            return this.relationshipType;
        }

        public final void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        @Override
        public final Builder relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        public final Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType(relationshipType == null ? null : relationshipType.toString());
            return this;
        }

        public final Double getContributionPercentage() {
            return this.contributionPercentage;
        }

        public final void setContributionPercentage(Double contributionPercentage) {
            this.contributionPercentage = contributionPercentage;
        }

        @Override
        public final Builder contributionPercentage(Double contributionPercentage) {
            this.contributionPercentage = contributionPercentage;
            return this;
        }

        public InterMetricImpactDetails build() {
            return new InterMetricImpactDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InterMetricImpactDetails> {
        public Builder metricName(String var1);

        public Builder anomalyGroupId(String var1);

        public Builder relationshipType(String var1);

        public Builder relationshipType(RelationshipType var1);

        public Builder contributionPercentage(Double var1);
    }
}

