/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.AggregationFunction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Metric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Metric> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(Metric.getter(Metric::metricName)).setter(Metric.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationFunction").getter(Metric.getter(Metric::aggregationFunctionAsString)).setter(Metric.setter(Builder::aggregationFunction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(Metric.getter(Metric::namespace)).setter(Metric.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, AGGREGATION_FUNCTION_FIELD, NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MetricName", METRIC_NAME_FIELD);
            this.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
            this.put("Namespace", NAMESPACE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String aggregationFunction;
    private final String namespace;

    private Metric(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.aggregationFunction = builder.aggregationFunction;
        this.namespace = builder.namespace;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final AggregationFunction aggregationFunction() {
        return AggregationFunction.fromValue(this.aggregationFunction);
    }

    public final String aggregationFunctionAsString() {
        return this.aggregationFunction;
    }

    public final String namespace() {
        return this.namespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.aggregationFunctionAsString(), other.aggregationFunctionAsString()) && Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"Metric").add("MetricName", (Object)this.metricName()).add("AggregationFunction", (Object)this.aggregationFunctionAsString()).add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "AggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.aggregationFunctionAsString()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Metric, T> g) {
        return obj -> g.apply((Metric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String aggregationFunction;
        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(Metric model) {
            this.metricName(model.metricName);
            this.aggregationFunction(model.aggregationFunction);
            this.namespace(model.namespace);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getAggregationFunction() {
            return this.aggregationFunction;
        }

        public final void setAggregationFunction(String aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
        }

        @Override
        public final Builder aggregationFunction(String aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        @Override
        public final Builder aggregationFunction(AggregationFunction aggregationFunction) {
            this.aggregationFunction(aggregationFunction == null ? null : aggregationFunction.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Metric build() {
            return new Metric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Metric> {
        public Builder metricName(String var1);

        public Builder aggregationFunction(String var1);

        public Builder aggregationFunction(AggregationFunction var1);

        public Builder namespace(String var1);
    }
}

