/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies a specific batch job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchJobIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchJobIdentifier.Builder, BatchJobIdentifier> {
    private static final SdkField<FileBatchJobIdentifier> FILE_BATCH_JOB_IDENTIFIER_FIELD = SdkField
            .<FileBatchJobIdentifier> builder(MarshallingType.SDK_POJO).memberName("fileBatchJobIdentifier")
            .getter(getter(BatchJobIdentifier::fileBatchJobIdentifier)).setter(setter(Builder::fileBatchJobIdentifier))
            .constructor(FileBatchJobIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileBatchJobIdentifier").build())
            .build();

    private static final SdkField<RestartBatchJobIdentifier> RESTART_BATCH_JOB_IDENTIFIER_FIELD = SdkField
            .<RestartBatchJobIdentifier> builder(MarshallingType.SDK_POJO).memberName("restartBatchJobIdentifier")
            .getter(getter(BatchJobIdentifier::restartBatchJobIdentifier)).setter(setter(Builder::restartBatchJobIdentifier))
            .constructor(RestartBatchJobIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartBatchJobIdentifier").build())
            .build();

    private static final SdkField<S3BatchJobIdentifier> S3_BATCH_JOB_IDENTIFIER_FIELD = SdkField
            .<S3BatchJobIdentifier> builder(MarshallingType.SDK_POJO).memberName("s3BatchJobIdentifier")
            .getter(getter(BatchJobIdentifier::s3BatchJobIdentifier)).setter(setter(Builder::s3BatchJobIdentifier))
            .constructor(S3BatchJobIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BatchJobIdentifier").build())
            .build();

    private static final SdkField<ScriptBatchJobIdentifier> SCRIPT_BATCH_JOB_IDENTIFIER_FIELD = SdkField
            .<ScriptBatchJobIdentifier> builder(MarshallingType.SDK_POJO).memberName("scriptBatchJobIdentifier")
            .getter(getter(BatchJobIdentifier::scriptBatchJobIdentifier)).setter(setter(Builder::scriptBatchJobIdentifier))
            .constructor(ScriptBatchJobIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptBatchJobIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILE_BATCH_JOB_IDENTIFIER_FIELD, RESTART_BATCH_JOB_IDENTIFIER_FIELD, S3_BATCH_JOB_IDENTIFIER_FIELD,
            SCRIPT_BATCH_JOB_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FileBatchJobIdentifier fileBatchJobIdentifier;

    private final RestartBatchJobIdentifier restartBatchJobIdentifier;

    private final S3BatchJobIdentifier s3BatchJobIdentifier;

    private final ScriptBatchJobIdentifier scriptBatchJobIdentifier;

    private final Type type;

    private BatchJobIdentifier(BuilderImpl builder) {
        this.fileBatchJobIdentifier = builder.fileBatchJobIdentifier;
        this.restartBatchJobIdentifier = builder.restartBatchJobIdentifier;
        this.s3BatchJobIdentifier = builder.s3BatchJobIdentifier;
        this.scriptBatchJobIdentifier = builder.scriptBatchJobIdentifier;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies a file associated with a specific batch job.
     * </p>
     * 
     * @return Specifies a file associated with a specific batch job.
     */
    public final FileBatchJobIdentifier fileBatchJobIdentifier() {
        return fileBatchJobIdentifier;
    }

    /**
     * <p>
     * Specifies the required information for restart, including <code>executionId</code> and
     * <code>JobStepRestartMarker</code>.
     * </p>
     * 
     * @return Specifies the required information for restart, including <code>executionId</code> and
     *         <code>JobStepRestartMarker</code>.
     */
    public final RestartBatchJobIdentifier restartBatchJobIdentifier() {
        return restartBatchJobIdentifier;
    }

    /**
     * <p>
     * Specifies an Amazon S3 location that identifies the batch jobs that you want to run. Use this identifier to run
     * ad hoc batch jobs.
     * </p>
     * 
     * @return Specifies an Amazon S3 location that identifies the batch jobs that you want to run. Use this identifier
     *         to run ad hoc batch jobs.
     */
    public final S3BatchJobIdentifier s3BatchJobIdentifier() {
        return s3BatchJobIdentifier;
    }

    /**
     * <p>
     * A batch job identifier in which the batch job to run is identified by the script name.
     * </p>
     * 
     * @return A batch job identifier in which the batch job to run is identified by the script name.
     */
    public final ScriptBatchJobIdentifier scriptBatchJobIdentifier() {
        return scriptBatchJobIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileBatchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(restartBatchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(s3BatchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(scriptBatchJobIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchJobIdentifier)) {
            return false;
        }
        BatchJobIdentifier other = (BatchJobIdentifier) obj;
        return Objects.equals(fileBatchJobIdentifier(), other.fileBatchJobIdentifier())
                && Objects.equals(restartBatchJobIdentifier(), other.restartBatchJobIdentifier())
                && Objects.equals(s3BatchJobIdentifier(), other.s3BatchJobIdentifier())
                && Objects.equals(scriptBatchJobIdentifier(), other.scriptBatchJobIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchJobIdentifier").add("FileBatchJobIdentifier", fileBatchJobIdentifier())
                .add("RestartBatchJobIdentifier", restartBatchJobIdentifier())
                .add("S3BatchJobIdentifier", s3BatchJobIdentifier()).add("ScriptBatchJobIdentifier", scriptBatchJobIdentifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileBatchJobIdentifier":
            return Optional.ofNullable(clazz.cast(fileBatchJobIdentifier()));
        case "restartBatchJobIdentifier":
            return Optional.ofNullable(clazz.cast(restartBatchJobIdentifier()));
        case "s3BatchJobIdentifier":
            return Optional.ofNullable(clazz.cast(s3BatchJobIdentifier()));
        case "scriptBatchJobIdentifier":
            return Optional.ofNullable(clazz.cast(scriptBatchJobIdentifier()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #fileBatchJobIdentifier()} initialized to the given value.
     *
     * <p>
     * Specifies a file associated with a specific batch job.
     * </p>
     * 
     * @param fileBatchJobIdentifier
     *        Specifies a file associated with a specific batch job.
     */
    public static BatchJobIdentifier fromFileBatchJobIdentifier(FileBatchJobIdentifier fileBatchJobIdentifier) {
        return builder().fileBatchJobIdentifier(fileBatchJobIdentifier).build();
    }

    /**
     * Create an instance of this class with {@link #fileBatchJobIdentifier()} initialized to the given value.
     *
     * <p>
     * Specifies a file associated with a specific batch job.
     * </p>
     * 
     * @param fileBatchJobIdentifier
     *        Specifies a file associated with a specific batch job.
     */
    public static BatchJobIdentifier fromFileBatchJobIdentifier(Consumer<FileBatchJobIdentifier.Builder> fileBatchJobIdentifier) {
        FileBatchJobIdentifier.Builder builder = FileBatchJobIdentifier.builder();
        fileBatchJobIdentifier.accept(builder);
        return fromFileBatchJobIdentifier(builder.build());
    }

    /**
     * Create an instance of this class with {@link #restartBatchJobIdentifier()} initialized to the given value.
     *
     * <p>
     * Specifies the required information for restart, including <code>executionId</code> and
     * <code>JobStepRestartMarker</code>.
     * </p>
     * 
     * @param restartBatchJobIdentifier
     *        Specifies the required information for restart, including <code>executionId</code> and
     *        <code>JobStepRestartMarker</code>.
     */
    public static BatchJobIdentifier fromRestartBatchJobIdentifier(RestartBatchJobIdentifier restartBatchJobIdentifier) {
        return builder().restartBatchJobIdentifier(restartBatchJobIdentifier).build();
    }

    /**
     * Create an instance of this class with {@link #restartBatchJobIdentifier()} initialized to the given value.
     *
     * <p>
     * Specifies the required information for restart, including <code>executionId</code> and
     * <code>JobStepRestartMarker</code>.
     * </p>
     * 
     * @param restartBatchJobIdentifier
     *        Specifies the required information for restart, including <code>executionId</code> and
     *        <code>JobStepRestartMarker</code>.
     */
    public static BatchJobIdentifier fromRestartBatchJobIdentifier(
            Consumer<RestartBatchJobIdentifier.Builder> restartBatchJobIdentifier) {
        RestartBatchJobIdentifier.Builder builder = RestartBatchJobIdentifier.builder();
        restartBatchJobIdentifier.accept(builder);
        return fromRestartBatchJobIdentifier(builder.build());
    }

    /**
     * Create an instance of this class with {@link #s3BatchJobIdentifier()} initialized to the given value.
     *
     * <p>
     * Specifies an Amazon S3 location that identifies the batch jobs that you want to run. Use this identifier to run
     * ad hoc batch jobs.
     * </p>
     * 
     * @param s3BatchJobIdentifier
     *        Specifies an Amazon S3 location that identifies the batch jobs that you want to run. Use this identifier
     *        to run ad hoc batch jobs.
     */
    public static BatchJobIdentifier fromS3BatchJobIdentifier(S3BatchJobIdentifier s3BatchJobIdentifier) {
        return builder().s3BatchJobIdentifier(s3BatchJobIdentifier).build();
    }

    /**
     * Create an instance of this class with {@link #s3BatchJobIdentifier()} initialized to the given value.
     *
     * <p>
     * Specifies an Amazon S3 location that identifies the batch jobs that you want to run. Use this identifier to run
     * ad hoc batch jobs.
     * </p>
     * 
     * @param s3BatchJobIdentifier
     *        Specifies an Amazon S3 location that identifies the batch jobs that you want to run. Use this identifier
     *        to run ad hoc batch jobs.
     */
    public static BatchJobIdentifier fromS3BatchJobIdentifier(Consumer<S3BatchJobIdentifier.Builder> s3BatchJobIdentifier) {
        S3BatchJobIdentifier.Builder builder = S3BatchJobIdentifier.builder();
        s3BatchJobIdentifier.accept(builder);
        return fromS3BatchJobIdentifier(builder.build());
    }

    /**
     * Create an instance of this class with {@link #scriptBatchJobIdentifier()} initialized to the given value.
     *
     * <p>
     * A batch job identifier in which the batch job to run is identified by the script name.
     * </p>
     * 
     * @param scriptBatchJobIdentifier
     *        A batch job identifier in which the batch job to run is identified by the script name.
     */
    public static BatchJobIdentifier fromScriptBatchJobIdentifier(ScriptBatchJobIdentifier scriptBatchJobIdentifier) {
        return builder().scriptBatchJobIdentifier(scriptBatchJobIdentifier).build();
    }

    /**
     * Create an instance of this class with {@link #scriptBatchJobIdentifier()} initialized to the given value.
     *
     * <p>
     * A batch job identifier in which the batch job to run is identified by the script name.
     * </p>
     * 
     * @param scriptBatchJobIdentifier
     *        A batch job identifier in which the batch job to run is identified by the script name.
     */
    public static BatchJobIdentifier fromScriptBatchJobIdentifier(
            Consumer<ScriptBatchJobIdentifier.Builder> scriptBatchJobIdentifier) {
        ScriptBatchJobIdentifier.Builder builder = ScriptBatchJobIdentifier.builder();
        scriptBatchJobIdentifier.accept(builder);
        return fromScriptBatchJobIdentifier(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileBatchJobIdentifier", FILE_BATCH_JOB_IDENTIFIER_FIELD);
        map.put("restartBatchJobIdentifier", RESTART_BATCH_JOB_IDENTIFIER_FIELD);
        map.put("s3BatchJobIdentifier", S3_BATCH_JOB_IDENTIFIER_FIELD);
        map.put("scriptBatchJobIdentifier", SCRIPT_BATCH_JOB_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchJobIdentifier, T> g) {
        return obj -> g.apply((BatchJobIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchJobIdentifier> {
        /**
         * <p>
         * Specifies a file associated with a specific batch job.
         * </p>
         * 
         * @param fileBatchJobIdentifier
         *        Specifies a file associated with a specific batch job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileBatchJobIdentifier(FileBatchJobIdentifier fileBatchJobIdentifier);

        /**
         * <p>
         * Specifies a file associated with a specific batch job.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileBatchJobIdentifier.Builder} avoiding
         * the need to create one manually via {@link FileBatchJobIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileBatchJobIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #fileBatchJobIdentifier(FileBatchJobIdentifier)}.
         * 
         * @param fileBatchJobIdentifier
         *        a consumer that will call methods on {@link FileBatchJobIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileBatchJobIdentifier(FileBatchJobIdentifier)
         */
        default Builder fileBatchJobIdentifier(Consumer<FileBatchJobIdentifier.Builder> fileBatchJobIdentifier) {
            return fileBatchJobIdentifier(FileBatchJobIdentifier.builder().applyMutation(fileBatchJobIdentifier).build());
        }

        /**
         * <p>
         * Specifies the required information for restart, including <code>executionId</code> and
         * <code>JobStepRestartMarker</code>.
         * </p>
         * 
         * @param restartBatchJobIdentifier
         *        Specifies the required information for restart, including <code>executionId</code> and
         *        <code>JobStepRestartMarker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restartBatchJobIdentifier(RestartBatchJobIdentifier restartBatchJobIdentifier);

        /**
         * <p>
         * Specifies the required information for restart, including <code>executionId</code> and
         * <code>JobStepRestartMarker</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RestartBatchJobIdentifier.Builder}
         * avoiding the need to create one manually via {@link RestartBatchJobIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestartBatchJobIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #restartBatchJobIdentifier(RestartBatchJobIdentifier)}.
         * 
         * @param restartBatchJobIdentifier
         *        a consumer that will call methods on {@link RestartBatchJobIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restartBatchJobIdentifier(RestartBatchJobIdentifier)
         */
        default Builder restartBatchJobIdentifier(Consumer<RestartBatchJobIdentifier.Builder> restartBatchJobIdentifier) {
            return restartBatchJobIdentifier(RestartBatchJobIdentifier.builder().applyMutation(restartBatchJobIdentifier).build());
        }

        /**
         * <p>
         * Specifies an Amazon S3 location that identifies the batch jobs that you want to run. Use this identifier to
         * run ad hoc batch jobs.
         * </p>
         * 
         * @param s3BatchJobIdentifier
         *        Specifies an Amazon S3 location that identifies the batch jobs that you want to run. Use this
         *        identifier to run ad hoc batch jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BatchJobIdentifier(S3BatchJobIdentifier s3BatchJobIdentifier);

        /**
         * <p>
         * Specifies an Amazon S3 location that identifies the batch jobs that you want to run. Use this identifier to
         * run ad hoc batch jobs.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BatchJobIdentifier.Builder} avoiding
         * the need to create one manually via {@link S3BatchJobIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3BatchJobIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #s3BatchJobIdentifier(S3BatchJobIdentifier)}.
         * 
         * @param s3BatchJobIdentifier
         *        a consumer that will call methods on {@link S3BatchJobIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BatchJobIdentifier(S3BatchJobIdentifier)
         */
        default Builder s3BatchJobIdentifier(Consumer<S3BatchJobIdentifier.Builder> s3BatchJobIdentifier) {
            return s3BatchJobIdentifier(S3BatchJobIdentifier.builder().applyMutation(s3BatchJobIdentifier).build());
        }

        /**
         * <p>
         * A batch job identifier in which the batch job to run is identified by the script name.
         * </p>
         * 
         * @param scriptBatchJobIdentifier
         *        A batch job identifier in which the batch job to run is identified by the script name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptBatchJobIdentifier(ScriptBatchJobIdentifier scriptBatchJobIdentifier);

        /**
         * <p>
         * A batch job identifier in which the batch job to run is identified by the script name.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScriptBatchJobIdentifier.Builder}
         * avoiding the need to create one manually via {@link ScriptBatchJobIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScriptBatchJobIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #scriptBatchJobIdentifier(ScriptBatchJobIdentifier)}.
         * 
         * @param scriptBatchJobIdentifier
         *        a consumer that will call methods on {@link ScriptBatchJobIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scriptBatchJobIdentifier(ScriptBatchJobIdentifier)
         */
        default Builder scriptBatchJobIdentifier(Consumer<ScriptBatchJobIdentifier.Builder> scriptBatchJobIdentifier) {
            return scriptBatchJobIdentifier(ScriptBatchJobIdentifier.builder().applyMutation(scriptBatchJobIdentifier).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FileBatchJobIdentifier fileBatchJobIdentifier;

        private RestartBatchJobIdentifier restartBatchJobIdentifier;

        private S3BatchJobIdentifier s3BatchJobIdentifier;

        private ScriptBatchJobIdentifier scriptBatchJobIdentifier;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(BatchJobIdentifier model) {
            fileBatchJobIdentifier(model.fileBatchJobIdentifier);
            restartBatchJobIdentifier(model.restartBatchJobIdentifier);
            s3BatchJobIdentifier(model.s3BatchJobIdentifier);
            scriptBatchJobIdentifier(model.scriptBatchJobIdentifier);
        }

        public final FileBatchJobIdentifier.Builder getFileBatchJobIdentifier() {
            return fileBatchJobIdentifier != null ? fileBatchJobIdentifier.toBuilder() : null;
        }

        public final void setFileBatchJobIdentifier(FileBatchJobIdentifier.BuilderImpl fileBatchJobIdentifier) {
            Object oldValue = this.fileBatchJobIdentifier;
            this.fileBatchJobIdentifier = fileBatchJobIdentifier != null ? fileBatchJobIdentifier.build() : null;
            handleUnionValueChange(Type.FILE_BATCH_JOB_IDENTIFIER, oldValue, this.fileBatchJobIdentifier);
        }

        @Override
        public final Builder fileBatchJobIdentifier(FileBatchJobIdentifier fileBatchJobIdentifier) {
            Object oldValue = this.fileBatchJobIdentifier;
            this.fileBatchJobIdentifier = fileBatchJobIdentifier;
            handleUnionValueChange(Type.FILE_BATCH_JOB_IDENTIFIER, oldValue, this.fileBatchJobIdentifier);
            return this;
        }

        public final RestartBatchJobIdentifier.Builder getRestartBatchJobIdentifier() {
            return restartBatchJobIdentifier != null ? restartBatchJobIdentifier.toBuilder() : null;
        }

        public final void setRestartBatchJobIdentifier(RestartBatchJobIdentifier.BuilderImpl restartBatchJobIdentifier) {
            Object oldValue = this.restartBatchJobIdentifier;
            this.restartBatchJobIdentifier = restartBatchJobIdentifier != null ? restartBatchJobIdentifier.build() : null;
            handleUnionValueChange(Type.RESTART_BATCH_JOB_IDENTIFIER, oldValue, this.restartBatchJobIdentifier);
        }

        @Override
        public final Builder restartBatchJobIdentifier(RestartBatchJobIdentifier restartBatchJobIdentifier) {
            Object oldValue = this.restartBatchJobIdentifier;
            this.restartBatchJobIdentifier = restartBatchJobIdentifier;
            handleUnionValueChange(Type.RESTART_BATCH_JOB_IDENTIFIER, oldValue, this.restartBatchJobIdentifier);
            return this;
        }

        public final S3BatchJobIdentifier.Builder getS3BatchJobIdentifier() {
            return s3BatchJobIdentifier != null ? s3BatchJobIdentifier.toBuilder() : null;
        }

        public final void setS3BatchJobIdentifier(S3BatchJobIdentifier.BuilderImpl s3BatchJobIdentifier) {
            Object oldValue = this.s3BatchJobIdentifier;
            this.s3BatchJobIdentifier = s3BatchJobIdentifier != null ? s3BatchJobIdentifier.build() : null;
            handleUnionValueChange(Type.S3_BATCH_JOB_IDENTIFIER, oldValue, this.s3BatchJobIdentifier);
        }

        @Override
        public final Builder s3BatchJobIdentifier(S3BatchJobIdentifier s3BatchJobIdentifier) {
            Object oldValue = this.s3BatchJobIdentifier;
            this.s3BatchJobIdentifier = s3BatchJobIdentifier;
            handleUnionValueChange(Type.S3_BATCH_JOB_IDENTIFIER, oldValue, this.s3BatchJobIdentifier);
            return this;
        }

        public final ScriptBatchJobIdentifier.Builder getScriptBatchJobIdentifier() {
            return scriptBatchJobIdentifier != null ? scriptBatchJobIdentifier.toBuilder() : null;
        }

        public final void setScriptBatchJobIdentifier(ScriptBatchJobIdentifier.BuilderImpl scriptBatchJobIdentifier) {
            Object oldValue = this.scriptBatchJobIdentifier;
            this.scriptBatchJobIdentifier = scriptBatchJobIdentifier != null ? scriptBatchJobIdentifier.build() : null;
            handleUnionValueChange(Type.SCRIPT_BATCH_JOB_IDENTIFIER, oldValue, this.scriptBatchJobIdentifier);
        }

        @Override
        public final Builder scriptBatchJobIdentifier(ScriptBatchJobIdentifier scriptBatchJobIdentifier) {
            Object oldValue = this.scriptBatchJobIdentifier;
            this.scriptBatchJobIdentifier = scriptBatchJobIdentifier;
            handleUnionValueChange(Type.SCRIPT_BATCH_JOB_IDENTIFIER, oldValue, this.scriptBatchJobIdentifier);
            return this;
        }

        @Override
        public BatchJobIdentifier build() {
            return new BatchJobIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see BatchJobIdentifier#type()
     */
    public enum Type {
        FILE_BATCH_JOB_IDENTIFIER,

        RESTART_BATCH_JOB_IDENTIFIER,

        S3_BATCH_JOB_IDENTIFIER,

        SCRIPT_BATCH_JOB_IDENTIFIER,

        UNKNOWN_TO_SDK_VERSION
    }
}
