/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelBatchJobExecutionRequest extends M2Request implements
        ToCopyableBuilder<CancelBatchJobExecutionRequest.Builder, CancelBatchJobExecutionRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CancelBatchJobExecutionRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> AUTH_SECRETS_MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authSecretsManagerArn").getter(getter(CancelBatchJobExecutionRequest::authSecretsManagerArn))
            .setter(setter(Builder::authSecretsManagerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authSecretsManagerArn").build())
            .build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(CancelBatchJobExecutionRequest::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("executionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            AUTH_SECRETS_MANAGER_ARN_FIELD, EXECUTION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String authSecretsManagerArn;

    private final String executionId;

    private CancelBatchJobExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.authSecretsManagerArn = builder.authSecretsManagerArn;
        this.executionId = builder.executionId;
    }

    /**
     * <p>
     * The unique identifier of the application.
     * </p>
     * 
     * @return The unique identifier of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Web Services Secrets Manager containing user's credentials for authentication and authorization for
     * Cancel Batch Job Execution operation.
     * </p>
     * 
     * @return The Amazon Web Services Secrets Manager containing user's credentials for authentication and
     *         authorization for Cancel Batch Job Execution operation.
     */
    public final String authSecretsManagerArn() {
        return authSecretsManagerArn;
    }

    /**
     * <p>
     * The unique identifier of the batch job execution.
     * </p>
     * 
     * @return The unique identifier of the batch job execution.
     */
    public final String executionId() {
        return executionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(authSecretsManagerArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelBatchJobExecutionRequest)) {
            return false;
        }
        CancelBatchJobExecutionRequest other = (CancelBatchJobExecutionRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(authSecretsManagerArn(), other.authSecretsManagerArn())
                && Objects.equals(executionId(), other.executionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelBatchJobExecutionRequest").add("ApplicationId", applicationId())
                .add("AuthSecretsManagerArn", authSecretsManagerArn()).add("ExecutionId", executionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "authSecretsManagerArn":
            return Optional.ofNullable(clazz.cast(authSecretsManagerArn()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("authSecretsManagerArn", AUTH_SECRETS_MANAGER_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelBatchJobExecutionRequest, T> g) {
        return obj -> g.apply((CancelBatchJobExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Request.Builder, SdkPojo, CopyableBuilder<Builder, CancelBatchJobExecutionRequest> {
        /**
         * <p>
         * The unique identifier of the application.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Web Services Secrets Manager containing user's credentials for authentication and authorization
         * for Cancel Batch Job Execution operation.
         * </p>
         * 
         * @param authSecretsManagerArn
         *        The Amazon Web Services Secrets Manager containing user's credentials for authentication and
         *        authorization for Cancel Batch Job Execution operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authSecretsManagerArn(String authSecretsManagerArn);

        /**
         * <p>
         * The unique identifier of the batch job execution.
         * </p>
         * 
         * @param executionId
         *        The unique identifier of the batch job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends M2Request.BuilderImpl implements Builder {
        private String applicationId;

        private String authSecretsManagerArn;

        private String executionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelBatchJobExecutionRequest model) {
            super(model);
            applicationId(model.applicationId);
            authSecretsManagerArn(model.authSecretsManagerArn);
            executionId(model.executionId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getAuthSecretsManagerArn() {
            return authSecretsManagerArn;
        }

        public final void setAuthSecretsManagerArn(String authSecretsManagerArn) {
            this.authSecretsManagerArn = authSecretsManagerArn;
        }

        @Override
        public final Builder authSecretsManagerArn(String authSecretsManagerArn) {
            this.authSecretsManagerArn = authSecretsManagerArn;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelBatchJobExecutionRequest build() {
            return new CancelBatchJobExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
