/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional details about the data set. Different attributes correspond to different data set organizations. The
 * values are populated based on datasetOrg, storageType and backend (Blu Age or Micro Focus).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetDetailOrgAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetDetailOrgAttributes.Builder, DatasetDetailOrgAttributes> {
    private static final SdkField<GdgDetailAttributes> GDG_FIELD = SdkField
            .<GdgDetailAttributes> builder(MarshallingType.SDK_POJO).memberName("gdg")
            .getter(getter(DatasetDetailOrgAttributes::gdg)).setter(setter(Builder::gdg))
            .constructor(GdgDetailAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gdg").build()).build();

    private static final SdkField<PoDetailAttributes> PO_FIELD = SdkField.<PoDetailAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("po").getter(getter(DatasetDetailOrgAttributes::po)).setter(setter(Builder::po))
            .constructor(PoDetailAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("po").build()).build();

    private static final SdkField<PsDetailAttributes> PS_FIELD = SdkField.<PsDetailAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("ps").getter(getter(DatasetDetailOrgAttributes::ps)).setter(setter(Builder::ps))
            .constructor(PsDetailAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ps").build()).build();

    private static final SdkField<VsamDetailAttributes> VSAM_FIELD = SdkField
            .<VsamDetailAttributes> builder(MarshallingType.SDK_POJO).memberName("vsam")
            .getter(getter(DatasetDetailOrgAttributes::vsam)).setter(setter(Builder::vsam))
            .constructor(VsamDetailAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vsam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GDG_FIELD, PO_FIELD, PS_FIELD,
            VSAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GdgDetailAttributes gdg;

    private final PoDetailAttributes po;

    private final PsDetailAttributes ps;

    private final VsamDetailAttributes vsam;

    private final Type type;

    private DatasetDetailOrgAttributes(BuilderImpl builder) {
        this.gdg = builder.gdg;
        this.po = builder.po;
        this.ps = builder.ps;
        this.vsam = builder.vsam;
        this.type = builder.type;
    }

    /**
     * <p>
     * The generation data group of the data set.
     * </p>
     * 
     * @return The generation data group of the data set.
     */
    public final GdgDetailAttributes gdg() {
        return gdg;
    }

    /**
     * <p>
     * The details of a PO type data set.
     * </p>
     * 
     * @return The details of a PO type data set.
     */
    public final PoDetailAttributes po() {
        return po;
    }

    /**
     * <p>
     * The details of a PS type data set.
     * </p>
     * 
     * @return The details of a PS type data set.
     */
    public final PsDetailAttributes ps() {
        return ps;
    }

    /**
     * <p>
     * The details of a VSAM data set.
     * </p>
     * 
     * @return The details of a VSAM data set.
     */
    public final VsamDetailAttributes vsam() {
        return vsam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gdg());
        hashCode = 31 * hashCode + Objects.hashCode(po());
        hashCode = 31 * hashCode + Objects.hashCode(ps());
        hashCode = 31 * hashCode + Objects.hashCode(vsam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetDetailOrgAttributes)) {
            return false;
        }
        DatasetDetailOrgAttributes other = (DatasetDetailOrgAttributes) obj;
        return Objects.equals(gdg(), other.gdg()) && Objects.equals(po(), other.po()) && Objects.equals(ps(), other.ps())
                && Objects.equals(vsam(), other.vsam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetDetailOrgAttributes").add("Gdg", gdg()).add("Po", po()).add("Ps", ps())
                .add("Vsam", vsam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gdg":
            return Optional.ofNullable(clazz.cast(gdg()));
        case "po":
            return Optional.ofNullable(clazz.cast(po()));
        case "ps":
            return Optional.ofNullable(clazz.cast(ps()));
        case "vsam":
            return Optional.ofNullable(clazz.cast(vsam()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #gdg()} initialized to the given value.
     *
     * <p>
     * The generation data group of the data set.
     * </p>
     * 
     * @param gdg
     *        The generation data group of the data set.
     */
    public static DatasetDetailOrgAttributes fromGdg(GdgDetailAttributes gdg) {
        return builder().gdg(gdg).build();
    }

    /**
     * Create an instance of this class with {@link #gdg()} initialized to the given value.
     *
     * <p>
     * The generation data group of the data set.
     * </p>
     * 
     * @param gdg
     *        The generation data group of the data set.
     */
    public static DatasetDetailOrgAttributes fromGdg(Consumer<GdgDetailAttributes.Builder> gdg) {
        GdgDetailAttributes.Builder builder = GdgDetailAttributes.builder();
        gdg.accept(builder);
        return fromGdg(builder.build());
    }

    /**
     * Create an instance of this class with {@link #po()} initialized to the given value.
     *
     * <p>
     * The details of a PO type data set.
     * </p>
     * 
     * @param po
     *        The details of a PO type data set.
     */
    public static DatasetDetailOrgAttributes fromPo(PoDetailAttributes po) {
        return builder().po(po).build();
    }

    /**
     * Create an instance of this class with {@link #po()} initialized to the given value.
     *
     * <p>
     * The details of a PO type data set.
     * </p>
     * 
     * @param po
     *        The details of a PO type data set.
     */
    public static DatasetDetailOrgAttributes fromPo(Consumer<PoDetailAttributes.Builder> po) {
        PoDetailAttributes.Builder builder = PoDetailAttributes.builder();
        po.accept(builder);
        return fromPo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ps()} initialized to the given value.
     *
     * <p>
     * The details of a PS type data set.
     * </p>
     * 
     * @param ps
     *        The details of a PS type data set.
     */
    public static DatasetDetailOrgAttributes fromPs(PsDetailAttributes ps) {
        return builder().ps(ps).build();
    }

    /**
     * Create an instance of this class with {@link #ps()} initialized to the given value.
     *
     * <p>
     * The details of a PS type data set.
     * </p>
     * 
     * @param ps
     *        The details of a PS type data set.
     */
    public static DatasetDetailOrgAttributes fromPs(Consumer<PsDetailAttributes.Builder> ps) {
        PsDetailAttributes.Builder builder = PsDetailAttributes.builder();
        ps.accept(builder);
        return fromPs(builder.build());
    }

    /**
     * Create an instance of this class with {@link #vsam()} initialized to the given value.
     *
     * <p>
     * The details of a VSAM data set.
     * </p>
     * 
     * @param vsam
     *        The details of a VSAM data set.
     */
    public static DatasetDetailOrgAttributes fromVsam(VsamDetailAttributes vsam) {
        return builder().vsam(vsam).build();
    }

    /**
     * Create an instance of this class with {@link #vsam()} initialized to the given value.
     *
     * <p>
     * The details of a VSAM data set.
     * </p>
     * 
     * @param vsam
     *        The details of a VSAM data set.
     */
    public static DatasetDetailOrgAttributes fromVsam(Consumer<VsamDetailAttributes.Builder> vsam) {
        VsamDetailAttributes.Builder builder = VsamDetailAttributes.builder();
        vsam.accept(builder);
        return fromVsam(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gdg", GDG_FIELD);
        map.put("po", PO_FIELD);
        map.put("ps", PS_FIELD);
        map.put("vsam", VSAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetDetailOrgAttributes, T> g) {
        return obj -> g.apply((DatasetDetailOrgAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetDetailOrgAttributes> {
        /**
         * <p>
         * The generation data group of the data set.
         * </p>
         * 
         * @param gdg
         *        The generation data group of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gdg(GdgDetailAttributes gdg);

        /**
         * <p>
         * The generation data group of the data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link GdgDetailAttributes.Builder} avoiding the
         * need to create one manually via {@link GdgDetailAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GdgDetailAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #gdg(GdgDetailAttributes)}.
         * 
         * @param gdg
         *        a consumer that will call methods on {@link GdgDetailAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gdg(GdgDetailAttributes)
         */
        default Builder gdg(Consumer<GdgDetailAttributes.Builder> gdg) {
            return gdg(GdgDetailAttributes.builder().applyMutation(gdg).build());
        }

        /**
         * <p>
         * The details of a PO type data set.
         * </p>
         * 
         * @param po
         *        The details of a PO type data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder po(PoDetailAttributes po);

        /**
         * <p>
         * The details of a PO type data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link PoDetailAttributes.Builder} avoiding the
         * need to create one manually via {@link PoDetailAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PoDetailAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #po(PoDetailAttributes)}.
         * 
         * @param po
         *        a consumer that will call methods on {@link PoDetailAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #po(PoDetailAttributes)
         */
        default Builder po(Consumer<PoDetailAttributes.Builder> po) {
            return po(PoDetailAttributes.builder().applyMutation(po).build());
        }

        /**
         * <p>
         * The details of a PS type data set.
         * </p>
         * 
         * @param ps
         *        The details of a PS type data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ps(PsDetailAttributes ps);

        /**
         * <p>
         * The details of a PS type data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link PsDetailAttributes.Builder} avoiding the
         * need to create one manually via {@link PsDetailAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PsDetailAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #ps(PsDetailAttributes)}.
         * 
         * @param ps
         *        a consumer that will call methods on {@link PsDetailAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ps(PsDetailAttributes)
         */
        default Builder ps(Consumer<PsDetailAttributes.Builder> ps) {
            return ps(PsDetailAttributes.builder().applyMutation(ps).build());
        }

        /**
         * <p>
         * The details of a VSAM data set.
         * </p>
         * 
         * @param vsam
         *        The details of a VSAM data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vsam(VsamDetailAttributes vsam);

        /**
         * <p>
         * The details of a VSAM data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link VsamDetailAttributes.Builder} avoiding
         * the need to create one manually via {@link VsamDetailAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VsamDetailAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #vsam(VsamDetailAttributes)}.
         * 
         * @param vsam
         *        a consumer that will call methods on {@link VsamDetailAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vsam(VsamDetailAttributes)
         */
        default Builder vsam(Consumer<VsamDetailAttributes.Builder> vsam) {
            return vsam(VsamDetailAttributes.builder().applyMutation(vsam).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GdgDetailAttributes gdg;

        private PoDetailAttributes po;

        private PsDetailAttributes ps;

        private VsamDetailAttributes vsam;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetDetailOrgAttributes model) {
            gdg(model.gdg);
            po(model.po);
            ps(model.ps);
            vsam(model.vsam);
        }

        public final GdgDetailAttributes.Builder getGdg() {
            return gdg != null ? gdg.toBuilder() : null;
        }

        public final void setGdg(GdgDetailAttributes.BuilderImpl gdg) {
            Object oldValue = this.gdg;
            this.gdg = gdg != null ? gdg.build() : null;
            handleUnionValueChange(Type.GDG, oldValue, this.gdg);
        }

        @Override
        public final Builder gdg(GdgDetailAttributes gdg) {
            Object oldValue = this.gdg;
            this.gdg = gdg;
            handleUnionValueChange(Type.GDG, oldValue, this.gdg);
            return this;
        }

        public final PoDetailAttributes.Builder getPo() {
            return po != null ? po.toBuilder() : null;
        }

        public final void setPo(PoDetailAttributes.BuilderImpl po) {
            Object oldValue = this.po;
            this.po = po != null ? po.build() : null;
            handleUnionValueChange(Type.PO, oldValue, this.po);
        }

        @Override
        public final Builder po(PoDetailAttributes po) {
            Object oldValue = this.po;
            this.po = po;
            handleUnionValueChange(Type.PO, oldValue, this.po);
            return this;
        }

        public final PsDetailAttributes.Builder getPs() {
            return ps != null ? ps.toBuilder() : null;
        }

        public final void setPs(PsDetailAttributes.BuilderImpl ps) {
            Object oldValue = this.ps;
            this.ps = ps != null ? ps.build() : null;
            handleUnionValueChange(Type.PS, oldValue, this.ps);
        }

        @Override
        public final Builder ps(PsDetailAttributes ps) {
            Object oldValue = this.ps;
            this.ps = ps;
            handleUnionValueChange(Type.PS, oldValue, this.ps);
            return this;
        }

        public final VsamDetailAttributes.Builder getVsam() {
            return vsam != null ? vsam.toBuilder() : null;
        }

        public final void setVsam(VsamDetailAttributes.BuilderImpl vsam) {
            Object oldValue = this.vsam;
            this.vsam = vsam != null ? vsam.build() : null;
            handleUnionValueChange(Type.VSAM, oldValue, this.vsam);
        }

        @Override
        public final Builder vsam(VsamDetailAttributes vsam) {
            Object oldValue = this.vsam;
            this.vsam = vsam;
            handleUnionValueChange(Type.VSAM, oldValue, this.vsam);
            return this;
        }

        @Override
        public DatasetDetailOrgAttributes build() {
            return new DatasetDetailOrgAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DatasetDetailOrgAttributes#type()
     */
    public enum Type {
        GDG,

        PO,

        PS,

        VSAM,

        UNKNOWN_TO_SDK_VERSION
    }
}
