/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A batch job identifier in which the batch job to run is identified by the script name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScriptBatchJobIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<ScriptBatchJobIdentifier.Builder, ScriptBatchJobIdentifier> {
    private static final SdkField<String> SCRIPT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scriptName").getter(getter(ScriptBatchJobIdentifier::scriptName)).setter(setter(Builder::scriptName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scriptName;

    private ScriptBatchJobIdentifier(BuilderImpl builder) {
        this.scriptName = builder.scriptName;
    }

    /**
     * <p>
     * The name of the script containing the batch job definition.
     * </p>
     * 
     * @return The name of the script containing the batch job definition.
     */
    public final String scriptName() {
        return scriptName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scriptName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScriptBatchJobIdentifier)) {
            return false;
        }
        ScriptBatchJobIdentifier other = (ScriptBatchJobIdentifier) obj;
        return Objects.equals(scriptName(), other.scriptName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScriptBatchJobIdentifier").add("ScriptName", scriptName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scriptName":
            return Optional.ofNullable(clazz.cast(scriptName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scriptName", SCRIPT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScriptBatchJobIdentifier, T> g) {
        return obj -> g.apply((ScriptBatchJobIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScriptBatchJobIdentifier> {
        /**
         * <p>
         * The name of the script containing the batch job definition.
         * </p>
         * 
         * @param scriptName
         *        The name of the script containing the batch job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptName(String scriptName);
    }

    static final class BuilderImpl implements Builder {
        private String scriptName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScriptBatchJobIdentifier model) {
            scriptName(model.scriptName);
        }

        public final String getScriptName() {
            return scriptName;
        }

        public final void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        @Override
        public final Builder scriptName(String scriptName) {
            this.scriptName = scriptName;
            return this;
        }

        @Override
        public ScriptBatchJobIdentifier build() {
            return new ScriptBatchJobIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
