/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.EngineType;
import software.amazon.awssdk.services.m2.model.EnvironmentLifecycle;
import software.amazon.awssdk.services.m2.model.NetworkType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentSummary> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(EnvironmentSummary.getter(EnvironmentSummary::creationTime)).setter(EnvironmentSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineType").getter(EnvironmentSummary.getter(EnvironmentSummary::engineTypeAsString)).setter(EnvironmentSummary.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineVersion").getter(EnvironmentSummary.getter(EnvironmentSummary::engineVersion)).setter(EnvironmentSummary.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentArn").getter(EnvironmentSummary.getter(EnvironmentSummary::environmentArn)).setter(EnvironmentSummary.setter(Builder::environmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(EnvironmentSummary.getter(EnvironmentSummary::environmentId)).setter(EnvironmentSummary.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(EnvironmentSummary.getter(EnvironmentSummary::instanceType)).setter(EnvironmentSummary.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EnvironmentSummary.getter(EnvironmentSummary::name)).setter(EnvironmentSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkType").getter(EnvironmentSummary.getter(EnvironmentSummary::networkTypeAsString)).setter(EnvironmentSummary.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(EnvironmentSummary.getter(EnvironmentSummary::statusAsString)).setter(EnvironmentSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, ENVIRONMENT_ARN_FIELD, ENVIRONMENT_ID_FIELD, INSTANCE_TYPE_FIELD, NAME_FIELD, NETWORK_TYPE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String engineType;
    private final String engineVersion;
    private final String environmentArn;
    private final String environmentId;
    private final String instanceType;
    private final String name;
    private final String networkType;
    private final String status;

    private EnvironmentSummary(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.environmentArn = builder.environmentArn;
        this.environmentId = builder.environmentId;
        this.instanceType = builder.instanceType;
        this.name = builder.name;
        this.networkType = builder.networkType;
        this.status = builder.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public final String engineTypeAsString() {
        return this.engineType;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String environmentArn() {
        return this.environmentArn;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String name() {
        return this.name;
    }

    public final NetworkType networkType() {
        return NetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    public final EnvironmentLifecycle status() {
        return EnvironmentLifecycle.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentSummary)) {
            return false;
        }
        EnvironmentSummary other = (EnvironmentSummary)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.environmentArn(), other.environmentArn()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentSummary").add("CreationTime", (Object)this.creationTime()).add("EngineType", (Object)this.engineTypeAsString()).add("EngineVersion", (Object)this.engineVersion()).add("EnvironmentArn", (Object)this.environmentArn()).add("EnvironmentId", (Object)this.environmentId()).add("InstanceType", (Object)this.instanceType()).add("Name", (Object)this.name()).add("NetworkType", (Object)this.networkTypeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "engineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "engineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "environmentArn": {
                return Optional.ofNullable(clazz.cast(this.environmentArn()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "networkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("engineType", ENGINE_TYPE_FIELD);
        map.put("engineVersion", ENGINE_VERSION_FIELD);
        map.put("environmentArn", ENVIRONMENT_ARN_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("networkType", NETWORK_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentSummary, T> g) {
        return obj -> g.apply((EnvironmentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String engineType;
        private String engineVersion;
        private String environmentArn;
        private String environmentId;
        private String instanceType;
        private String name;
        private String networkType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentSummary model) {
            this.creationTime(model.creationTime);
            this.engineType(model.engineType);
            this.engineVersion(model.engineVersion);
            this.environmentArn(model.environmentArn);
            this.environmentId(model.environmentId);
            this.instanceType(model.instanceType);
            this.name(model.name);
            this.networkType(model.networkType);
            this.status(model.status);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public EnvironmentSummary build() {
            return new EnvironmentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentSummary> {
        public Builder creationTime(Instant var1);

        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder engineVersion(String var1);

        public Builder environmentArn(String var1);

        public Builder environmentId(String var1);

        public Builder instanceType(String var1);

        public Builder name(String var1);

        public Builder networkType(String var1);

        public Builder networkType(NetworkType var1);

        public Builder status(String var1);

        public Builder status(EnvironmentLifecycle var1);
    }
}

