/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.model.BatchPrediction;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;

public class DescribeBatchPredictionsPublisher
implements SdkPublisher<DescribeBatchPredictionsResponse> {
    private final MachineLearningAsyncClient client;
    private final DescribeBatchPredictionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBatchPredictionsPublisher(MachineLearningAsyncClient client, DescribeBatchPredictionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBatchPredictionsPublisher(MachineLearningAsyncClient client, DescribeBatchPredictionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBatchPredictionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBatchPredictionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BatchPrediction> results() {
        Function<DescribeBatchPredictionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeBatchPredictionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeBatchPredictionsResponseFetcher
    implements AsyncPageFetcher<DescribeBatchPredictionsResponse> {
        private DescribeBatchPredictionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBatchPredictionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeBatchPredictionsResponse> nextPage(DescribeBatchPredictionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBatchPredictionsPublisher.this.client.describeBatchPredictions(DescribeBatchPredictionsPublisher.this.firstRequest);
            }
            return DescribeBatchPredictionsPublisher.this.client.describeBatchPredictions((DescribeBatchPredictionsRequest)((Object)DescribeBatchPredictionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

