/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UsageStatisticsSortKey {
    ACCOUNT_ID("accountId"),
    TOTAL("total"),
    SERVICE_LIMIT_VALUE("serviceLimitValue"),
    FREE_TRIAL_START_DATE("freeTrialStartDate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UsageStatisticsSortKey> VALUE_MAP;
    private final String value;

    private UsageStatisticsSortKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UsageStatisticsSortKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UsageStatisticsSortKey> knownValues() {
        EnumSet<UsageStatisticsSortKey> knownValues = EnumSet.allOf(UsageStatisticsSortKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UsageStatisticsSortKey.class, UsageStatisticsSortKey::toString);
    }
}

