/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.TimeRange;
import software.amazon.awssdk.services.macie2.model.UsageRecord;
import software.amazon.awssdk.services.macie2.model.___listOfUsageRecordCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUsageStatisticsResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetUsageStatisticsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetUsageStatisticsResponse.getter(GetUsageStatisticsResponse::nextToken)).setter(GetUsageStatisticsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<UsageRecord>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("records").getter(GetUsageStatisticsResponse.getter(GetUsageStatisticsResponse::records)).setter(GetUsageStatisticsResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeRange").getter(GetUsageStatisticsResponse.getter(GetUsageStatisticsResponse::timeRangeAsString)).setter(GetUsageStatisticsResponse.setter(Builder::timeRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RECORDS_FIELD, TIME_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUsageStatisticsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<UsageRecord> records;
    private final String timeRange;

    private GetUsageStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.records = builder.records;
        this.timeRange = builder.timeRange;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<UsageRecord> records() {
        return this.records;
    }

    public final TimeRange timeRange() {
        return TimeRange.fromValue(this.timeRange);
    }

    public final String timeRangeAsString() {
        return this.timeRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageStatisticsResponse)) {
            return false;
        }
        GetUsageStatisticsResponse other = (GetUsageStatisticsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.timeRangeAsString(), other.timeRangeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetUsageStatisticsResponse").add("NextToken", (Object)this.nextToken()).add("Records", this.hasRecords() ? this.records() : null).add("TimeRange", (Object)this.timeRangeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "timeRange": {
                return Optional.ofNullable(clazz.cast(this.timeRangeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("records", RECORDS_FIELD);
        map.put("timeRange", TIME_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUsageStatisticsResponse, T> g) {
        return obj -> g.apply((GetUsageStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<UsageRecord> records = DefaultSdkAutoConstructList.getInstance();
        private String timeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageStatisticsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.records(model.records);
            this.timeRange(model.timeRange);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UsageRecord.Builder> getRecords() {
            List<UsageRecord.Builder> result = ___listOfUsageRecordCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<UsageRecord.BuilderImpl> records) {
            this.records = ___listOfUsageRecordCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<UsageRecord> records) {
            this.records = ___listOfUsageRecordCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(UsageRecord ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<UsageRecord.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (UsageRecord)((UsageRecord.Builder)UsageRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTimeRange() {
            return this.timeRange;
        }

        public final void setTimeRange(String timeRange) {
            this.timeRange = timeRange;
        }

        @Override
        public final Builder timeRange(String timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange(timeRange == null ? null : timeRange.toString());
            return this;
        }

        @Override
        public GetUsageStatisticsResponse build() {
            return new GetUsageStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUsageStatisticsResponse> {
        public Builder nextToken(String var1);

        public Builder records(Collection<UsageRecord> var1);

        public Builder records(UsageRecord ... var1);

        public Builder records(Consumer<UsageRecord.Builder> ... var1);

        public Builder timeRange(String var1);

        public Builder timeRange(TimeRange var1);
    }
}

