/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria;
import software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClassificationJobsRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, ListClassificationJobsRequest> {
    private static final SdkField<ListJobsFilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterCriteria").getter(ListClassificationJobsRequest.getter(ListClassificationJobsRequest::filterCriteria)).setter(ListClassificationJobsRequest.setter(Builder::filterCriteria)).constructor(ListJobsFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListClassificationJobsRequest.getter(ListClassificationJobsRequest::maxResults)).setter(ListClassificationJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListClassificationJobsRequest.getter(ListClassificationJobsRequest::nextToken)).setter(ListClassificationJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<ListJobsSortCriteria> SORT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortCriteria").getter(ListClassificationJobsRequest.getter(ListClassificationJobsRequest::sortCriteria)).setter(ListClassificationJobsRequest.setter(Builder::sortCriteria)).constructor(ListJobsSortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_CRITERIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListClassificationJobsRequest.memberNameToFieldInitializer();
    private final ListJobsFilterCriteria filterCriteria;
    private final Integer maxResults;
    private final String nextToken;
    private final ListJobsSortCriteria sortCriteria;

    private ListClassificationJobsRequest(BuilderImpl builder) {
        super(builder);
        this.filterCriteria = builder.filterCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortCriteria = builder.sortCriteria;
    }

    public final ListJobsFilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ListJobsSortCriteria sortCriteria() {
        return this.sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClassificationJobsRequest)) {
            return false;
        }
        ListClassificationJobsRequest other = (ListClassificationJobsRequest)((Object)obj);
        return Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortCriteria(), other.sortCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"ListClassificationJobsRequest").add("FilterCriteria", (Object)this.filterCriteria()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SortCriteria", (Object)this.sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortCriteria": {
                return Optional.ofNullable(clazz.cast(this.sortCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterCriteria", FILTER_CRITERIA_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortCriteria", SORT_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClassificationJobsRequest, T> g) {
        return obj -> g.apply((ListClassificationJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private ListJobsFilterCriteria filterCriteria;
        private Integer maxResults;
        private String nextToken;
        private ListJobsSortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClassificationJobsRequest model) {
            super(model);
            this.filterCriteria(model.filterCriteria);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sortCriteria(model.sortCriteria);
        }

        public final ListJobsFilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(ListJobsFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(ListJobsFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ListJobsSortCriteria.Builder getSortCriteria() {
            return this.sortCriteria != null ? this.sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(ListJobsSortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(ListJobsSortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClassificationJobsRequest build() {
            return new ListClassificationJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClassificationJobsRequest> {
        public Builder filterCriteria(ListJobsFilterCriteria var1);

        default public Builder filterCriteria(Consumer<ListJobsFilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((ListJobsFilterCriteria)((ListJobsFilterCriteria.Builder)ListJobsFilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sortCriteria(ListJobsSortCriteria var1);

        default public Builder sortCriteria(Consumer<ListJobsSortCriteria.Builder> sortCriteria) {
            return this.sortCriteria((ListJobsSortCriteria)((ListJobsSortCriteria.Builder)ListJobsSortCriteria.builder().applyMutation(sortCriteria)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

