/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScopeFilterKey {
    OBJECT_EXTENSION("OBJECT_EXTENSION"),
    OBJECT_LAST_MODIFIED_DATE("OBJECT_LAST_MODIFIED_DATE"),
    OBJECT_SIZE("OBJECT_SIZE"),
    OBJECT_KEY("OBJECT_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScopeFilterKey> VALUE_MAP;
    private final String value;

    private ScopeFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScopeFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScopeFilterKey> knownValues() {
        EnumSet<ScopeFilterKey> knownValues = EnumSet.allOf(ScopeFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScopeFilterKey.class, ScopeFilterKey::toString);
    }
}

