/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OriginType {
    SENSITIVE_DATA_DISCOVERY_JOB("SENSITIVE_DATA_DISCOVERY_JOB"),
    AUTOMATED_SENSITIVE_DATA_DISCOVERY("AUTOMATED_SENSITIVE_DATA_DISCOVERY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OriginType> VALUE_MAP;
    private final String value;

    private OriginType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OriginType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OriginType> knownValues() {
        EnumSet<OriginType> knownValues = EnumSet.allOf(OriginType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OriginType.class, OriginType::toString);
    }
}

