/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.Detection;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsRequest;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsResponse;

public class ListResourceProfileDetectionsPublisher
implements SdkPublisher<ListResourceProfileDetectionsResponse> {
    private final Macie2AsyncClient client;
    private final ListResourceProfileDetectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceProfileDetectionsPublisher(Macie2AsyncClient client, ListResourceProfileDetectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceProfileDetectionsPublisher(Macie2AsyncClient client, ListResourceProfileDetectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceProfileDetectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceProfileDetectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Detection> detections() {
        Function<ListResourceProfileDetectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.detections() != null) {
                return response.detections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceProfileDetectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceProfileDetectionsResponseFetcher
    implements AsyncPageFetcher<ListResourceProfileDetectionsResponse> {
        private ListResourceProfileDetectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceProfileDetectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceProfileDetectionsResponse> nextPage(ListResourceProfileDetectionsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceProfileDetectionsPublisher.this.client.listResourceProfileDetections(ListResourceProfileDetectionsPublisher.this.firstRequest);
            }
            return ListResourceProfileDetectionsPublisher.this.client.listResourceProfileDetections((ListResourceProfileDetectionsRequest)((Object)ListResourceProfileDetectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

