/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.BadGatewayException;
import software.amazon.awssdk.services.medialive.model.BadRequestException;
import software.amazon.awssdk.services.medialive.model.BatchDeleteRequest;
import software.amazon.awssdk.services.medialive.model.BatchDeleteResponse;
import software.amazon.awssdk.services.medialive.model.BatchStartRequest;
import software.amazon.awssdk.services.medialive.model.BatchStartResponse;
import software.amazon.awssdk.services.medialive.model.BatchStopRequest;
import software.amazon.awssdk.services.medialive.model.BatchStopResponse;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse;
import software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.ClaimDeviceRequest;
import software.amazon.awssdk.services.medialive.model.ClaimDeviceResponse;
import software.amazon.awssdk.services.medialive.model.ConflictException;
import software.amazon.awssdk.services.medialive.model.CreateChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateChannelRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelResponse;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.CreateClusterRequest;
import software.amazon.awssdk.services.medialive.model.CreateClusterResponse;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.CreateNetworkRequest;
import software.amazon.awssdk.services.medialive.model.CreateNetworkResponse;
import software.amazon.awssdk.services.medialive.model.CreateNodeRegistrationScriptRequest;
import software.amazon.awssdk.services.medialive.model.CreateNodeRegistrationScriptResponse;
import software.amazon.awssdk.services.medialive.model.CreateNodeRequest;
import software.amazon.awssdk.services.medialive.model.CreateNodeResponse;
import software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest;
import software.amazon.awssdk.services.medialive.model.CreatePartnerInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.CreateSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.CreateTagsRequest;
import software.amazon.awssdk.services.medialive.model.CreateTagsResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelResponse;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.DeleteClusterRequest;
import software.amazon.awssdk.services.medialive.model.DeleteClusterResponse;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DeleteNetworkRequest;
import software.amazon.awssdk.services.medialive.model.DeleteNetworkResponse;
import software.amazon.awssdk.services.medialive.model.DeleteNodeRequest;
import software.amazon.awssdk.services.medialive.model.DeleteNodeResponse;
import software.amazon.awssdk.services.medialive.model.DeleteReservationRequest;
import software.amazon.awssdk.services.medialive.model.DeleteReservationResponse;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DeleteSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.DeleteSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.DeleteTagsRequest;
import software.amazon.awssdk.services.medialive.model.DeleteTagsResponse;
import software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeClusterRequest;
import software.amazon.awssdk.services.medialive.model.DescribeClusterResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DescribeNetworkRequest;
import software.amazon.awssdk.services.medialive.model.DescribeNetworkResponse;
import software.amazon.awssdk.services.medialive.model.DescribeNodeRequest;
import software.amazon.awssdk.services.medialive.model.DescribeNodeResponse;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.medialive.model.DescribeReservationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeReservationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DescribeThumbnailsRequest;
import software.amazon.awssdk.services.medialive.model.DescribeThumbnailsResponse;
import software.amazon.awssdk.services.medialive.model.ForbiddenException;
import software.amazon.awssdk.services.medialive.model.GatewayTimeoutException;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.GetSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.GetSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.InternalServerErrorException;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListChannelsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelsResponse;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse;
import software.amazon.awssdk.services.medialive.model.ListClustersRequest;
import software.amazon.awssdk.services.medialive.model.ListClustersResponse;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse;
import software.amazon.awssdk.services.medialive.model.ListNetworksRequest;
import software.amazon.awssdk.services.medialive.model.ListNetworksResponse;
import software.amazon.awssdk.services.medialive.model.ListNodesRequest;
import software.amazon.awssdk.services.medialive.model.ListNodesResponse;
import software.amazon.awssdk.services.medialive.model.ListOfferingsRequest;
import software.amazon.awssdk.services.medialive.model.ListOfferingsResponse;
import software.amazon.awssdk.services.medialive.model.ListReservationsRequest;
import software.amazon.awssdk.services.medialive.model.ListReservationsResponse;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.medialive.model.ListVersionsRequest;
import software.amazon.awssdk.services.medialive.model.ListVersionsResponse;
import software.amazon.awssdk.services.medialive.model.MediaLiveException;
import software.amazon.awssdk.services.medialive.model.NotFoundException;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesRequest;
import software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesResponse;
import software.amazon.awssdk.services.medialive.model.StartChannelRequest;
import software.amazon.awssdk.services.medialive.model.StartChannelResponse;
import software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentRequest;
import software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentResponse;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowRequest;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowResponse;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentRequest;
import software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentResponse;
import software.amazon.awssdk.services.medialive.model.StartMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StartMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.StopChannelRequest;
import software.amazon.awssdk.services.medialive.model.StopChannelResponse;
import software.amazon.awssdk.services.medialive.model.StopInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.StopInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.StopMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StopMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.TooManyRequestsException;
import software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.TransferInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UnprocessableEntityException;
import software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelResponse;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateClusterRequest;
import software.amazon.awssdk.services.medialive.model.UpdateClusterResponse;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNetworkRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNetworkResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNodeRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNodeResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNodeStateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNodeStateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateReservationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateReservationResponse;
import software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable;
import software.amazon.awssdk.services.medialive.paginators.ListChannelPlacementGroupsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesIterable;
import software.amazon.awssdk.services.medialive.paginators.ListClustersIterable;
import software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesIterable;
import software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersIterable;
import software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable;
import software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListInputsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable;
import software.amazon.awssdk.services.medialive.paginators.ListNetworksIterable;
import software.amazon.awssdk.services.medialive.paginators.ListNodesIterable;
import software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListSignalMapsIterable;
import software.amazon.awssdk.services.medialive.waiters.MediaLiveWaiter;

/**
 * Service client for accessing MediaLive. This can be created using the static {@link #builder()} method.
 *
 * API for AWS Elemental MediaLive
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaLiveClient extends AwsClient {
    String SERVICE_NAME = "medialive";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "medialive";

    /**
     * Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.
     *
     * @param acceptInputDeviceTransferRequest
     *        Placeholder documentation for AcceptInputDeviceTransferRequest
     * @return Result of the AcceptInputDeviceTransfer operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to accept input device transfers.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device transfer could not be accepted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.AcceptInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AcceptInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptInputDeviceTransferResponse acceptInputDeviceTransfer(
            AcceptInputDeviceTransferRequest acceptInputDeviceTransferRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInputDeviceTransferRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptInputDeviceTransferRequest#builder()}
     * </p>
     *
     * @param acceptInputDeviceTransferRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferRequest.Builder} to create
     *        a request. Placeholder documentation for AcceptInputDeviceTransferRequest
     * @return Result of the AcceptInputDeviceTransfer operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to accept input device transfers.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device transfer could not be accepted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.AcceptInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AcceptInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptInputDeviceTransferResponse acceptInputDeviceTransfer(
            Consumer<AcceptInputDeviceTransferRequest.Builder> acceptInputDeviceTransferRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return acceptInputDeviceTransfer(AcceptInputDeviceTransferRequest.builder()
                .applyMutation(acceptInputDeviceTransferRequest).build());
    }

    /**
     * Starts delete of resources.
     *
     * @param batchDeleteRequest
     *        A request to delete resources
     * @return Result of the BatchDelete operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to delete the resources.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The resources you're requesting to delete do not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete resources calls.
     * @throws ConflictException
     *         The resources are unable to delete.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchDelete
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchDelete" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeleteResponse batchDelete(BatchDeleteRequest batchDeleteRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts delete of resources.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteRequest.Builder} avoiding the need to
     * create one manually via {@link BatchDeleteRequest#builder()}
     * </p>
     *
     * @param batchDeleteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.BatchDeleteRequest.Builder} to create a request. A
     *        request to delete resources
     * @return Result of the BatchDelete operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to delete the resources.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The resources you're requesting to delete do not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete resources calls.
     * @throws ConflictException
     *         The resources are unable to delete.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchDelete
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchDelete" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeleteResponse batchDelete(Consumer<BatchDeleteRequest.Builder> batchDeleteRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return batchDelete(BatchDeleteRequest.builder().applyMutation(batchDeleteRequest).build());
    }

    /**
     * Starts existing resources
     *
     * @param batchStartRequest
     *        A request to start resources
     * @return Result of the BatchStart operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start the resources.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The resources you're requesting to start do not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on start resources calls to resource service.
     * @throws ConflictException
     *         The resources are unable to start.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchStart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStart" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchStartResponse batchStart(BatchStartRequest batchStartRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts existing resources<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchStartRequest.Builder} avoiding the need to
     * create one manually via {@link BatchStartRequest#builder()}
     * </p>
     *
     * @param batchStartRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.BatchStartRequest.Builder} to create a request. A
     *        request to start resources
     * @return Result of the BatchStart operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start the resources.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The resources you're requesting to start do not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on start resources calls to resource service.
     * @throws ConflictException
     *         The resources are unable to start.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchStart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStart" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchStartResponse batchStart(Consumer<BatchStartRequest.Builder> batchStartRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return batchStart(BatchStartRequest.builder().applyMutation(batchStartRequest).build());
    }

    /**
     * Stops running resources
     *
     * @param batchStopRequest
     *        A request to stop resources
     * @return Result of the BatchStop operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to stop the resources.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The resources you're requesting to stop do not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop resources.
     * @throws ConflictException
     *         The resources are unable to stop.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchStop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStop" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchStopResponse batchStop(BatchStopRequest batchStopRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops running resources<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchStopRequest.Builder} avoiding the need to
     * create one manually via {@link BatchStopRequest#builder()}
     * </p>
     *
     * @param batchStopRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.BatchStopRequest.Builder} to create a request. A
     *        request to stop resources
     * @return Result of the BatchStop operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to stop the resources.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The resources you're requesting to stop do not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop resources.
     * @throws ConflictException
     *         The resources are unable to stop.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchStop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStop" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchStopResponse batchStop(Consumer<BatchStopRequest.Builder> batchStopRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return batchStop(BatchStopRequest.builder().applyMutation(batchStopRequest).build());
    }

    /**
     * Update a channel schedule
     *
     * @param batchUpdateScheduleRequest
     *        List of actions to create and list of actions to delete.
     * @return Result of the BatchUpdateSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The update schedule request failed validation.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The specified channel id does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchUpdateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpdateScheduleResponse batchUpdateSchedule(BatchUpdateScheduleRequest batchUpdateScheduleRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a channel schedule<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateScheduleRequest#builder()}
     * </p>
     *
     * @param batchUpdateScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest.Builder} to create a
     *        request. List of actions to create and list of actions to delete.
     * @return Result of the BatchUpdateSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The update schedule request failed validation.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The specified channel id does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchUpdateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpdateScheduleResponse batchUpdateSchedule(
            Consumer<BatchUpdateScheduleRequest.Builder> batchUpdateScheduleRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return batchUpdateSchedule(BatchUpdateScheduleRequest.builder().applyMutation(batchUpdateScheduleRequest).build());
    }

    /**
     * Cancel an input device transfer that you have requested.
     *
     * @param cancelInputDeviceTransferRequest
     *        Placeholder documentation for CancelInputDeviceTransferRequest
     * @return Result of the CancelInputDeviceTransfer operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to cancel input device transfers.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device transfer could not be canceled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CancelInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CancelInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelInputDeviceTransferResponse cancelInputDeviceTransfer(
            CancelInputDeviceTransferRequest cancelInputDeviceTransferRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Cancel an input device transfer that you have requested.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelInputDeviceTransferRequest.Builder} avoiding
     * the need to create one manually via {@link CancelInputDeviceTransferRequest#builder()}
     * </p>
     *
     * @param cancelInputDeviceTransferRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferRequest.Builder} to create
     *        a request. Placeholder documentation for CancelInputDeviceTransferRequest
     * @return Result of the CancelInputDeviceTransfer operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to cancel input device transfers.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device transfer could not be canceled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CancelInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CancelInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelInputDeviceTransferResponse cancelInputDeviceTransfer(
            Consumer<CancelInputDeviceTransferRequest.Builder> cancelInputDeviceTransferRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return cancelInputDeviceTransfer(CancelInputDeviceTransferRequest.builder()
                .applyMutation(cancelInputDeviceTransferRequest).build());
    }

    /**
     * Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the
     * request succeeds, you will own the device.
     *
     * @param claimDeviceRequest
     *        A request to claim an AWS Elemental device that you have purchased from a third-party vendor.
     * @return Result of the ClaimDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Claim operation failed, device id could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have the IAM access permissions to claim this device. You must have permission for the
     *         WriteClaim operation.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Device not found or you called an unsupported region.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded. Your have sent this request too many times. There might be a bug in your API
     *         client.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ClaimDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ClaimDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default ClaimDeviceResponse claimDevice(ClaimDeviceRequest claimDeviceRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the
     * request succeeds, you will own the device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClaimDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link ClaimDeviceRequest#builder()}
     * </p>
     *
     * @param claimDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ClaimDeviceRequest.Builder} to create a request. A
     *        request to claim an AWS Elemental device that you have purchased from a third-party vendor.
     * @return Result of the ClaimDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Claim operation failed, device id could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have the IAM access permissions to claim this device. You must have permission for the
     *         WriteClaim operation.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Device not found or you called an unsupported region.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded. Your have sent this request too many times. There might be a bug in your API
     *         client.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ClaimDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ClaimDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default ClaimDeviceResponse claimDevice(Consumer<ClaimDeviceRequest.Builder> claimDeviceRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return claimDevice(ClaimDeviceRequest.builder().applyMutation(claimDeviceRequest).build());
    }

    /**
     * Creates a new channel
     *
     * @param createChannelRequest
     *        A request to create a channel
     * @return Result of the CreateChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The Channel failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to create the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on create channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to create due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a new channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateChannelRequest.Builder} to create a request.
     *        A request to create a channel
     * @return Result of the CreateChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The Channel failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to create the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on create channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to create due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateChannelResponse createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * Create a ChannelPlacementGroup in the specified Cluster. As part of the create operation, you specify the Nodes
     * to attach the group to.After you create a ChannelPlacementGroup, you add Channels to the group (you do this by
     * modifying the Channels to add them to a specific group). You now have an association of Channels to
     * ChannelPlacementGroup, and ChannelPlacementGroup to Nodes. This association means that all the Channels in the
     * group are able to run on any of the Nodes associated with the group.
     *
     * @param createChannelPlacementGroupRequest
     *        A request to create a channel placement group.
     * @return Result of the CreateChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The channel placement group failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create a channel placement group in this cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded in createNode calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChannelPlacementGroupResponse createChannelPlacementGroup(
            CreateChannelPlacementGroupRequest createChannelPlacementGroupRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a ChannelPlacementGroup in the specified Cluster. As part of the create operation, you specify the Nodes
     * to attach the group to.After you create a ChannelPlacementGroup, you add Channels to the group (you do this by
     * modifying the Channels to add them to a specific group). You now have an association of Channels to
     * ChannelPlacementGroup, and ChannelPlacementGroup to Nodes. This association means that all the Channels in the
     * group are able to run on any of the Nodes associated with the group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelPlacementGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateChannelPlacementGroupRequest#builder()}
     * </p>
     *
     * @param createChannelPlacementGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateChannelPlacementGroupRequest.Builder} to
     *        create a request. A request to create a channel placement group.
     * @return Result of the CreateChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The channel placement group failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create a channel placement group in this cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded in createNode calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChannelPlacementGroupResponse createChannelPlacementGroup(
            Consumer<CreateChannelPlacementGroupRequest.Builder> createChannelPlacementGroupRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return createChannelPlacementGroup(CreateChannelPlacementGroupRequest.builder()
                .applyMutation(createChannelPlacementGroupRequest).build());
    }

    /**
     * Creates a cloudwatch alarm template to dynamically generate cloudwatch metric alarms on targeted resource types.
     *
     * @param createCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for CreateCloudWatchAlarmTemplateRequest
     * @return Result of the CreateCloudWatchAlarmTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudWatchAlarmTemplateResponse createCloudWatchAlarmTemplate(
            CreateCloudWatchAlarmTemplateRequest createCloudWatchAlarmTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a cloudwatch alarm template to dynamically generate cloudwatch metric alarms on targeted resource types.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudWatchAlarmTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudWatchAlarmTemplateRequest#builder()}
     * </p>
     *
     * @param createCloudWatchAlarmTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for CreateCloudWatchAlarmTemplateRequest
     * @return Result of the CreateCloudWatchAlarmTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudWatchAlarmTemplateResponse createCloudWatchAlarmTemplate(
            Consumer<CreateCloudWatchAlarmTemplateRequest.Builder> createCloudWatchAlarmTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return createCloudWatchAlarmTemplate(CreateCloudWatchAlarmTemplateRequest.builder()
                .applyMutation(createCloudWatchAlarmTemplateRequest).build());
    }

    /**
     * Creates a cloudwatch alarm template group to group your cloudwatch alarm templates and to attach to signal maps
     * for dynamically creating alarms.
     *
     * @param createCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for CreateCloudWatchAlarmTemplateGroupRequest
     * @return Result of the CreateCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudWatchAlarmTemplateGroupResponse createCloudWatchAlarmTemplateGroup(
            CreateCloudWatchAlarmTemplateGroupRequest createCloudWatchAlarmTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a cloudwatch alarm template group to group your cloudwatch alarm templates and to attach to signal maps
     * for dynamically creating alarms.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudWatchAlarmTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudWatchAlarmTemplateGroupRequest#builder()}
     * </p>
     *
     * @param createCloudWatchAlarmTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for CreateCloudWatchAlarmTemplateGroupRequest
     * @return Result of the CreateCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudWatchAlarmTemplateGroupResponse createCloudWatchAlarmTemplateGroup(
            Consumer<CreateCloudWatchAlarmTemplateGroupRequest.Builder> createCloudWatchAlarmTemplateGroupRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return createCloudWatchAlarmTemplateGroup(CreateCloudWatchAlarmTemplateGroupRequest.builder()
                .applyMutation(createCloudWatchAlarmTemplateGroupRequest).build());
    }

    /**
     * Create a new Cluster.
     *
     * @param createClusterRequest
     *        Create as many Clusters as you want, but create at least one. Each Cluster groups together Nodes that you
     *        want to treat as a collection. Within the Cluster, you will set up some Nodes as active Nodes, and some as
     *        backup Nodes, for Node failover purposes. Each Node can belong to only one Cluster.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create the Cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create Cluster calls to service.
     * @throws ConflictException
     *         The Cluster is unable to create due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new Cluster.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateClusterRequest.Builder} to create a request.
     *        Create as many Clusters as you want, but create at least one. Each Cluster groups together Nodes that you
     *        want to treat as a collection. Within the Cluster, you will set up some Nodes as active Nodes, and some as
     *        backup Nodes, for Node failover purposes. Each Node can belong to only one Cluster.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create the Cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create Cluster calls to service.
     * @throws ConflictException
     *         The Cluster is unable to create due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * Creates an eventbridge rule template to monitor events and send notifications to your targeted resources.
     *
     * @param createEventBridgeRuleTemplateRequest
     *        Placeholder documentation for CreateEventBridgeRuleTemplateRequest
     * @return Result of the CreateEventBridgeRuleTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventBridgeRuleTemplateResponse createEventBridgeRuleTemplate(
            CreateEventBridgeRuleTemplateRequest createEventBridgeRuleTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates an eventbridge rule template to monitor events and send notifications to your targeted resources.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventBridgeRuleTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEventBridgeRuleTemplateRequest#builder()}
     * </p>
     *
     * @param createEventBridgeRuleTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for CreateEventBridgeRuleTemplateRequest
     * @return Result of the CreateEventBridgeRuleTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventBridgeRuleTemplateResponse createEventBridgeRuleTemplate(
            Consumer<CreateEventBridgeRuleTemplateRequest.Builder> createEventBridgeRuleTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return createEventBridgeRuleTemplate(CreateEventBridgeRuleTemplateRequest.builder()
                .applyMutation(createEventBridgeRuleTemplateRequest).build());
    }

    /**
     * Creates an eventbridge rule template group to group your eventbridge rule templates and to attach to signal maps
     * for dynamically creating notification rules.
     *
     * @param createEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for CreateEventBridgeRuleTemplateGroupRequest
     * @return Result of the CreateEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventBridgeRuleTemplateGroupResponse createEventBridgeRuleTemplateGroup(
            CreateEventBridgeRuleTemplateGroupRequest createEventBridgeRuleTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates an eventbridge rule template group to group your eventbridge rule templates and to attach to signal maps
     * for dynamically creating notification rules.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventBridgeRuleTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEventBridgeRuleTemplateGroupRequest#builder()}
     * </p>
     *
     * @param createEventBridgeRuleTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for CreateEventBridgeRuleTemplateGroupRequest
     * @return Result of the CreateEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventBridgeRuleTemplateGroupResponse createEventBridgeRuleTemplateGroup(
            Consumer<CreateEventBridgeRuleTemplateGroupRequest.Builder> createEventBridgeRuleTemplateGroupRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return createEventBridgeRuleTemplateGroup(CreateEventBridgeRuleTemplateGroupRequest.builder()
                .applyMutation(createEventBridgeRuleTemplateGroupRequest).build());
    }

    /**
     * Create an input
     *
     * @param createInputRequest
     *        The name of the input
     * @return Result of the CreateInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInputResponse createInput(CreateInputRequest createInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create an input<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInputRequest#builder()}
     * </p>
     *
     * @param createInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateInputRequest.Builder} to create a request.
     *        The name of the input
     * @return Result of the CreateInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInputResponse createInput(Consumer<CreateInputRequest.Builder> createInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return createInput(CreateInputRequest.builder().applyMutation(createInputRequest).build());
    }

    /**
     * Creates a Input Security Group
     *
     * @param createInputSecurityGroupRequest
     *        The IPv4 CIDRs to whitelist for this Input Security Group
     * @return Result of the CreateInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to create an Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to create an Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInputSecurityGroupResponse createInputSecurityGroup(
            CreateInputSecurityGroupRequest createInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest.Builder} to create
     *        a request. The IPv4 CIDRs to whitelist for this Input Security Group
     * @return Result of the CreateInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to create an Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to create an Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInputSecurityGroupResponse createInputSecurityGroup(
            Consumer<CreateInputSecurityGroupRequest.Builder> createInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return createInputSecurityGroup(CreateInputSecurityGroupRequest.builder().applyMutation(createInputSecurityGroupRequest)
                .build());
    }

    /**
     * Create a new multiplex.
     *
     * @param createMultiplexRequest
     *        A request to create a multiplex.
     * @return Result of the CreateMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The Multiplex failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to create the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on create multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to create due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMultiplexResponse createMultiplex(CreateMultiplexRequest createMultiplexRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMultiplexRequest#builder()}
     * </p>
     *
     * @param createMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest.Builder} to create a
     *        request. A request to create a multiplex.
     * @return Result of the CreateMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The Multiplex failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to create the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on create multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to create due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMultiplexResponse createMultiplex(Consumer<CreateMultiplexRequest.Builder> createMultiplexRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return createMultiplex(CreateMultiplexRequest.builder().applyMutation(createMultiplexRequest).build());
    }

    /**
     * Create a new program in the multiplex.
     *
     * @param createMultiplexProgramRequest
     *        A request to create a program in a multiplex.
     * @return Result of the CreateMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The Multiplex program failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to create a program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on create multiplex program calls to multiplex service.
     * @throws ConflictException
     *         The multiplex program is unable to create due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMultiplexProgramResponse createMultiplexProgram(CreateMultiplexProgramRequest createMultiplexProgramRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new program in the multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param createMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest.Builder} to create a
     *        request. A request to create a program in a multiplex.
     * @return Result of the CreateMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The Multiplex program failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to create a program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on create multiplex program calls to multiplex service.
     * @throws ConflictException
     *         The multiplex program is unable to create due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMultiplexProgramResponse createMultiplexProgram(
            Consumer<CreateMultiplexProgramRequest.Builder> createMultiplexProgramRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return createMultiplexProgram(CreateMultiplexProgramRequest.builder().applyMutation(createMultiplexProgramRequest)
                .build());
    }

    /**
     * Create as many Networks as you need. You will associate one or more Clusters with each Network.Each Network
     * provides MediaLive Anywhere with required information about the network in your organization that you are using
     * for video encoding using MediaLive.
     *
     * @param createNetworkRequest
     *        A request to create a Network.
     * @return Result of the CreateNetwork operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create the Network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create Network calls to service.
     * @throws ConflictException
     *         The Network is unable to create due to an issue with network resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNetworkResponse createNetwork(CreateNetworkRequest createNetworkRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create as many Networks as you need. You will associate one or more Clusters with each Network.Each Network
     * provides MediaLive Anywhere with required information about the network in your organization that you are using
     * for video encoding using MediaLive.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateNetworkRequest#builder()}
     * </p>
     *
     * @param createNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateNetworkRequest.Builder} to create a request.
     *        A request to create a Network.
     * @return Result of the CreateNetwork operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create the Network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create Network calls to service.
     * @throws ConflictException
     *         The Network is unable to create due to an issue with network resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNetworkResponse createNetwork(Consumer<CreateNetworkRequest.Builder> createNetworkRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return createNetwork(CreateNetworkRequest.builder().applyMutation(createNetworkRequest).build());
    }

    /**
     * Create a Node in the specified Cluster. You can also create Nodes using the CreateNodeRegistrationScript. Note
     * that you can't move a Node to another Cluster.
     *
     * @param createNodeRequest
     *        A request to create a node
     * @return Result of the CreateNode operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The node failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create a node in this cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded in createNode calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNodeResponse createNode(CreateNodeRequest createNodeRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a Node in the specified Cluster. You can also create Nodes using the CreateNodeRegistrationScript. Note
     * that you can't move a Node to another Cluster.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNodeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateNodeRequest#builder()}
     * </p>
     *
     * @param createNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateNodeRequest.Builder} to create a request. A
     *        request to create a node
     * @return Result of the CreateNode operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The node failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create a node in this cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded in createNode calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNodeResponse createNode(Consumer<CreateNodeRequest.Builder> createNodeRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return createNode(CreateNodeRequest.builder().applyMutation(createNodeRequest).build());
    }

    /**
     * Create the Register Node script for all the nodes intended for a specific Cluster. You will then run the script
     * on each hardware unit that is intended for that Cluster. The script creates a Node in the specified Cluster. It
     * then binds the Node to this hardware unit, and activates the node hardware for use with MediaLive Anywhere.
     *
     * @param createNodeRegistrationScriptRequest
     *        A request to create a new node registration script.
     * @return Result of the CreateNodeRegistrationScript operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create a node registration script for this cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create node registration script calls to service.
     * @throws ConflictException
     *         The node registration script is unable to be created due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateNodeRegistrationScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNodeRegistrationScript"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNodeRegistrationScriptResponse createNodeRegistrationScript(
            CreateNodeRegistrationScriptRequest createNodeRegistrationScriptRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create the Register Node script for all the nodes intended for a specific Cluster. You will then run the script
     * on each hardware unit that is intended for that Cluster. The script creates a Node in the specified Cluster. It
     * then binds the Node to this hardware unit, and activates the node hardware for use with MediaLive Anywhere.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNodeRegistrationScriptRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNodeRegistrationScriptRequest#builder()}
     * </p>
     *
     * @param createNodeRegistrationScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateNodeRegistrationScriptRequest.Builder} to
     *        create a request. A request to create a new node registration script.
     * @return Result of the CreateNodeRegistrationScript operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create a node registration script for this cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create node registration script calls to service.
     * @throws ConflictException
     *         The node registration script is unable to be created due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateNodeRegistrationScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNodeRegistrationScript"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNodeRegistrationScriptResponse createNodeRegistrationScript(
            Consumer<CreateNodeRegistrationScriptRequest.Builder> createNodeRegistrationScriptRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return createNodeRegistrationScript(CreateNodeRegistrationScriptRequest.builder()
                .applyMutation(createNodeRegistrationScriptRequest).build());
    }

    /**
     * Create a partner input
     *
     * @param createPartnerInputRequest
     *        A request to create a partner input
     * @return Result of the CreatePartnerInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreatePartnerInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreatePartnerInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePartnerInputResponse createPartnerInput(CreatePartnerInputRequest createPartnerInputRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a partner input<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartnerInputRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePartnerInputRequest#builder()}
     * </p>
     *
     * @param createPartnerInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest.Builder} to create a
     *        request. A request to create a partner input
     * @return Result of the CreatePartnerInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreatePartnerInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreatePartnerInput" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePartnerInputResponse createPartnerInput(Consumer<CreatePartnerInputRequest.Builder> createPartnerInputRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return createPartnerInput(CreatePartnerInputRequest.builder().applyMutation(createPartnerInputRequest).build());
    }

    /**
     * Initiates the creation of a new signal map. Will discover a new mediaResourceMap based on the provided
     * discoveryEntryPointArn.
     *
     * @param createSignalMapRequest
     *        Placeholder documentation for CreateSignalMapRequest
     * @return Result of the CreateSignalMap operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSignalMapResponse createSignalMap(CreateSignalMapRequest createSignalMapRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Initiates the creation of a new signal map. Will discover a new mediaResourceMap based on the provided
     * discoveryEntryPointArn.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSignalMapRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSignalMapRequest#builder()}
     * </p>
     *
     * @param createSignalMapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateSignalMapRequest.Builder} to create a
     *        request. Placeholder documentation for CreateSignalMapRequest
     * @return Result of the CreateSignalMap operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSignalMapResponse createSignalMap(Consumer<CreateSignalMapRequest.Builder> createSignalMapRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return createSignalMap(CreateSignalMapRequest.builder().applyMutation(createSignalMapRequest).build());
    }

    /**
     * Create tags for a resource
     *
     * @param createTagsRequest
     *        Placeholder documentation for CreateTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create tags for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.CreateTagsRequest.Builder} to create a request.
     *        Placeholder documentation for CreateTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.
     *
     * @param deleteChannelRequest
     *        Placeholder documentation for DeleteChannelRequest
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to delete the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to delete does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to delete due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteChannelRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteChannelRequest
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to delete the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to delete does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to delete due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * Delete the specified ChannelPlacementGroup that exists in the specified Cluster.
     *
     * @param deleteChannelPlacementGroupRequest
     *        Placeholder documentation for DeleteChannelPlacementGroupRequest
     * @return Result of the DeleteChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the channel placement group.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The channel placement group that you are trying to delete does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete channel placement group calls to the cluster service.
     * @throws ConflictException
     *         The channel placement group is unable to delete due to an issue with channel placement group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChannelPlacementGroupResponse deleteChannelPlacementGroup(
            DeleteChannelPlacementGroupRequest deleteChannelPlacementGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete the specified ChannelPlacementGroup that exists in the specified Cluster.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelPlacementGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteChannelPlacementGroupRequest#builder()}
     * </p>
     *
     * @param deleteChannelPlacementGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteChannelPlacementGroupRequest.Builder} to
     *        create a request. Placeholder documentation for DeleteChannelPlacementGroupRequest
     * @return Result of the DeleteChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the channel placement group.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The channel placement group that you are trying to delete does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete channel placement group calls to the cluster service.
     * @throws ConflictException
     *         The channel placement group is unable to delete due to an issue with channel placement group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChannelPlacementGroupResponse deleteChannelPlacementGroup(
            Consumer<DeleteChannelPlacementGroupRequest.Builder> deleteChannelPlacementGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteChannelPlacementGroup(DeleteChannelPlacementGroupRequest.builder()
                .applyMutation(deleteChannelPlacementGroupRequest).build());
    }

    /**
     * Deletes a cloudwatch alarm template.
     *
     * @param deleteCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for DeleteCloudWatchAlarmTemplateRequest
     * @return Result of the DeleteCloudWatchAlarmTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudWatchAlarmTemplateResponse deleteCloudWatchAlarmTemplate(
            DeleteCloudWatchAlarmTemplateRequest deleteCloudWatchAlarmTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a cloudwatch alarm template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudWatchAlarmTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCloudWatchAlarmTemplateRequest#builder()}
     * </p>
     *
     * @param deleteCloudWatchAlarmTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for DeleteCloudWatchAlarmTemplateRequest
     * @return Result of the DeleteCloudWatchAlarmTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudWatchAlarmTemplateResponse deleteCloudWatchAlarmTemplate(
            Consumer<DeleteCloudWatchAlarmTemplateRequest.Builder> deleteCloudWatchAlarmTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteCloudWatchAlarmTemplate(DeleteCloudWatchAlarmTemplateRequest.builder()
                .applyMutation(deleteCloudWatchAlarmTemplateRequest).build());
    }

    /**
     * Deletes a cloudwatch alarm template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.
     *
     * @param deleteCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for DeleteCloudWatchAlarmTemplateGroupRequest
     * @return Result of the DeleteCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudWatchAlarmTemplateGroupResponse deleteCloudWatchAlarmTemplateGroup(
            DeleteCloudWatchAlarmTemplateGroupRequest deleteCloudWatchAlarmTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a cloudwatch alarm template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudWatchAlarmTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCloudWatchAlarmTemplateGroupRequest#builder()}
     * </p>
     *
     * @param deleteCloudWatchAlarmTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for DeleteCloudWatchAlarmTemplateGroupRequest
     * @return Result of the DeleteCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudWatchAlarmTemplateGroupResponse deleteCloudWatchAlarmTemplateGroup(
            Consumer<DeleteCloudWatchAlarmTemplateGroupRequest.Builder> deleteCloudWatchAlarmTemplateGroupRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteCloudWatchAlarmTemplateGroup(DeleteCloudWatchAlarmTemplateGroupRequest.builder()
                .applyMutation(deleteCloudWatchAlarmTemplateGroupRequest).build());
    }

    /**
     * Delete a Cluster. The Cluster must be idle.
     *
     * @param deleteClusterRequest
     *        Placeholder documentation for DeleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The cluster that you are trying to delete doesn't exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete cluster calls to cluster service.
     * @throws ConflictException
     *         The cluster is unable to delete due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a Cluster. The Cluster must be idle.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteClusterRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The cluster that you are trying to delete doesn't exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete cluster calls to cluster service.
     * @throws ConflictException
     *         The cluster is unable to delete due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * Deletes an eventbridge rule template.
     *
     * @param deleteEventBridgeRuleTemplateRequest
     *        Placeholder documentation for DeleteEventBridgeRuleTemplateRequest
     * @return Result of the DeleteEventBridgeRuleTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventBridgeRuleTemplateResponse deleteEventBridgeRuleTemplate(
            DeleteEventBridgeRuleTemplateRequest deleteEventBridgeRuleTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an eventbridge rule template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventBridgeRuleTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEventBridgeRuleTemplateRequest#builder()}
     * </p>
     *
     * @param deleteEventBridgeRuleTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for DeleteEventBridgeRuleTemplateRequest
     * @return Result of the DeleteEventBridgeRuleTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventBridgeRuleTemplateResponse deleteEventBridgeRuleTemplate(
            Consumer<DeleteEventBridgeRuleTemplateRequest.Builder> deleteEventBridgeRuleTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteEventBridgeRuleTemplate(DeleteEventBridgeRuleTemplateRequest.builder()
                .applyMutation(deleteEventBridgeRuleTemplateRequest).build());
    }

    /**
     * Deletes an eventbridge rule template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.
     *
     * @param deleteEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for DeleteEventBridgeRuleTemplateGroupRequest
     * @return Result of the DeleteEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventBridgeRuleTemplateGroupResponse deleteEventBridgeRuleTemplateGroup(
            DeleteEventBridgeRuleTemplateGroupRequest deleteEventBridgeRuleTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an eventbridge rule template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventBridgeRuleTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEventBridgeRuleTemplateGroupRequest#builder()}
     * </p>
     *
     * @param deleteEventBridgeRuleTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for DeleteEventBridgeRuleTemplateGroupRequest
     * @return Result of the DeleteEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventBridgeRuleTemplateGroupResponse deleteEventBridgeRuleTemplateGroup(
            Consumer<DeleteEventBridgeRuleTemplateGroupRequest.Builder> deleteEventBridgeRuleTemplateGroupRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteEventBridgeRuleTemplateGroup(DeleteEventBridgeRuleTemplateGroupRequest.builder()
                .applyMutation(deleteEventBridgeRuleTemplateGroupRequest).build());
    }

    /**
     * Deletes the input end point
     *
     * @param deleteInputRequest
     *        Placeholder documentation for DeleteInputRequest
     * @return Result of the DeleteInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws ConflictException
     *         Resource conflict
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInputResponse deleteInput(DeleteInputRequest deleteInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the input end point<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInputRequest#builder()}
     * </p>
     *
     * @param deleteInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteInputRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteInputRequest
     * @return Result of the DeleteInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws ConflictException
     *         Resource conflict
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInputResponse deleteInput(Consumer<DeleteInputRequest.Builder> deleteInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteInput(DeleteInputRequest.builder().applyMutation(deleteInputRequest).build());
    }

    /**
     * Deletes an Input Security Group
     *
     * @param deleteInputSecurityGroupRequest
     *        Placeholder documentation for DeleteInputSecurityGroupRequest
     * @return Result of the DeleteInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to delete the Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to delete this Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input Security Group not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInputSecurityGroupResponse deleteInputSecurityGroup(
            DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest.Builder} to create
     *        a request. Placeholder documentation for DeleteInputSecurityGroupRequest
     * @return Result of the DeleteInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to delete the Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to delete this Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input Security Group not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInputSecurityGroupResponse deleteInputSecurityGroup(
            Consumer<DeleteInputSecurityGroupRequest.Builder> deleteInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteInputSecurityGroup(DeleteInputSecurityGroupRequest.builder().applyMutation(deleteInputSecurityGroupRequest)
                .build());
    }

    /**
     * Delete a multiplex. The multiplex must be idle.
     *
     * @param deleteMultiplexRequest
     *        Placeholder documentation for DeleteMultiplexRequest
     * @return Result of the DeleteMultiplex operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to delete the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to delete doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to delete due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMultiplexResponse deleteMultiplex(DeleteMultiplexRequest deleteMultiplexRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a multiplex. The multiplex must be idle.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteMultiplexRequest#builder()}
     * </p>
     *
     * @param deleteMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteMultiplexRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteMultiplexRequest
     * @return Result of the DeleteMultiplex operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to delete the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to delete doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to delete due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMultiplexResponse deleteMultiplex(Consumer<DeleteMultiplexRequest.Builder> deleteMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return deleteMultiplex(DeleteMultiplexRequest.builder().applyMutation(deleteMultiplexRequest).build());
    }

    /**
     * Delete a program from a multiplex.
     *
     * @param deleteMultiplexProgramRequest
     *        Placeholder documentation for DeleteMultiplexProgramRequest
     * @return Result of the DeleteMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to delete the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The program that you are trying to delete doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete multiplex program calls to multiplex service.
     * @throws ConflictException
     *         The multiplex program is unable to delete due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMultiplexProgramResponse deleteMultiplexProgram(DeleteMultiplexProgramRequest deleteMultiplexProgramRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a program from a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param deleteMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteMultiplexProgramRequest
     * @return Result of the DeleteMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to delete the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The program that you are trying to delete doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete multiplex program calls to multiplex service.
     * @throws ConflictException
     *         The multiplex program is unable to delete due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMultiplexProgramResponse deleteMultiplexProgram(
            Consumer<DeleteMultiplexProgramRequest.Builder> deleteMultiplexProgramRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteMultiplexProgram(DeleteMultiplexProgramRequest.builder().applyMutation(deleteMultiplexProgramRequest)
                .build());
    }

    /**
     * Delete a Network. The Network must have no resources associated with it.
     *
     * @param deleteNetworkRequest
     *        Placeholder documentation for DeleteNetworkRequest
     * @return Result of the DeleteNetwork operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The network that you are trying to delete doesnâ€™t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete network calls to network service.
     * @throws ConflictException
     *         The network is unable to delete due to an issue with network resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNetworkResponse deleteNetwork(DeleteNetworkRequest deleteNetworkRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a Network. The Network must have no resources associated with it.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteNetworkRequest#builder()}
     * </p>
     *
     * @param deleteNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteNetworkRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteNetworkRequest
     * @return Result of the DeleteNetwork operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The network that you are trying to delete doesnâ€™t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete network calls to network service.
     * @throws ConflictException
     *         The network is unable to delete due to an issue with network resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNetworkResponse deleteNetwork(Consumer<DeleteNetworkRequest.Builder> deleteNetworkRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return deleteNetwork(DeleteNetworkRequest.builder().applyMutation(deleteNetworkRequest).build());
    }

    /**
     * Delete a Node. The Node must be IDLE.
     *
     * @param deleteNodeRequest
     *        Placeholder documentation for DeleteNodeRequest
     * @return Result of the DeleteNode operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The node that you are trying to delete doesnâ€™t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete node calls to the cluster service.
     * @throws ConflictException
     *         The node is unable to delete due to an issue with node resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteNode" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNodeResponse deleteNode(DeleteNodeRequest deleteNodeRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a Node. The Node must be IDLE.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNodeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteNodeRequest#builder()}
     * </p>
     *
     * @param deleteNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteNodeRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteNodeRequest
     * @return Result of the DeleteNode operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The node that you are trying to delete doesnâ€™t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete node calls to the cluster service.
     * @throws ConflictException
     *         The node is unable to delete due to an issue with node resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteNode" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNodeResponse deleteNode(Consumer<DeleteNodeRequest.Builder> deleteNodeRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteNode(DeleteNodeRequest.builder().applyMutation(deleteNodeRequest).build());
    }

    /**
     * Delete an expired reservation.
     *
     * @param deleteReservationRequest
     *        Placeholder documentation for DeleteReservationRequest
     * @return Result of the DeleteReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to delete reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation you're attempting to delete does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete reservation request
     * @throws ConflictException
     *         The reservation could not be deleted because it is currently active.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReservationResponse deleteReservation(DeleteReservationRequest deleteReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an expired reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReservationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReservationRequest#builder()}
     * </p>
     *
     * @param deleteReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteReservationRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteReservationRequest
     * @return Result of the DeleteReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to delete reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation you're attempting to delete does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete reservation request
     * @throws ConflictException
     *         The reservation could not be deleted because it is currently active.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReservationResponse deleteReservation(Consumer<DeleteReservationRequest.Builder> deleteReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return deleteReservation(DeleteReservationRequest.builder().applyMutation(deleteReservationRequest).build());
    }

    /**
     * Delete all schedule actions on a channel.
     *
     * @param deleteScheduleRequest
     *        Placeholder documentation for DeleteScheduleRequest
     * @return Result of the DeleteSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request to delete the schedule on this channel was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to delete the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The specified channel does not exist to have its schedule deleted.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteScheduleResponse deleteSchedule(DeleteScheduleRequest deleteScheduleRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete all schedule actions on a channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteScheduleRequest#builder()}
     * </p>
     *
     * @param deleteScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteScheduleRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteScheduleRequest
     * @return Result of the DeleteSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request to delete the schedule on this channel was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to delete the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The specified channel does not exist to have its schedule deleted.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteScheduleResponse deleteSchedule(Consumer<DeleteScheduleRequest.Builder> deleteScheduleRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteSchedule(DeleteScheduleRequest.builder().applyMutation(deleteScheduleRequest).build());
    }

    /**
     * Deletes the specified signal map.
     *
     * @param deleteSignalMapRequest
     *        Placeholder documentation for DeleteSignalMapRequest
     * @return Result of the DeleteSignalMap operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSignalMapResponse deleteSignalMap(DeleteSignalMapRequest deleteSignalMapRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the specified signal map.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSignalMapRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSignalMapRequest#builder()}
     * </p>
     *
     * @param deleteSignalMapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteSignalMapRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteSignalMapRequest
     * @return Result of the DeleteSignalMap operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSignalMapResponse deleteSignalMap(Consumer<DeleteSignalMapRequest.Builder> deleteSignalMapRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteSignalMap(DeleteSignalMapRequest.builder().applyMutation(deleteSignalMapRequest).build());
    }

    /**
     * Removes tags for a resource
     *
     * @param deleteTagsRequest
     *        Placeholder documentation for DeleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes tags for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DeleteTagsRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * Describe account configuration
     *
     * @param describeAccountConfigurationRequest
     *        Placeholder documentation for DescribeAccountConfigurationRequest
     * @return Result of the DescribeAccountConfiguration operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the account configuration.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe account configuration calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountConfigurationResponse describeAccountConfiguration(
            DescribeAccountConfigurationRequest describeAccountConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Describe account configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAccountConfigurationRequest#builder()}
     * </p>
     *
     * @param describeAccountConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeAccountConfigurationRequest
     * @return Result of the DescribeAccountConfiguration operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the account configuration.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe account configuration calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountConfigurationResponse describeAccountConfiguration(
            Consumer<DescribeAccountConfigurationRequest.Builder> describeAccountConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeAccountConfiguration(DescribeAccountConfigurationRequest.builder()
                .applyMutation(describeAccountConfigurationRequest).build());
    }

    /**
     * Gets details about a channel
     *
     * @param describeChannelRequest
     *        Placeholder documentation for DescribeChannelRequest
     * @return Result of the DescribeChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to describe does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeChannelResponse describeChannel(DescribeChannelRequest describeChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets details about a channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChannelRequest#builder()}
     * </p>
     *
     * @param describeChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeChannelRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeChannelRequest
     * @return Result of the DescribeChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to describe does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeChannelResponse describeChannel(Consumer<DescribeChannelRequest.Builder> describeChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeChannel(DescribeChannelRequest.builder().applyMutation(describeChannelRequest).build());
    }

    /**
     * Get details about a ChannelPlacementGroup.
     *
     * @param describeChannelPlacementGroupRequest
     *        Placeholder documentation for DescribeChannelPlacementGroupRequest
     * @return Result of the DescribeChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You do not have permission to describe the channel placement group.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The channel placement group that you are trying to describe does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe channel placement group calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChannelPlacementGroupResponse describeChannelPlacementGroup(
            DescribeChannelPlacementGroupRequest describeChannelPlacementGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details about a ChannelPlacementGroup.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChannelPlacementGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeChannelPlacementGroupRequest#builder()}
     * </p>
     *
     * @param describeChannelPlacementGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeChannelPlacementGroupRequest
     * @return Result of the DescribeChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You do not have permission to describe the channel placement group.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The channel placement group that you are trying to describe does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe channel placement group calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChannelPlacementGroupResponse describeChannelPlacementGroup(
            Consumer<DescribeChannelPlacementGroupRequest.Builder> describeChannelPlacementGroupRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeChannelPlacementGroup(DescribeChannelPlacementGroupRequest.builder()
                .applyMutation(describeChannelPlacementGroupRequest).build());
    }

    /**
     * Get details about a Cluster.
     *
     * @param describeClusterRequest
     *        Placeholder documentation for DescribeClusterRequest
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to describe the cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The cluster that you are trying to describe does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details about a Cluster.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterRequest#builder()}
     * </p>
     *
     * @param describeClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeClusterRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeClusterRequest
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to describe the cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The cluster that you are trying to describe does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterResponse describeCluster(Consumer<DescribeClusterRequest.Builder> describeClusterRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeCluster(DescribeClusterRequest.builder().applyMutation(describeClusterRequest).build());
    }

    /**
     * Produces details about an input
     *
     * @param describeInputRequest
     *        Placeholder documentation for DescribeInputRequest
     * @return Result of the DescribeInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeInputResponse describeInput(DescribeInputRequest describeInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces details about an input<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeInputRequest#builder()}
     * </p>
     *
     * @param describeInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeInputRequest
     * @return Result of the DescribeInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeInputResponse describeInput(Consumer<DescribeInputRequest.Builder> describeInputRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInput(DescribeInputRequest.builder().applyMutation(describeInputRequest).build());
    }

    /**
     * Gets the details for the input device
     *
     * @param describeInputDeviceRequest
     *        Placeholder documentation for DescribeInputDeviceRequest
     * @return Result of the DescribeInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         The input device you're requesting to describe does not exist. Check the ID.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInputDeviceResponse describeInputDevice(DescribeInputDeviceRequest describeInputDeviceRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets the details for the input device<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeInputDeviceRequest#builder()}
     * </p>
     *
     * @param describeInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputDeviceRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeInputDeviceRequest
     * @return Result of the DescribeInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         The input device you're requesting to describe does not exist. Check the ID.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInputDeviceResponse describeInputDevice(
            Consumer<DescribeInputDeviceRequest.Builder> describeInputDeviceRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputDevice(DescribeInputDeviceRequest.builder().applyMutation(describeInputDeviceRequest).build());
    }

    /**
     * Get the latest thumbnail data for the input device.
     *
     * @param describeInputDeviceThumbnailRequest
     *        Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        DescribeInputDeviceThumbnailResponse and an InputStream to the response content are provided as parameters
     *        to the callback. The callback may return a transformed type which will be the return value of this method.
     *        See {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this
     *        interface and for links to pre-canned implementations for common scenarios like downloading to a file. The
     *        service documentation for the response content is as follows 'The binary data for the thumbnail that the
     *        Link device has most recently sent to MediaLive.'.
     * @return The transformed result of the ResponseTransformer.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe input device thumbnail.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on get thumbnail calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDeviceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT describeInputDeviceThumbnail(
            DescribeInputDeviceThumbnailRequest describeInputDeviceThumbnailRequest,
            ResponseTransformer<DescribeInputDeviceThumbnailResponse, ReturnT> responseTransformer) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get the latest thumbnail data for the input device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputDeviceThumbnailRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInputDeviceThumbnailRequest#builder()}
     * </p>
     *
     * @param describeInputDeviceThumbnailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        DescribeInputDeviceThumbnailResponse and an InputStream to the response content are provided as parameters
     *        to the callback. The callback may return a transformed type which will be the return value of this method.
     *        See {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this
     *        interface and for links to pre-canned implementations for common scenarios like downloading to a file. The
     *        service documentation for the response content is as follows 'The binary data for the thumbnail that the
     *        Link device has most recently sent to MediaLive.'.
     * @return The transformed result of the ResponseTransformer.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe input device thumbnail.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on get thumbnail calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDeviceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT describeInputDeviceThumbnail(
            Consumer<DescribeInputDeviceThumbnailRequest.Builder> describeInputDeviceThumbnailRequest,
            ResponseTransformer<DescribeInputDeviceThumbnailResponse, ReturnT> responseTransformer) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputDeviceThumbnail(
                DescribeInputDeviceThumbnailRequest.builder().applyMutation(describeInputDeviceThumbnailRequest).build(),
                responseTransformer);
    }

    /**
     * Get the latest thumbnail data for the input device.
     *
     * @param describeInputDeviceThumbnailRequest
     *        Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows 'The binary data for the thumbnail that
     *        the Link device has most recently sent to MediaLive.'.
     * @return The transformed result of the ResponseTransformer.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe input device thumbnail.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on get thumbnail calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDeviceThumbnail
     * @see #describeInputDeviceThumbnail(DescribeInputDeviceThumbnailRequest, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInputDeviceThumbnailResponse describeInputDeviceThumbnail(
            DescribeInputDeviceThumbnailRequest describeInputDeviceThumbnailRequest, Path destinationPath)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputDeviceThumbnail(describeInputDeviceThumbnailRequest, ResponseTransformer.toFile(destinationPath));
    }

    /**
     * Get the latest thumbnail data for the input device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputDeviceThumbnailRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInputDeviceThumbnailRequest#builder()}
     * </p>
     *
     * @param describeInputDeviceThumbnailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows 'The binary data for the thumbnail that
     *        the Link device has most recently sent to MediaLive.'.
     * @return The transformed result of the ResponseTransformer.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe input device thumbnail.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on get thumbnail calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDeviceThumbnail
     * @see #describeInputDeviceThumbnail(DescribeInputDeviceThumbnailRequest, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInputDeviceThumbnailResponse describeInputDeviceThumbnail(
            Consumer<DescribeInputDeviceThumbnailRequest.Builder> describeInputDeviceThumbnailRequest, Path destinationPath)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputDeviceThumbnail(
                DescribeInputDeviceThumbnailRequest.builder().applyMutation(describeInputDeviceThumbnailRequest).build(),
                destinationPath);
    }

    /**
     * Get the latest thumbnail data for the input device.
     *
     * @param describeInputDeviceThumbnailRequest
     *        Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         'The binary data for the thumbnail that the Link device has most recently sent to MediaLive.'.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe input device thumbnail.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on get thumbnail calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDeviceThumbnail
     * @see #getObject(describeInputDeviceThumbnail, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<DescribeInputDeviceThumbnailResponse> describeInputDeviceThumbnail(
            DescribeInputDeviceThumbnailRequest describeInputDeviceThumbnailRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputDeviceThumbnail(describeInputDeviceThumbnailRequest, ResponseTransformer.toInputStream());
    }

    /**
     * Get the latest thumbnail data for the input device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputDeviceThumbnailRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInputDeviceThumbnailRequest#builder()}
     * </p>
     *
     * @param describeInputDeviceThumbnailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         'The binary data for the thumbnail that the Link device has most recently sent to MediaLive.'.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe input device thumbnail.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on get thumbnail calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDeviceThumbnail
     * @see #getObject(describeInputDeviceThumbnail, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<DescribeInputDeviceThumbnailResponse> describeInputDeviceThumbnail(
            Consumer<DescribeInputDeviceThumbnailRequest.Builder> describeInputDeviceThumbnailRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputDeviceThumbnail(DescribeInputDeviceThumbnailRequest.builder()
                .applyMutation(describeInputDeviceThumbnailRequest).build());
    }

    /**
     * Get the latest thumbnail data for the input device.
     *
     * @param describeInputDeviceThumbnailRequest
     *        Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows 'The binary data for the thumbnail that the Link device has most recently sent to MediaLive.'.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe input device thumbnail.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on get thumbnail calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDeviceThumbnail
     * @see #getObject(describeInputDeviceThumbnail, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseBytes<DescribeInputDeviceThumbnailResponse> describeInputDeviceThumbnailAsBytes(
            DescribeInputDeviceThumbnailRequest describeInputDeviceThumbnailRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputDeviceThumbnail(describeInputDeviceThumbnailRequest, ResponseTransformer.toBytes());
    }

    /**
     * Get the latest thumbnail data for the input device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputDeviceThumbnailRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInputDeviceThumbnailRequest#builder()}
     * </p>
     *
     * @param describeInputDeviceThumbnailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows 'The binary data for the thumbnail that the Link device has most recently sent to MediaLive.'.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe input device thumbnail.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on get thumbnail calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDeviceThumbnail
     * @see #getObject(describeInputDeviceThumbnail, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseBytes<DescribeInputDeviceThumbnailResponse> describeInputDeviceThumbnailAsBytes(
            Consumer<DescribeInputDeviceThumbnailRequest.Builder> describeInputDeviceThumbnailRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputDeviceThumbnailAsBytes(DescribeInputDeviceThumbnailRequest.builder()
                .applyMutation(describeInputDeviceThumbnailRequest).build());
    }

    /**
     * Produces a summary of an Input Security Group
     *
     * @param describeInputSecurityGroupRequest
     *        Placeholder documentation for DescribeInputSecurityGroupRequest
     * @return Result of the DescribeInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to describe an Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to describe this Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input Security Group not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInputSecurityGroupResponse describeInputSecurityGroup(
            DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces a summary of an Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param describeInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest.Builder} to
     *        create a request. Placeholder documentation for DescribeInputSecurityGroupRequest
     * @return Result of the DescribeInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to describe an Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to describe this Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input Security Group not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInputSecurityGroupResponse describeInputSecurityGroup(
            Consumer<DescribeInputSecurityGroupRequest.Builder> describeInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputSecurityGroup(DescribeInputSecurityGroupRequest.builder()
                .applyMutation(describeInputSecurityGroupRequest).build());
    }

    /**
     * Gets details about a multiplex.
     *
     * @param describeMultiplexRequest
     *        Placeholder documentation for DescribeMultiplexRequest
     * @return Result of the DescribeMultiplex operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to describe the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to describe doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMultiplexResponse describeMultiplex(DescribeMultiplexRequest describeMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets details about a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeMultiplexRequest#builder()}
     * </p>
     *
     * @param describeMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeMultiplexRequest
     * @return Result of the DescribeMultiplex operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to describe the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to describe doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMultiplexResponse describeMultiplex(Consumer<DescribeMultiplexRequest.Builder> describeMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeMultiplex(DescribeMultiplexRequest.builder().applyMutation(describeMultiplexRequest).build());
    }

    /**
     * Get the details for a program in a multiplex.
     *
     * @param describeMultiplexProgramRequest
     *        Placeholder documentation for DescribeMultiplexProgramRequest
     * @return Result of the DescribeMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to describe the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't describe the program. The multiplex or the program that you specified doesn’t exist.
     *         Check the IDs and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe multiplex program calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMultiplexProgramResponse describeMultiplexProgram(
            DescribeMultiplexProgramRequest describeMultiplexProgramRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get the details for a program in a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMultiplexProgramRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param describeMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramRequest.Builder} to create
     *        a request. Placeholder documentation for DescribeMultiplexProgramRequest
     * @return Result of the DescribeMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to describe the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't describe the program. The multiplex or the program that you specified doesn’t exist.
     *         Check the IDs and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe multiplex program calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMultiplexProgramResponse describeMultiplexProgram(
            Consumer<DescribeMultiplexProgramRequest.Builder> describeMultiplexProgramRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeMultiplexProgram(DescribeMultiplexProgramRequest.builder().applyMutation(describeMultiplexProgramRequest)
                .build());
    }

    /**
     * Get details about a Network.
     *
     * @param describeNetworkRequest
     *        Placeholder documentation for DescribeNetworkRequest
     * @return Result of the DescribeNetwork operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to describe the network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The network that you are trying to describe does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe network calls to network service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeNetworkResponse describeNetwork(DescribeNetworkRequest describeNetworkRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details about a Network.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeNetworkRequest#builder()}
     * </p>
     *
     * @param describeNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeNetworkRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeNetworkRequest
     * @return Result of the DescribeNetwork operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to describe the network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The network that you are trying to describe does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe network calls to network service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeNetworkResponse describeNetwork(Consumer<DescribeNetworkRequest.Builder> describeNetworkRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeNetwork(DescribeNetworkRequest.builder().applyMutation(describeNetworkRequest).build());
    }

    /**
     * Get details about a Node in the specified Cluster.
     *
     * @param describeNodeRequest
     *        Placeholder documentation for DescribeNodeRequest
     * @return Result of the DescribeNode operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to describe the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The node that you are trying to describe doesnâ€™t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe node calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeNode" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeNodeResponse describeNode(DescribeNodeRequest describeNodeRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details about a Node in the specified Cluster.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNodeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeNodeRequest#builder()}
     * </p>
     *
     * @param describeNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeNodeRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeNodeRequest
     * @return Result of the DescribeNode operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to describe the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The node that you are trying to describe doesnâ€™t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe node calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeNode" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeNodeResponse describeNode(Consumer<DescribeNodeRequest.Builder> describeNodeRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeNode(DescribeNodeRequest.builder().applyMutation(describeNodeRequest).build());
    }

    /**
     * Get details for an offering.
     *
     * @param describeOfferingRequest
     *        Placeholder documentation for DescribeOfferingRequest
     * @return Result of the DescribeOffering operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to describe offering
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Offering you're attempting to describe does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe offering request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeOfferingResponse describeOffering(DescribeOfferingRequest describeOfferingRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details for an offering.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeOfferingRequest#builder()}
     * </p>
     *
     * @param describeOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeOfferingRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeOfferingRequest
     * @return Result of the DescribeOffering operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to describe offering
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Offering you're attempting to describe does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe offering request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeOfferingResponse describeOffering(Consumer<DescribeOfferingRequest.Builder> describeOfferingRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeOffering(DescribeOfferingRequest.builder().applyMutation(describeOfferingRequest).build());
    }

    /**
     * Get details for a reservation.
     *
     * @param describeReservationRequest
     *        Placeholder documentation for DescribeReservationRequest
     * @return Result of the DescribeReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to describe reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation you're attempting to describe does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe reservation request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReservationResponse describeReservation(DescribeReservationRequest describeReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details for a reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservationRequest#builder()}
     * </p>
     *
     * @param describeReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeReservationRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeReservationRequest
     * @return Result of the DescribeReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to describe reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation you're attempting to describe does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe reservation request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReservationResponse describeReservation(
            Consumer<DescribeReservationRequest.Builder> describeReservationRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeReservation(DescribeReservationRequest.builder().applyMutation(describeReservationRequest).build());
    }

    /**
     * Get a channel schedule
     *
     * @param describeScheduleRequest
     *        Placeholder documentation for DescribeScheduleRequest
     * @return Result of the DescribeSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting a schedule describe for does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeScheduleResponse describeSchedule(DescribeScheduleRequest describeScheduleRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a channel schedule<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeScheduleRequest#builder()}
     * </p>
     *
     * @param describeScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeScheduleRequest
     * @return Result of the DescribeSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting a schedule describe for does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeScheduleResponse describeSchedule(Consumer<DescribeScheduleRequest.Builder> describeScheduleRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeSchedule(DescribeScheduleRequest.builder().applyMutation(describeScheduleRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client.describeSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client
     *             .describeSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client.describeSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation.</b>
     * </p>
     *
     * @param describeScheduleRequest
     *        Placeholder documentation for DescribeScheduleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting a schedule describe for does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeScheduleIterable describeSchedulePaginator(DescribeScheduleRequest describeScheduleRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new DescribeScheduleIterable(this, describeScheduleRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client.describeSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client
     *             .describeSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client.describeSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeScheduleRequest#builder()}
     * </p>
     *
     * @param describeScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeScheduleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting a schedule describe for does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeScheduleIterable describeSchedulePaginator(Consumer<DescribeScheduleRequest.Builder> describeScheduleRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeSchedulePaginator(DescribeScheduleRequest.builder().applyMutation(describeScheduleRequest).build());
    }

    /**
     * Describe the latest thumbnails data.
     *
     * @param describeThumbnailsRequest
     *        Placeholder documentation for DescribeThumbnailsRequest
     * @return Result of the DescribeThumbnails operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe thumbnails.
     * @throws BadGatewayException
     *         Bad Gateway error.
     * @throws NotFoundException
     *         There are no thumbnails for this channel.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe thumbnails calls to channel service.
     * @throws ConflictException
     *         Service do not have permission to customer's KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeThumbnails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeThumbnails" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeThumbnailsResponse describeThumbnails(DescribeThumbnailsRequest describeThumbnailsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Describe the latest thumbnails data.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThumbnailsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeThumbnailsRequest#builder()}
     * </p>
     *
     * @param describeThumbnailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.DescribeThumbnailsRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeThumbnailsRequest
     * @return Result of the DescribeThumbnails operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe thumbnails.
     * @throws BadGatewayException
     *         Bad Gateway error.
     * @throws NotFoundException
     *         There are no thumbnails for this channel.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe thumbnails calls to channel service.
     * @throws ConflictException
     *         Service do not have permission to customer's KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeThumbnails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeThumbnails" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeThumbnailsResponse describeThumbnails(Consumer<DescribeThumbnailsRequest.Builder> describeThumbnailsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return describeThumbnails(DescribeThumbnailsRequest.builder().applyMutation(describeThumbnailsRequest).build());
    }

    /**
     * Retrieves the specified cloudwatch alarm template.
     *
     * @param getCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for GetCloudWatchAlarmTemplateRequest
     * @return Result of the GetCloudWatchAlarmTemplate operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudWatchAlarmTemplateResponse getCloudWatchAlarmTemplate(
            GetCloudWatchAlarmTemplateRequest getCloudWatchAlarmTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the specified cloudwatch alarm template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudWatchAlarmTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetCloudWatchAlarmTemplateRequest#builder()}
     * </p>
     *
     * @param getCloudWatchAlarmTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for GetCloudWatchAlarmTemplateRequest
     * @return Result of the GetCloudWatchAlarmTemplate operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudWatchAlarmTemplateResponse getCloudWatchAlarmTemplate(
            Consumer<GetCloudWatchAlarmTemplateRequest.Builder> getCloudWatchAlarmTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return getCloudWatchAlarmTemplate(GetCloudWatchAlarmTemplateRequest.builder()
                .applyMutation(getCloudWatchAlarmTemplateRequest).build());
    }

    /**
     * Retrieves the specified cloudwatch alarm template group.
     *
     * @param getCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for GetCloudWatchAlarmTemplateGroupRequest
     * @return Result of the GetCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudWatchAlarmTemplateGroupResponse getCloudWatchAlarmTemplateGroup(
            GetCloudWatchAlarmTemplateGroupRequest getCloudWatchAlarmTemplateGroupRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the specified cloudwatch alarm template group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudWatchAlarmTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link GetCloudWatchAlarmTemplateGroupRequest#builder()}
     * </p>
     *
     * @param getCloudWatchAlarmTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupRequest.Builder} to
     *        create a request. Placeholder documentation for GetCloudWatchAlarmTemplateGroupRequest
     * @return Result of the GetCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudWatchAlarmTemplateGroupResponse getCloudWatchAlarmTemplateGroup(
            Consumer<GetCloudWatchAlarmTemplateGroupRequest.Builder> getCloudWatchAlarmTemplateGroupRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        return getCloudWatchAlarmTemplateGroup(GetCloudWatchAlarmTemplateGroupRequest.builder()
                .applyMutation(getCloudWatchAlarmTemplateGroupRequest).build());
    }

    /**
     * Retrieves the specified eventbridge rule template.
     *
     * @param getEventBridgeRuleTemplateRequest
     *        Placeholder documentation for GetEventBridgeRuleTemplateRequest
     * @return Result of the GetEventBridgeRuleTemplate operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventBridgeRuleTemplateResponse getEventBridgeRuleTemplate(
            GetEventBridgeRuleTemplateRequest getEventBridgeRuleTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the specified eventbridge rule template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventBridgeRuleTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetEventBridgeRuleTemplateRequest#builder()}
     * </p>
     *
     * @param getEventBridgeRuleTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for GetEventBridgeRuleTemplateRequest
     * @return Result of the GetEventBridgeRuleTemplate operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventBridgeRuleTemplateResponse getEventBridgeRuleTemplate(
            Consumer<GetEventBridgeRuleTemplateRequest.Builder> getEventBridgeRuleTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return getEventBridgeRuleTemplate(GetEventBridgeRuleTemplateRequest.builder()
                .applyMutation(getEventBridgeRuleTemplateRequest).build());
    }

    /**
     * Retrieves the specified eventbridge rule template group.
     *
     * @param getEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for GetEventBridgeRuleTemplateGroupRequest
     * @return Result of the GetEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventBridgeRuleTemplateGroupResponse getEventBridgeRuleTemplateGroup(
            GetEventBridgeRuleTemplateGroupRequest getEventBridgeRuleTemplateGroupRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the specified eventbridge rule template group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventBridgeRuleTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link GetEventBridgeRuleTemplateGroupRequest#builder()}
     * </p>
     *
     * @param getEventBridgeRuleTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupRequest.Builder} to
     *        create a request. Placeholder documentation for GetEventBridgeRuleTemplateGroupRequest
     * @return Result of the GetEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventBridgeRuleTemplateGroupResponse getEventBridgeRuleTemplateGroup(
            Consumer<GetEventBridgeRuleTemplateGroupRequest.Builder> getEventBridgeRuleTemplateGroupRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        return getEventBridgeRuleTemplateGroup(GetEventBridgeRuleTemplateGroupRequest.builder()
                .applyMutation(getEventBridgeRuleTemplateGroupRequest).build());
    }

    /**
     * Retrieves the specified signal map.
     *
     * @param getSignalMapRequest
     *        Placeholder documentation for GetSignalMapRequest
     * @return Result of the GetSignalMap operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSignalMapResponse getSignalMap(GetSignalMapRequest getSignalMapRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the specified signal map.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSignalMapRequest.Builder} avoiding the need to
     * create one manually via {@link GetSignalMapRequest#builder()}
     * </p>
     *
     * @param getSignalMapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.GetSignalMapRequest.Builder} to create a request.
     *        Placeholder documentation for GetSignalMapRequest
     * @return Result of the GetSignalMap operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSignalMapResponse getSignalMap(Consumer<GetSignalMapRequest.Builder> getSignalMapRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        return getSignalMap(GetSignalMapRequest.builder().applyMutation(getSignalMapRequest).build());
    }

    /**
     * Retrieve the list of ChannelPlacementGroups in the specified Cluster.
     *
     * @param listChannelPlacementGroupsRequest
     *        Placeholder documentation for ListChannelPlacementGroupsRequest
     * @return Result of the ListChannelPlacementGroups operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list channel placement groups.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel placement group calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannelPlacementGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannelPlacementGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelPlacementGroupsResponse listChannelPlacementGroups(
            ListChannelPlacementGroupsRequest listChannelPlacementGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the list of ChannelPlacementGroups in the specified Cluster.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelPlacementGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListChannelPlacementGroupsRequest#builder()}
     * </p>
     *
     * @param listChannelPlacementGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest.Builder} to
     *        create a request. Placeholder documentation for ListChannelPlacementGroupsRequest
     * @return Result of the ListChannelPlacementGroups operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list channel placement groups.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel placement group calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannelPlacementGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannelPlacementGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelPlacementGroupsResponse listChannelPlacementGroups(
            Consumer<ListChannelPlacementGroupsRequest.Builder> listChannelPlacementGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listChannelPlacementGroups(ListChannelPlacementGroupsRequest.builder()
                .applyMutation(listChannelPlacementGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannelPlacementGroups(software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelPlacementGroupsIterable responses = client.listChannelPlacementGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListChannelPlacementGroupsIterable responses = client
     *             .listChannelPlacementGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelPlacementGroupsIterable responses = client.listChannelPlacementGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannelPlacementGroups(software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChannelPlacementGroupsRequest
     *        Placeholder documentation for ListChannelPlacementGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list channel placement groups.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel placement group calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannelPlacementGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannelPlacementGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelPlacementGroupsIterable listChannelPlacementGroupsPaginator(
            ListChannelPlacementGroupsRequest listChannelPlacementGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListChannelPlacementGroupsIterable(this, listChannelPlacementGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannelPlacementGroups(software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelPlacementGroupsIterable responses = client.listChannelPlacementGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListChannelPlacementGroupsIterable responses = client
     *             .listChannelPlacementGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelPlacementGroupsIterable responses = client.listChannelPlacementGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannelPlacementGroups(software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelPlacementGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListChannelPlacementGroupsRequest#builder()}
     * </p>
     *
     * @param listChannelPlacementGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest.Builder} to
     *        create a request. Placeholder documentation for ListChannelPlacementGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list channel placement groups.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel placement group calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannelPlacementGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannelPlacementGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelPlacementGroupsIterable listChannelPlacementGroupsPaginator(
            Consumer<ListChannelPlacementGroupsRequest.Builder> listChannelPlacementGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listChannelPlacementGroupsPaginator(ListChannelPlacementGroupsRequest.builder()
                .applyMutation(listChannelPlacementGroupsRequest).build());
    }

    /**
     * Produces list of channels that have been created
     *
     * @param listChannelsRequest
     *        Placeholder documentation for ListChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of channels that have been created<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListChannelsRequest.Builder} to create a request.
     *        Placeholder documentation for ListChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * Produces list of channels that have been created
     *
     * @return Result of the ListChannels operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see #listChannels(ListChannelsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels() throws BadRequestException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return listChannels(ListChannelsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see #listChannelsPaginator(ListChannelsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listChannelsPaginator(ListChannelsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     *        Placeholder documentation for ListChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(ListChannelsRequest listChannelsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListChannelsIterable(this, listChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListChannelsRequest.Builder} to create a request.
     *        Placeholder documentation for ListChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * Lists cloudwatch alarm template groups.
     *
     * @param listCloudWatchAlarmTemplateGroupsRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplateGroupsRequest
     * @return Result of the ListCloudWatchAlarmTemplateGroups operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListCloudWatchAlarmTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplateGroupsResponse listCloudWatchAlarmTemplateGroups(
            ListCloudWatchAlarmTemplateGroupsRequest listCloudWatchAlarmTemplateGroupsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists cloudwatch alarm template groups.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudWatchAlarmTemplateGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudWatchAlarmTemplateGroupsRequest#builder()}
     * </p>
     *
     * @param listCloudWatchAlarmTemplateGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest.Builder}
     *        to create a request. Placeholder documentation for ListCloudWatchAlarmTemplateGroupsRequest
     * @return Result of the ListCloudWatchAlarmTemplateGroups operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListCloudWatchAlarmTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplateGroupsResponse listCloudWatchAlarmTemplateGroups(
            Consumer<ListCloudWatchAlarmTemplateGroupsRequest.Builder> listCloudWatchAlarmTemplateGroupsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        return listCloudWatchAlarmTemplateGroups(ListCloudWatchAlarmTemplateGroupsRequest.builder()
                .applyMutation(listCloudWatchAlarmTemplateGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudWatchAlarmTemplateGroups(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsIterable responses = client.listCloudWatchAlarmTemplateGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsIterable responses = client
     *             .listCloudWatchAlarmTemplateGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsIterable responses = client.listCloudWatchAlarmTemplateGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudWatchAlarmTemplateGroups(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCloudWatchAlarmTemplateGroupsRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplateGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListCloudWatchAlarmTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplateGroupsIterable listCloudWatchAlarmTemplateGroupsPaginator(
            ListCloudWatchAlarmTemplateGroupsRequest listCloudWatchAlarmTemplateGroupsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return new ListCloudWatchAlarmTemplateGroupsIterable(this, listCloudWatchAlarmTemplateGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudWatchAlarmTemplateGroups(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsIterable responses = client.listCloudWatchAlarmTemplateGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsIterable responses = client
     *             .listCloudWatchAlarmTemplateGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplateGroupsIterable responses = client.listCloudWatchAlarmTemplateGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudWatchAlarmTemplateGroups(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudWatchAlarmTemplateGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudWatchAlarmTemplateGroupsRequest#builder()}
     * </p>
     *
     * @param listCloudWatchAlarmTemplateGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest.Builder}
     *        to create a request. Placeholder documentation for ListCloudWatchAlarmTemplateGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListCloudWatchAlarmTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplateGroupsIterable listCloudWatchAlarmTemplateGroupsPaginator(
            Consumer<ListCloudWatchAlarmTemplateGroupsRequest.Builder> listCloudWatchAlarmTemplateGroupsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        return listCloudWatchAlarmTemplateGroupsPaginator(ListCloudWatchAlarmTemplateGroupsRequest.builder()
                .applyMutation(listCloudWatchAlarmTemplateGroupsRequest).build());
    }

    /**
     * Lists cloudwatch alarm templates.
     *
     * @param listCloudWatchAlarmTemplatesRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplatesRequest
     * @return Result of the ListCloudWatchAlarmTemplates operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListCloudWatchAlarmTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplatesResponse listCloudWatchAlarmTemplates(
            ListCloudWatchAlarmTemplatesRequest listCloudWatchAlarmTemplatesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists cloudwatch alarm templates.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudWatchAlarmTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudWatchAlarmTemplatesRequest#builder()}
     * </p>
     *
     * @param listCloudWatchAlarmTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest.Builder} to
     *        create a request. Placeholder documentation for ListCloudWatchAlarmTemplatesRequest
     * @return Result of the ListCloudWatchAlarmTemplates operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListCloudWatchAlarmTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplatesResponse listCloudWatchAlarmTemplates(
            Consumer<ListCloudWatchAlarmTemplatesRequest.Builder> listCloudWatchAlarmTemplatesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listCloudWatchAlarmTemplates(ListCloudWatchAlarmTemplatesRequest.builder()
                .applyMutation(listCloudWatchAlarmTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudWatchAlarmTemplates(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesIterable responses = client.listCloudWatchAlarmTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesIterable responses = client
     *             .listCloudWatchAlarmTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesIterable responses = client.listCloudWatchAlarmTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudWatchAlarmTemplates(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCloudWatchAlarmTemplatesRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListCloudWatchAlarmTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplatesIterable listCloudWatchAlarmTemplatesPaginator(
            ListCloudWatchAlarmTemplatesRequest listCloudWatchAlarmTemplatesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return new ListCloudWatchAlarmTemplatesIterable(this, listCloudWatchAlarmTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudWatchAlarmTemplates(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesIterable responses = client.listCloudWatchAlarmTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesIterable responses = client
     *             .listCloudWatchAlarmTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListCloudWatchAlarmTemplatesIterable responses = client.listCloudWatchAlarmTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudWatchAlarmTemplates(software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudWatchAlarmTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudWatchAlarmTemplatesRequest#builder()}
     * </p>
     *
     * @param listCloudWatchAlarmTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest.Builder} to
     *        create a request. Placeholder documentation for ListCloudWatchAlarmTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListCloudWatchAlarmTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudWatchAlarmTemplatesIterable listCloudWatchAlarmTemplatesPaginator(
            Consumer<ListCloudWatchAlarmTemplatesRequest.Builder> listCloudWatchAlarmTemplatesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listCloudWatchAlarmTemplatesPaginator(ListCloudWatchAlarmTemplatesRequest.builder()
                .applyMutation(listCloudWatchAlarmTemplatesRequest).build());
    }

    /**
     * Retrieve the list of Clusters.
     *
     * @param listClustersRequest
     *        Placeholder documentation for ListClustersRequest
     * @return Result of the ListClusters operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list clusters.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the list of Clusters.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListClustersRequest.Builder} to create a request.
     *        Placeholder documentation for ListClustersRequest
     * @return Result of the ListClusters operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list clusters.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.medialive.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.medialive.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     *        Placeholder documentation for ListClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list clusters.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListClustersIterable(this, listClustersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.medialive.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.medialive.model.ListClustersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListClustersRequest.Builder} to create a request.
     *        Placeholder documentation for ListClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list clusters.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * Lists eventbridge rule template groups.
     *
     * @param listEventBridgeRuleTemplateGroupsRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
     * @return Result of the ListEventBridgeRuleTemplateGroups operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListEventBridgeRuleTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplateGroupsResponse listEventBridgeRuleTemplateGroups(
            ListEventBridgeRuleTemplateGroupsRequest listEventBridgeRuleTemplateGroupsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists eventbridge rule template groups.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventBridgeRuleTemplateGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventBridgeRuleTemplateGroupsRequest#builder()}
     * </p>
     *
     * @param listEventBridgeRuleTemplateGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest.Builder}
     *        to create a request. Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
     * @return Result of the ListEventBridgeRuleTemplateGroups operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListEventBridgeRuleTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplateGroupsResponse listEventBridgeRuleTemplateGroups(
            Consumer<ListEventBridgeRuleTemplateGroupsRequest.Builder> listEventBridgeRuleTemplateGroupsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        return listEventBridgeRuleTemplateGroups(ListEventBridgeRuleTemplateGroupsRequest.builder()
                .applyMutation(listEventBridgeRuleTemplateGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventBridgeRuleTemplateGroups(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsIterable responses = client.listEventBridgeRuleTemplateGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsIterable responses = client
     *             .listEventBridgeRuleTemplateGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsIterable responses = client.listEventBridgeRuleTemplateGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventBridgeRuleTemplateGroups(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventBridgeRuleTemplateGroupsRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListEventBridgeRuleTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplateGroupsIterable listEventBridgeRuleTemplateGroupsPaginator(
            ListEventBridgeRuleTemplateGroupsRequest listEventBridgeRuleTemplateGroupsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return new ListEventBridgeRuleTemplateGroupsIterable(this, listEventBridgeRuleTemplateGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventBridgeRuleTemplateGroups(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsIterable responses = client.listEventBridgeRuleTemplateGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsIterable responses = client
     *             .listEventBridgeRuleTemplateGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplateGroupsIterable responses = client.listEventBridgeRuleTemplateGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventBridgeRuleTemplateGroups(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventBridgeRuleTemplateGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventBridgeRuleTemplateGroupsRequest#builder()}
     * </p>
     *
     * @param listEventBridgeRuleTemplateGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest.Builder}
     *        to create a request. Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListEventBridgeRuleTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplateGroupsIterable listEventBridgeRuleTemplateGroupsPaginator(
            Consumer<ListEventBridgeRuleTemplateGroupsRequest.Builder> listEventBridgeRuleTemplateGroupsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        return listEventBridgeRuleTemplateGroupsPaginator(ListEventBridgeRuleTemplateGroupsRequest.builder()
                .applyMutation(listEventBridgeRuleTemplateGroupsRequest).build());
    }

    /**
     * Lists eventbridge rule templates.
     *
     * @param listEventBridgeRuleTemplatesRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplatesRequest
     * @return Result of the ListEventBridgeRuleTemplates operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListEventBridgeRuleTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplatesResponse listEventBridgeRuleTemplates(
            ListEventBridgeRuleTemplatesRequest listEventBridgeRuleTemplatesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists eventbridge rule templates.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventBridgeRuleTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventBridgeRuleTemplatesRequest#builder()}
     * </p>
     *
     * @param listEventBridgeRuleTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest.Builder} to
     *        create a request. Placeholder documentation for ListEventBridgeRuleTemplatesRequest
     * @return Result of the ListEventBridgeRuleTemplates operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListEventBridgeRuleTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplatesResponse listEventBridgeRuleTemplates(
            Consumer<ListEventBridgeRuleTemplatesRequest.Builder> listEventBridgeRuleTemplatesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listEventBridgeRuleTemplates(ListEventBridgeRuleTemplatesRequest.builder()
                .applyMutation(listEventBridgeRuleTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventBridgeRuleTemplates(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesIterable responses = client.listEventBridgeRuleTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesIterable responses = client
     *             .listEventBridgeRuleTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesIterable responses = client.listEventBridgeRuleTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventBridgeRuleTemplates(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventBridgeRuleTemplatesRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListEventBridgeRuleTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplatesIterable listEventBridgeRuleTemplatesPaginator(
            ListEventBridgeRuleTemplatesRequest listEventBridgeRuleTemplatesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return new ListEventBridgeRuleTemplatesIterable(this, listEventBridgeRuleTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventBridgeRuleTemplates(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesIterable responses = client.listEventBridgeRuleTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesIterable responses = client
     *             .listEventBridgeRuleTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListEventBridgeRuleTemplatesIterable responses = client.listEventBridgeRuleTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventBridgeRuleTemplates(software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventBridgeRuleTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventBridgeRuleTemplatesRequest#builder()}
     * </p>
     *
     * @param listEventBridgeRuleTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest.Builder} to
     *        create a request. Placeholder documentation for ListEventBridgeRuleTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListEventBridgeRuleTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventBridgeRuleTemplatesIterable listEventBridgeRuleTemplatesPaginator(
            Consumer<ListEventBridgeRuleTemplatesRequest.Builder> listEventBridgeRuleTemplatesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listEventBridgeRuleTemplatesPaginator(ListEventBridgeRuleTemplatesRequest.builder()
                .applyMutation(listEventBridgeRuleTemplatesRequest).build());
    }

    /**
     * List input devices that are currently being transferred. List input devices that you are transferring from your
     * AWS account or input devices that another AWS account is transferring to you.
     *
     * @param listInputDeviceTransfersRequest
     *        Placeholder documentation for ListInputDeviceTransfersRequest
     * @return Result of the ListInputDeviceTransfers operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list transferring devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDeviceTransfers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputDeviceTransfersResponse listInputDeviceTransfers(
            ListInputDeviceTransfersRequest listInputDeviceTransfersRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List input devices that are currently being transferred. List input devices that you are transferring from your
     * AWS account or input devices that another AWS account is transferring to you.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDeviceTransfersRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputDeviceTransfersRequest#builder()}
     * </p>
     *
     * @param listInputDeviceTransfersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest.Builder} to create
     *        a request. Placeholder documentation for ListInputDeviceTransfersRequest
     * @return Result of the ListInputDeviceTransfers operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list transferring devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDeviceTransfers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputDeviceTransfersResponse listInputDeviceTransfers(
            Consumer<ListInputDeviceTransfersRequest.Builder> listInputDeviceTransfersRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputDeviceTransfers(ListInputDeviceTransfersRequest.builder().applyMutation(listInputDeviceTransfersRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputDeviceTransfers(software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersIterable responses = client.listInputDeviceTransfersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersIterable responses = client
     *             .listInputDeviceTransfersPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersIterable responses = client.listInputDeviceTransfersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDeviceTransfers(software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInputDeviceTransfersRequest
     *        Placeholder documentation for ListInputDeviceTransfersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list transferring devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDeviceTransfers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputDeviceTransfersIterable listInputDeviceTransfersPaginator(
            ListInputDeviceTransfersRequest listInputDeviceTransfersRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListInputDeviceTransfersIterable(this, listInputDeviceTransfersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputDeviceTransfers(software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersIterable responses = client.listInputDeviceTransfersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersIterable responses = client
     *             .listInputDeviceTransfersPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDeviceTransfersIterable responses = client.listInputDeviceTransfersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDeviceTransfers(software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDeviceTransfersRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputDeviceTransfersRequest#builder()}
     * </p>
     *
     * @param listInputDeviceTransfersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest.Builder} to create
     *        a request. Placeholder documentation for ListInputDeviceTransfersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list transferring devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDeviceTransfers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputDeviceTransfersIterable listInputDeviceTransfersPaginator(
            Consumer<ListInputDeviceTransfersRequest.Builder> listInputDeviceTransfersRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputDeviceTransfersPaginator(ListInputDeviceTransfersRequest.builder()
                .applyMutation(listInputDeviceTransfersRequest).build());
    }

    /**
     * List input devices
     *
     * @param listInputDevicesRequest
     *        Placeholder documentation for ListInputDevicesRequest
     * @return Result of the ListInputDevices operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInputDevicesResponse listInputDevices(ListInputDevicesRequest listInputDevicesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List input devices<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInputDevicesRequest#builder()}
     * </p>
     *
     * @param listInputDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputDevicesRequest
     * @return Result of the ListInputDevices operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInputDevicesResponse listInputDevices(Consumer<ListInputDevicesRequest.Builder> listInputDevicesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputDevices(ListInputDevicesRequest.builder().applyMutation(listInputDevicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client.listInputDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client
     *             .listInputDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client.listInputDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listInputDevicesRequest
     *        Placeholder documentation for ListInputDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInputDevicesIterable listInputDevicesPaginator(ListInputDevicesRequest listInputDevicesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListInputDevicesIterable(this, listInputDevicesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client.listInputDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client
     *             .listInputDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client.listInputDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInputDevicesRequest#builder()}
     * </p>
     *
     * @param listInputDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInputDevicesIterable listInputDevicesPaginator(Consumer<ListInputDevicesRequest.Builder> listInputDevicesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputDevicesPaginator(ListInputDevicesRequest.builder().applyMutation(listInputDevicesRequest).build());
    }

    /**
     * Produces a list of Input Security Groups for an account
     *
     * @param listInputSecurityGroupsRequest
     *        Placeholder documentation for ListInputSecurityGroupsRequest
     * @return Result of the ListInputSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsResponse listInputSecurityGroups(ListInputSecurityGroupsRequest listInputSecurityGroupsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces a list of Input Security Groups for an account<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputSecurityGroupsRequest
     * @return Result of the ListInputSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsResponse listInputSecurityGroups(
            Consumer<ListInputSecurityGroupsRequest.Builder> listInputSecurityGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputSecurityGroups(ListInputSecurityGroupsRequest.builder().applyMutation(listInputSecurityGroupsRequest)
                .build());
    }

    /**
     * Produces a list of Input Security Groups for an account
     *
     * @return Result of the ListInputSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see #listInputSecurityGroups(ListInputSecurityGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsResponse listInputSecurityGroups() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listInputSecurityGroups(ListInputSecurityGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client
     *             .listInputSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see #listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsIterable listInputSecurityGroupsPaginator() throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client
     *             .listInputSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsIterable listInputSecurityGroupsPaginator(
            ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListInputSecurityGroupsIterable(this, listInputSecurityGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client
     *             .listInputSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsIterable listInputSecurityGroupsPaginator(
            Consumer<ListInputSecurityGroupsRequest.Builder> listInputSecurityGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest.builder()
                .applyMutation(listInputSecurityGroupsRequest).build());
    }

    /**
     * Produces list of inputs that have been created
     *
     * @param listInputsRequest
     *        Placeholder documentation for ListInputsRequest
     * @return Result of the ListInputs operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsResponse listInputs(ListInputsRequest listInputsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of inputs that have been created<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputsRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputsRequest
     * @return Result of the ListInputs operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsResponse listInputs(Consumer<ListInputsRequest.Builder> listInputsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputs(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * Produces list of inputs that have been created
     *
     * @return Result of the ListInputs operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see #listInputs(ListInputsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsResponse listInputs() throws BadRequestException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return listInputs(ListInputsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see #listInputsPaginator(ListInputsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsIterable listInputsPaginator() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listInputsPaginator(ListInputsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     *
     * @param listInputsRequest
     *        Placeholder documentation for ListInputsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsIterable listInputsPaginator(ListInputsRequest listInputsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListInputsIterable(this, listInputsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListInputsRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsIterable listInputsPaginator(Consumer<ListInputsRequest.Builder> listInputsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputsPaginator(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * List the programs that currently exist for a specific multiplex.
     *
     * @param listMultiplexProgramsRequest
     *        Placeholder documentation for ListMultiplexProgramsRequest
     * @return Result of the ListMultiplexPrograms operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list multiplex programs.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't provide the list of programs. The multiplex that you specified doesn’t exist. Check the
     *         ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexPrograms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsResponse listMultiplexPrograms(ListMultiplexProgramsRequest listMultiplexProgramsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List the programs that currently exist for a specific multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexProgramsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultiplexProgramsRequest#builder()}
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexProgramsRequest
     * @return Result of the ListMultiplexPrograms operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list multiplex programs.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't provide the list of programs. The multiplex that you specified doesn’t exist. Check the
     *         ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexPrograms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsResponse listMultiplexPrograms(
            Consumer<ListMultiplexProgramsRequest.Builder> listMultiplexProgramsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listMultiplexPrograms(ListMultiplexProgramsRequest.builder().applyMutation(listMultiplexProgramsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client.listMultiplexProgramsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client
     *             .listMultiplexProgramsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client.listMultiplexProgramsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        Placeholder documentation for ListMultiplexProgramsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list multiplex programs.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't provide the list of programs. The multiplex that you specified doesn’t exist. Check the
     *         ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexPrograms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsIterable listMultiplexProgramsPaginator(ListMultiplexProgramsRequest listMultiplexProgramsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListMultiplexProgramsIterable(this, listMultiplexProgramsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client.listMultiplexProgramsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client
     *             .listMultiplexProgramsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client.listMultiplexProgramsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexProgramsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultiplexProgramsRequest#builder()}
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexProgramsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list multiplex programs.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't provide the list of programs. The multiplex that you specified doesn’t exist. Check the
     *         ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexPrograms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsIterable listMultiplexProgramsPaginator(
            Consumer<ListMultiplexProgramsRequest.Builder> listMultiplexProgramsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listMultiplexProgramsPaginator(ListMultiplexProgramsRequest.builder().applyMutation(listMultiplexProgramsRequest)
                .build());
    }

    /**
     * Retrieve a list of the existing multiplexes.
     *
     * @param listMultiplexesRequest
     *        Placeholder documentation for ListMultiplexesRequest
     * @return Result of the ListMultiplexes operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to list multiplexes.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesResponse listMultiplexes(ListMultiplexesRequest listMultiplexesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a list of the existing multiplexes.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListMultiplexesRequest#builder()}
     * </p>
     *
     * @param listMultiplexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexesRequest
     * @return Result of the ListMultiplexes operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to list multiplexes.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesResponse listMultiplexes(Consumer<ListMultiplexesRequest.Builder> listMultiplexesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listMultiplexes(ListMultiplexesRequest.builder().applyMutation(listMultiplexesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client.listMultiplexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client
     *             .listMultiplexesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client.listMultiplexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation.</b>
     * </p>
     *
     * @param listMultiplexesRequest
     *        Placeholder documentation for ListMultiplexesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to list multiplexes.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesIterable listMultiplexesPaginator(ListMultiplexesRequest listMultiplexesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListMultiplexesIterable(this, listMultiplexesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client.listMultiplexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client
     *             .listMultiplexesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client.listMultiplexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListMultiplexesRequest#builder()}
     * </p>
     *
     * @param listMultiplexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to list multiplexes.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesIterable listMultiplexesPaginator(Consumer<ListMultiplexesRequest.Builder> listMultiplexesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listMultiplexesPaginator(ListMultiplexesRequest.builder().applyMutation(listMultiplexesRequest).build());
    }

    /**
     * Retrieve the list of Networks.
     *
     * @param listNetworksRequest
     *        Placeholder documentation for ListNetworksRequest
     * @return Result of the ListNetworks operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list clusters.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNetworksResponse listNetworks(ListNetworksRequest listNetworksRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the list of Networks.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListNetworksRequest#builder()}
     * </p>
     *
     * @param listNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListNetworksRequest.Builder} to create a request.
     *        Placeholder documentation for ListNetworksRequest
     * @return Result of the ListNetworks operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list clusters.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNetworksResponse listNetworks(Consumer<ListNetworksRequest.Builder> listNetworksRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listNetworks(ListNetworksRequest.builder().applyMutation(listNetworksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listNetworks(software.amazon.awssdk.services.medialive.model.ListNetworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworks(software.amazon.awssdk.services.medialive.model.ListNetworksRequest)} operation.</b>
     * </p>
     *
     * @param listNetworksRequest
     *        Placeholder documentation for ListNetworksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list clusters.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNetworksIterable listNetworksPaginator(ListNetworksRequest listNetworksRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListNetworksIterable(this, listNetworksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listNetworks(software.amazon.awssdk.services.medialive.model.ListNetworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListNetworksIterable responses = client.listNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworks(software.amazon.awssdk.services.medialive.model.ListNetworksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListNetworksRequest#builder()}
     * </p>
     *
     * @param listNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListNetworksRequest.Builder} to create a request.
     *        Placeholder documentation for ListNetworksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list clusters.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNetworksIterable listNetworksPaginator(Consumer<ListNetworksRequest.Builder> listNetworksRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listNetworksPaginator(ListNetworksRequest.builder().applyMutation(listNetworksRequest).build());
    }

    /**
     * Retrieve the list of Nodes.
     *
     * @param listNodesRequest
     *        Placeholder documentation for ListNodesRequest
     * @return Result of the ListNodes operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list nodes.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list node calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesResponse listNodes(ListNodesRequest listNodesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the list of Nodes.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListNodesRequest.Builder} to create a request.
     *        Placeholder documentation for ListNodesRequest
     * @return Result of the ListNodes operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list nodes.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list node calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesResponse listNodes(Consumer<ListNodesRequest.Builder> listNodesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listNodes(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.medialive.model.ListNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.medialive.model.ListNodesRequest)} operation.</b>
     * </p>
     *
     * @param listNodesRequest
     *        Placeholder documentation for ListNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list nodes.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list node calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesIterable listNodesPaginator(ListNodesRequest listNodesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListNodesIterable(this, listNodesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.medialive.model.ListNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.medialive.model.ListNodesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListNodesRequest.Builder} to create a request.
     *        Placeholder documentation for ListNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list nodes.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list node calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesIterable listNodesPaginator(Consumer<ListNodesRequest.Builder> listNodesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listNodesPaginator(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * List offerings available for purchase.
     *
     * @param listOfferingsRequest
     *        Placeholder documentation for ListOfferingsRequest
     * @return Result of the ListOfferings operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsResponse listOfferings(ListOfferingsRequest listOfferingsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List offerings available for purchase.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListOfferingsRequest.Builder} to create a request.
     *        Placeholder documentation for ListOfferingsRequest
     * @return Result of the ListOfferings operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsResponse listOfferings(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listOfferings(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * List offerings available for purchase.
     *
     * @return Result of the ListOfferings operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see #listOfferings(ListOfferingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsResponse listOfferings() throws BadRequestException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return listOfferings(ListOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see #listOfferingsPaginator(ListOfferingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listOfferingsPaginator(ListOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @param listOfferingsRequest
     *        Placeholder documentation for ListOfferingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator(ListOfferingsRequest listOfferingsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListOfferingsIterable(this, listOfferingsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListOfferingsRequest.Builder} to create a request.
     *        Placeholder documentation for ListOfferingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listOfferingsPaginator(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * List purchased reservations.
     *
     * @param listReservationsRequest
     *        Placeholder documentation for ListReservationsRequest
     * @return Result of the ListReservations operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsResponse listReservations(ListReservationsRequest listReservationsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List purchased reservations.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListReservationsRequest.Builder} to create a
     *        request. Placeholder documentation for ListReservationsRequest
     * @return Result of the ListReservations operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsResponse listReservations(Consumer<ListReservationsRequest.Builder> listReservationsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listReservations(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * List purchased reservations.
     *
     * @return Result of the ListReservations operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see #listReservations(ListReservationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsResponse listReservations() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listReservations(ListReservationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client
     *             .listReservationsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListReservationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see #listReservationsPaginator(ListReservationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsIterable listReservationsPaginator() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listReservationsPaginator(ListReservationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client
     *             .listReservationsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListReservationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     *
     * @param listReservationsRequest
     *        Placeholder documentation for ListReservationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsIterable listReservationsPaginator(ListReservationsRequest listReservationsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return new ListReservationsIterable(this, listReservationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client
     *             .listReservationsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListReservationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListReservationsRequest.Builder} to create a
     *        request. Placeholder documentation for ListReservationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReservationsIterable listReservationsPaginator(Consumer<ListReservationsRequest.Builder> listReservationsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listReservationsPaginator(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * Lists signal maps.
     *
     * @param listSignalMapsRequest
     *        Placeholder documentation for ListSignalMapsRequest
     * @return Result of the ListSignalMaps operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListSignalMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSignalMapsResponse listSignalMaps(ListSignalMapsRequest listSignalMapsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists signal maps.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalMapsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSignalMapsRequest#builder()}
     * </p>
     *
     * @param listSignalMapsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest.Builder} to create a request.
     *        Placeholder documentation for ListSignalMapsRequest
     * @return Result of the ListSignalMaps operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListSignalMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSignalMapsResponse listSignalMaps(Consumer<ListSignalMapsRequest.Builder> listSignalMapsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        return listSignalMaps(ListSignalMapsRequest.builder().applyMutation(listSignalMapsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSignalMaps(software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListSignalMapsIterable responses = client.listSignalMapsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListSignalMapsIterable responses = client
     *             .listSignalMapsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListSignalMapsIterable responses = client.listSignalMapsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalMaps(software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest)} operation.</b>
     * </p>
     *
     * @param listSignalMapsRequest
     *        Placeholder documentation for ListSignalMapsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListSignalMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSignalMapsIterable listSignalMapsPaginator(ListSignalMapsRequest listSignalMapsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return new ListSignalMapsIterable(this, listSignalMapsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSignalMaps(software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListSignalMapsIterable responses = client.listSignalMapsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListSignalMapsIterable responses = client
     *             .listSignalMapsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListSignalMapsIterable responses = client.listSignalMapsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSignalMaps(software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSignalMapsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSignalMapsRequest#builder()}
     * </p>
     *
     * @param listSignalMapsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest.Builder} to create a request.
     *        Placeholder documentation for ListSignalMapsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListSignalMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSignalMapsIterable listSignalMapsPaginator(Consumer<ListSignalMapsRequest.Builder> listSignalMapsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        return listSignalMapsPaginator(ListSignalMapsRequest.builder().applyMutation(listSignalMapsRequest).build());
    }

    /**
     * Produces list of tags that have been created for a resource
     *
     * @param listTagsForResourceRequest
     *        Placeholder documentation for ListTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of tags that have been created for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListTagsForResourceRequest.Builder} to create a
     *        request. Placeholder documentation for ListTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * Retrieves an array of all the encoder engine versions that are available in this AWS account.
     *
     * @param listVersionsRequest
     *        Placeholder documentation for ListVersionsRequest
     * @return Result of the ListVersions operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Verify that the syntax is
     *         correct.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials that you sent.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The service could not complete your request.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service could not complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVersionsResponse listVersions(ListVersionsRequest listVersionsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves an array of all the encoder engine versions that are available in this AWS account.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVersionsRequest#builder()}
     * </p>
     *
     * @param listVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.ListVersionsRequest.Builder} to create a request.
     *        Placeholder documentation for ListVersionsRequest
     * @return Result of the ListVersions operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Verify that the syntax is
     *         correct.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials that you sent.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The service could not complete your request.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service could not complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVersionsResponse listVersions(Consumer<ListVersionsRequest.Builder> listVersionsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return listVersions(ListVersionsRequest.builder().applyMutation(listVersionsRequest).build());
    }

    /**
     * Purchase an offering and create a reservation.
     *
     * @param purchaseOfferingRequest
     *        Placeholder documentation for PurchaseOfferingRequest
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to purchase the offering
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Offering you're attempting to purchase does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on purchase offering request
     * @throws ConflictException
     *         Offering purchase prevented by service resource issue
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default PurchaseOfferingResponse purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Purchase an offering and create a reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link PurchaseOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest.Builder} to create a
     *        request. Placeholder documentation for PurchaseOfferingRequest
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to purchase the offering
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Offering you're attempting to purchase does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on purchase offering request
     * @throws ConflictException
     *         Offering purchase prevented by service resource issue
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default PurchaseOfferingResponse purchaseOffering(Consumer<PurchaseOfferingRequest.Builder> purchaseOfferingRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return purchaseOffering(PurchaseOfferingRequest.builder().applyMutation(purchaseOfferingRequest).build());
    }

    /**
     * Send a reboot command to the specified input device. The device will begin rebooting within a few seconds of
     * sending the command. When the reboot is complete, the device’s connection status will change to connected.
     *
     * @param rebootInputDeviceRequest
     *        A request to reboot an AWS Elemental device.
     * @return Result of the RebootInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Reboot operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to reboot input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on reboot device calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.RebootInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RebootInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default RebootInputDeviceResponse rebootInputDevice(RebootInputDeviceRequest rebootInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Send a reboot command to the specified input device. The device will begin rebooting within a few seconds of
     * sending the command. When the reboot is complete, the device’s connection status will change to connected.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootInputDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link RebootInputDeviceRequest#builder()}
     * </p>
     *
     * @param rebootInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.RebootInputDeviceRequest.Builder} to create a
     *        request. A request to reboot an AWS Elemental device.
     * @return Result of the RebootInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Reboot operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to reboot input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on reboot device calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.RebootInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RebootInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default RebootInputDeviceResponse rebootInputDevice(Consumer<RebootInputDeviceRequest.Builder> rebootInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return rebootInputDevice(RebootInputDeviceRequest.builder().applyMutation(rebootInputDeviceRequest).build());
    }

    /**
     * Reject the transfer of the specified input device to your AWS account.
     *
     * @param rejectInputDeviceTransferRequest
     *        Placeholder documentation for RejectInputDeviceTransferRequest
     * @return Result of the RejectInputDeviceTransfer operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to reject input device transfers.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device transfer could not be rejected.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.RejectInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RejectInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectInputDeviceTransferResponse rejectInputDeviceTransfer(
            RejectInputDeviceTransferRequest rejectInputDeviceTransferRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Reject the transfer of the specified input device to your AWS account.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectInputDeviceTransferRequest.Builder} avoiding
     * the need to create one manually via {@link RejectInputDeviceTransferRequest#builder()}
     * </p>
     *
     * @param rejectInputDeviceTransferRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferRequest.Builder} to create
     *        a request. Placeholder documentation for RejectInputDeviceTransferRequest
     * @return Result of the RejectInputDeviceTransfer operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to reject input device transfers.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device transfer could not be rejected.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.RejectInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RejectInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectInputDeviceTransferResponse rejectInputDeviceTransfer(
            Consumer<RejectInputDeviceTransferRequest.Builder> rejectInputDeviceTransferRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return rejectInputDeviceTransfer(RejectInputDeviceTransferRequest.builder()
                .applyMutation(rejectInputDeviceTransferRequest).build());
    }

    /**
     * Restart pipelines in one channel that is currently running.
     *
     * @param restartChannelPipelinesRequest
     *        Pipelines to restart.
     * @return Result of the RestartChannelPipelines operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Verify that the syntax is
     *         correct.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials that you sent.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel or pipeline you specified doesn't exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service could not complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.RestartChannelPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RestartChannelPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default RestartChannelPipelinesResponse restartChannelPipelines(RestartChannelPipelinesRequest restartChannelPipelinesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Restart pipelines in one channel that is currently running.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartChannelPipelinesRequest.Builder} avoiding
     * the need to create one manually via {@link RestartChannelPipelinesRequest#builder()}
     * </p>
     *
     * @param restartChannelPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesRequest.Builder} to create a
     *        request. Pipelines to restart.
     * @return Result of the RestartChannelPipelines operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Verify that the syntax is
     *         correct.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials that you sent.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel or pipeline you specified doesn't exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service could not complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.RestartChannelPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RestartChannelPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    default RestartChannelPipelinesResponse restartChannelPipelines(
            Consumer<RestartChannelPipelinesRequest.Builder> restartChannelPipelinesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return restartChannelPipelines(RestartChannelPipelinesRequest.builder().applyMutation(restartChannelPipelinesRequest)
                .build());
    }

    /**
     * Starts an existing channel
     *
     * @param startChannelRequest
     *        Placeholder documentation for StartChannelRequest
     * @return Result of the StartChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to start the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to start does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to start due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StartChannelResponse startChannel(StartChannelRequest startChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts an existing channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StartChannelRequest#builder()}
     * </p>
     *
     * @param startChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartChannelRequest.Builder} to create a request.
     *        Placeholder documentation for StartChannelRequest
     * @return Result of the StartChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to start the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to start does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to start due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StartChannelResponse startChannel(Consumer<StartChannelRequest.Builder> startChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return startChannel(StartChannelRequest.builder().applyMutation(startChannelRequest).build());
    }

    /**
     * Initiates a deployment to delete the monitor of the specified signal map.
     *
     * @param startDeleteMonitorDeploymentRequest
     *        Placeholder documentation for StartDeleteMonitorDeploymentRequest
     * @return Result of the StartDeleteMonitorDeployment operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartDeleteMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartDeleteMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDeleteMonitorDeploymentResponse startDeleteMonitorDeployment(
            StartDeleteMonitorDeploymentRequest startDeleteMonitorDeploymentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Initiates a deployment to delete the monitor of the specified signal map.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDeleteMonitorDeploymentRequest.Builder}
     * avoiding the need to create one manually via {@link StartDeleteMonitorDeploymentRequest#builder()}
     * </p>
     *
     * @param startDeleteMonitorDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentRequest.Builder} to
     *        create a request. Placeholder documentation for StartDeleteMonitorDeploymentRequest
     * @return Result of the StartDeleteMonitorDeployment operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartDeleteMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartDeleteMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDeleteMonitorDeploymentResponse startDeleteMonitorDeployment(
            Consumer<StartDeleteMonitorDeploymentRequest.Builder> startDeleteMonitorDeploymentRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return startDeleteMonitorDeployment(StartDeleteMonitorDeploymentRequest.builder()
                .applyMutation(startDeleteMonitorDeploymentRequest).build());
    }

    /**
     * Start an input device that is attached to a MediaConnect flow. (There is no need to start a device that is
     * attached to a MediaLive input; MediaLive starts the device when the channel starts.)
     *
     * @param startInputDeviceRequest
     *        Placeholder documentation for StartInputDeviceRequest
     * @return Result of the StartInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Start operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start device calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default StartInputDeviceResponse startInputDevice(StartInputDeviceRequest startInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Start an input device that is attached to a MediaConnect flow. (There is no need to start a device that is
     * attached to a MediaLive input; MediaLive starts the device when the channel starts.)<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInputDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link StartInputDeviceRequest#builder()}
     * </p>
     *
     * @param startInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartInputDeviceRequest.Builder} to create a
     *        request. Placeholder documentation for StartInputDeviceRequest
     * @return Result of the StartInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Start operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start device calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default StartInputDeviceResponse startInputDevice(Consumer<StartInputDeviceRequest.Builder> startInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return startInputDevice(StartInputDeviceRequest.builder().applyMutation(startInputDeviceRequest).build());
    }

    /**
     * Start a maintenance window for the specified input device. Starting a maintenance window will give the device up
     * to two hours to install software. If the device was streaming prior to the maintenance, it will resume streaming
     * when the software is fully installed. Devices automatically install updates while they are powered on and their
     * MediaLive channels are stopped. A maintenance window allows you to update a device without having to stop
     * MediaLive channels that use the device. The device must remain powered on and connected to the internet for the
     * duration of the maintenance.
     *
     * @param startInputDeviceMaintenanceWindowRequest
     *        Placeholder documentation for StartInputDeviceMaintenanceWindowRequest
     * @return Result of the StartInputDeviceMaintenanceWindow operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Start maintenance window operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start a maintenance window for this input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start maintenance window calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartInputDeviceMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDeviceMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default StartInputDeviceMaintenanceWindowResponse startInputDeviceMaintenanceWindow(
            StartInputDeviceMaintenanceWindowRequest startInputDeviceMaintenanceWindowRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Start a maintenance window for the specified input device. Starting a maintenance window will give the device up
     * to two hours to install software. If the device was streaming prior to the maintenance, it will resume streaming
     * when the software is fully installed. Devices automatically install updates while they are powered on and their
     * MediaLive channels are stopped. A maintenance window allows you to update a device without having to stop
     * MediaLive channels that use the device. The device must remain powered on and connected to the internet for the
     * duration of the maintenance.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartInputDeviceMaintenanceWindowRequest.Builder}
     * avoiding the need to create one manually via {@link StartInputDeviceMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param startInputDeviceMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowRequest.Builder}
     *        to create a request. Placeholder documentation for StartInputDeviceMaintenanceWindowRequest
     * @return Result of the StartInputDeviceMaintenanceWindow operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Start maintenance window operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start a maintenance window for this input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start maintenance window calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartInputDeviceMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDeviceMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default StartInputDeviceMaintenanceWindowResponse startInputDeviceMaintenanceWindow(
            Consumer<StartInputDeviceMaintenanceWindowRequest.Builder> startInputDeviceMaintenanceWindowRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return startInputDeviceMaintenanceWindow(StartInputDeviceMaintenanceWindowRequest.builder()
                .applyMutation(startInputDeviceMaintenanceWindowRequest).build());
    }

    /**
     * Initiates a deployment to deploy the latest monitor of the specified signal map.
     *
     * @param startMonitorDeploymentRequest
     *        Placeholder documentation for StartMonitorDeploymentRequest
     * @return Result of the StartMonitorDeployment operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMonitorDeploymentResponse startMonitorDeployment(StartMonitorDeploymentRequest startMonitorDeploymentRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Initiates a deployment to deploy the latest monitor of the specified signal map.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMonitorDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link StartMonitorDeploymentRequest#builder()}
     * </p>
     *
     * @param startMonitorDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentRequest.Builder} to create a
     *        request. Placeholder documentation for StartMonitorDeploymentRequest
     * @return Result of the StartMonitorDeployment operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMonitorDeploymentResponse startMonitorDeployment(
            Consumer<StartMonitorDeploymentRequest.Builder> startMonitorDeploymentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        return startMonitorDeployment(StartMonitorDeploymentRequest.builder().applyMutation(startMonitorDeploymentRequest)
                .build());
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each
     * channel.
     *
     * @param startMultiplexRequest
     *        Placeholder documentation for StartMultiplexRequest
     * @return Result of the StartMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to start the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to start doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to start due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default StartMultiplexResponse startMultiplex(StartMultiplexRequest startMultiplexRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each
     * channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMultiplexRequest.Builder} avoiding the need to
     * create one manually via {@link StartMultiplexRequest#builder()}
     * </p>
     *
     * @param startMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for StartMultiplexRequest
     * @return Result of the StartMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to start the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to start doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to start due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default StartMultiplexResponse startMultiplex(Consumer<StartMultiplexRequest.Builder> startMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return startMultiplex(StartMultiplexRequest.builder().applyMutation(startMultiplexRequest).build());
    }

    /**
     * Initiates an update for the specified signal map. Will discover a new signal map if a changed
     * discoveryEntryPointArn is provided.
     *
     * @param startUpdateSignalMapRequest
     *        Placeholder documentation for StartUpdateSignalMapRequest
     * @return Result of the StartUpdateSignalMap operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartUpdateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartUpdateSignalMap"
     *      target="_top">AWS API Documentation</a>
     */
    default StartUpdateSignalMapResponse startUpdateSignalMap(StartUpdateSignalMapRequest startUpdateSignalMapRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Initiates an update for the specified signal map. Will discover a new signal map if a changed
     * discoveryEntryPointArn is provided.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartUpdateSignalMapRequest.Builder} avoiding the
     * need to create one manually via {@link StartUpdateSignalMapRequest#builder()}
     * </p>
     *
     * @param startUpdateSignalMapRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapRequest.Builder} to create a
     *        request. Placeholder documentation for StartUpdateSignalMapRequest
     * @return Result of the StartUpdateSignalMap operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartUpdateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartUpdateSignalMap"
     *      target="_top">AWS API Documentation</a>
     */
    default StartUpdateSignalMapResponse startUpdateSignalMap(
            Consumer<StartUpdateSignalMapRequest.Builder> startUpdateSignalMapRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        return startUpdateSignalMap(StartUpdateSignalMapRequest.builder().applyMutation(startUpdateSignalMapRequest).build());
    }

    /**
     * Stops a running channel
     *
     * @param stopChannelRequest
     *        Placeholder documentation for StopChannelRequest
     * @return Result of the StopChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to stop the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to stop does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to stop due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StopChannelResponse stopChannel(StopChannelRequest stopChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops a running channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StopChannelRequest#builder()}
     * </p>
     *
     * @param stopChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StopChannelRequest.Builder} to create a request.
     *        Placeholder documentation for StopChannelRequest
     * @return Result of the StopChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to stop the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to stop does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to stop due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StopChannelResponse stopChannel(Consumer<StopChannelRequest.Builder> stopChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return stopChannel(StopChannelRequest.builder().applyMutation(stopChannelRequest).build());
    }

    /**
     * Stop an input device that is attached to a MediaConnect flow. (There is no need to stop a device that is attached
     * to a MediaLive input; MediaLive automatically stops the device when the channel stops.)
     *
     * @param stopInputDeviceRequest
     *        Placeholder documentation for StopInputDeviceRequest
     * @return Result of the StopInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Start operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to stop the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop device calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopInputDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default StopInputDeviceResponse stopInputDevice(StopInputDeviceRequest stopInputDeviceRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Stop an input device that is attached to a MediaConnect flow. (There is no need to stop a device that is attached
     * to a MediaLive input; MediaLive automatically stops the device when the channel stops.)<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopInputDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link StopInputDeviceRequest#builder()}
     * </p>
     *
     * @param stopInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StopInputDeviceRequest.Builder} to create a
     *        request. Placeholder documentation for StopInputDeviceRequest
     * @return Result of the StopInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Start operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to stop the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop device calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopInputDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default StopInputDeviceResponse stopInputDevice(Consumer<StopInputDeviceRequest.Builder> stopInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return stopInputDevice(StopInputDeviceRequest.builder().applyMutation(stopInputDeviceRequest).build());
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.
     *
     * @param stopMultiplexRequest
     *        Placeholder documentation for StopMultiplexRequest
     * @return Result of the StopMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to stop the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to stop doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to stop due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default StopMultiplexResponse stopMultiplex(StopMultiplexRequest stopMultiplexRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopMultiplexRequest.Builder} avoiding the need to
     * create one manually via {@link StopMultiplexRequest#builder()}
     * </p>
     *
     * @param stopMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.StopMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for StopMultiplexRequest
     * @return Result of the StopMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to stop the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to stop doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to stop due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default StopMultiplexResponse stopMultiplex(Consumer<StopMultiplexRequest.Builder> stopMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return stopMultiplex(StopMultiplexRequest.builder().applyMutation(stopMultiplexRequest).build());
    }

    /**
     * Start an input device transfer to another AWS account. After you make the request, the other account must accept
     * or reject the transfer.
     *
     * @param transferInputDeviceRequest
     *        A request to transfer an input device.
     * @return Result of the TransferInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to transfer input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device could not be transferred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.TransferInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TransferInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default TransferInputDeviceResponse transferInputDevice(TransferInputDeviceRequest transferInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Start an input device transfer to another AWS account. After you make the request, the other account must accept
     * or reject the transfer.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TransferInputDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link TransferInputDeviceRequest#builder()}
     * </p>
     *
     * @param transferInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest.Builder} to create a
     *        request. A request to transfer an input device.
     * @return Result of the TransferInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to transfer input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device could not be transferred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.TransferInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TransferInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default TransferInputDeviceResponse transferInputDevice(
            Consumer<TransferInputDeviceRequest.Builder> transferInputDeviceRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return transferInputDevice(TransferInputDeviceRequest.builder().applyMutation(transferInputDeviceRequest).build());
    }

    /**
     * Update account configuration
     *
     * @param updateAccountConfigurationRequest
     *        List of account configuration parameters to update.
     * @return Result of the UpdateAccountConfiguration operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The update account configuration request failed validation.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the account's configuration.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update account configuration calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountConfigurationResponse updateAccountConfiguration(
            UpdateAccountConfigurationRequest updateAccountConfigurationRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update account configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAccountConfigurationRequest#builder()}
     * </p>
     *
     * @param updateAccountConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationRequest.Builder} to
     *        create a request. List of account configuration parameters to update.
     * @return Result of the UpdateAccountConfiguration operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The update account configuration request failed validation.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the account's configuration.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update account configuration calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountConfigurationResponse updateAccountConfiguration(
            Consumer<UpdateAccountConfigurationRequest.Builder> updateAccountConfigurationRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return updateAccountConfiguration(UpdateAccountConfigurationRequest.builder()
                .applyMutation(updateAccountConfigurationRequest).build());
    }

    /**
     * Updates a channel.
     *
     * @param updateChannelRequest
     *        A request to update a channel.
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The channel configuration failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The channel is unable to update due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateChannelRequest.Builder} to create a request.
     *        A request to update a channel.
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The channel configuration failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The channel is unable to update due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateChannelResponse updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * Changes the class of the channel.
     *
     * @param updateChannelClassRequest
     *        Channel class that the channel should be updated to.
     * @return Result of the UpdateChannelClass operation returned by the service.
     * @throws BadRequestException
     *         This request to update the channel class was invalid.
     * @throws UnprocessableEntityException
     *         The channel configuration failed validation when attempting to update the channel class.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the class of this channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're trying to update the class on does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update channel class calls.
     * @throws ConflictException
     *         The channel class cannot be updated due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannelClass
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateChannelClassResponse updateChannelClass(UpdateChannelClassRequest updateChannelClassRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Changes the class of the channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelClassRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateChannelClassRequest#builder()}
     * </p>
     *
     * @param updateChannelClassRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest.Builder} to create a
     *        request. Channel class that the channel should be updated to.
     * @return Result of the UpdateChannelClass operation returned by the service.
     * @throws BadRequestException
     *         This request to update the channel class was invalid.
     * @throws UnprocessableEntityException
     *         The channel configuration failed validation when attempting to update the channel class.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the class of this channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're trying to update the class on does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update channel class calls.
     * @throws ConflictException
     *         The channel class cannot be updated due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannelClass
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateChannelClassResponse updateChannelClass(Consumer<UpdateChannelClassRequest.Builder> updateChannelClassRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        return updateChannelClass(UpdateChannelClassRequest.builder().applyMutation(updateChannelClassRequest).build());
    }

    /**
     * Change the settings for a ChannelPlacementGroup.
     *
     * @param updateChannelPlacementGroupRequest
     *        A request to update the channel placement group
     * @return Result of the UpdateChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws UnprocessableEntityException
     *         The channel placement group failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the channel placement group.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update channel placement group calls to service.
     * @throws ConflictException
     *         The channel placement group is unable to update due to an issue with channel placement group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChannelPlacementGroupResponse updateChannelPlacementGroup(
            UpdateChannelPlacementGroupRequest updateChannelPlacementGroupRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Change the settings for a ChannelPlacementGroup.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelPlacementGroupRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateChannelPlacementGroupRequest#builder()}
     * </p>
     *
     * @param updateChannelPlacementGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateChannelPlacementGroupRequest.Builder} to
     *        create a request. A request to update the channel placement group
     * @return Result of the UpdateChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws UnprocessableEntityException
     *         The channel placement group failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the channel placement group.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update channel placement group calls to service.
     * @throws ConflictException
     *         The channel placement group is unable to update due to an issue with channel placement group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChannelPlacementGroupResponse updateChannelPlacementGroup(
            Consumer<UpdateChannelPlacementGroupRequest.Builder> updateChannelPlacementGroupRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return updateChannelPlacementGroup(UpdateChannelPlacementGroupRequest.builder()
                .applyMutation(updateChannelPlacementGroupRequest).build());
    }

    /**
     * Updates the specified cloudwatch alarm template.
     *
     * @param updateCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for UpdateCloudWatchAlarmTemplateRequest
     * @return Result of the UpdateCloudWatchAlarmTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudWatchAlarmTemplateResponse updateCloudWatchAlarmTemplate(
            UpdateCloudWatchAlarmTemplateRequest updateCloudWatchAlarmTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the specified cloudwatch alarm template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCloudWatchAlarmTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCloudWatchAlarmTemplateRequest#builder()}
     * </p>
     *
     * @param updateCloudWatchAlarmTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for UpdateCloudWatchAlarmTemplateRequest
     * @return Result of the UpdateCloudWatchAlarmTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudWatchAlarmTemplateResponse updateCloudWatchAlarmTemplate(
            Consumer<UpdateCloudWatchAlarmTemplateRequest.Builder> updateCloudWatchAlarmTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return updateCloudWatchAlarmTemplate(UpdateCloudWatchAlarmTemplateRequest.builder()
                .applyMutation(updateCloudWatchAlarmTemplateRequest).build());
    }

    /**
     * Updates the specified cloudwatch alarm template group.
     *
     * @param updateCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for UpdateCloudWatchAlarmTemplateGroupRequest
     * @return Result of the UpdateCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudWatchAlarmTemplateGroupResponse updateCloudWatchAlarmTemplateGroup(
            UpdateCloudWatchAlarmTemplateGroupRequest updateCloudWatchAlarmTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the specified cloudwatch alarm template group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCloudWatchAlarmTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCloudWatchAlarmTemplateGroupRequest#builder()}
     * </p>
     *
     * @param updateCloudWatchAlarmTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for UpdateCloudWatchAlarmTemplateGroupRequest
     * @return Result of the UpdateCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudWatchAlarmTemplateGroupResponse updateCloudWatchAlarmTemplateGroup(
            Consumer<UpdateCloudWatchAlarmTemplateGroupRequest.Builder> updateCloudWatchAlarmTemplateGroupRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return updateCloudWatchAlarmTemplateGroup(UpdateCloudWatchAlarmTemplateGroupRequest.builder()
                .applyMutation(updateCloudWatchAlarmTemplateGroupRequest).build());
    }

    /**
     * Change the settings for a Cluster.
     *
     * @param updateClusterRequest
     *        A request to update the cluster.
     * @return Result of the UpdateCluster operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the Cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update Cluster calls to service.
     * @throws ConflictException
     *         The Cluster is unable to update due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Change the settings for a Cluster.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateClusterRequest#builder()}
     * </p>
     *
     * @param updateClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateClusterRequest.Builder} to create a request.
     *        A request to update the cluster.
     * @return Result of the UpdateCluster operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the Cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update Cluster calls to service.
     * @throws ConflictException
     *         The Cluster is unable to update due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClusterResponse updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return updateCluster(UpdateClusterRequest.builder().applyMutation(updateClusterRequest).build());
    }

    /**
     * Updates the specified eventbridge rule template.
     *
     * @param updateEventBridgeRuleTemplateRequest
     *        Placeholder documentation for UpdateEventBridgeRuleTemplateRequest
     * @return Result of the UpdateEventBridgeRuleTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventBridgeRuleTemplateResponse updateEventBridgeRuleTemplate(
            UpdateEventBridgeRuleTemplateRequest updateEventBridgeRuleTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the specified eventbridge rule template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventBridgeRuleTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEventBridgeRuleTemplateRequest#builder()}
     * </p>
     *
     * @param updateEventBridgeRuleTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateRequest.Builder} to
     *        create a request. Placeholder documentation for UpdateEventBridgeRuleTemplateRequest
     * @return Result of the UpdateEventBridgeRuleTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventBridgeRuleTemplateResponse updateEventBridgeRuleTemplate(
            Consumer<UpdateEventBridgeRuleTemplateRequest.Builder> updateEventBridgeRuleTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return updateEventBridgeRuleTemplate(UpdateEventBridgeRuleTemplateRequest.builder()
                .applyMutation(updateEventBridgeRuleTemplateRequest).build());
    }

    /**
     * Updates the specified eventbridge rule template group.
     *
     * @param updateEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for UpdateEventBridgeRuleTemplateGroupRequest
     * @return Result of the UpdateEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventBridgeRuleTemplateGroupResponse updateEventBridgeRuleTemplateGroup(
            UpdateEventBridgeRuleTemplateGroupRequest updateEventBridgeRuleTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the specified eventbridge rule template group.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventBridgeRuleTemplateGroupRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEventBridgeRuleTemplateGroupRequest#builder()}
     * </p>
     *
     * @param updateEventBridgeRuleTemplateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupRequest.Builder}
     *        to create a request. Placeholder documentation for UpdateEventBridgeRuleTemplateGroupRequest
     * @return Result of the UpdateEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventBridgeRuleTemplateGroupResponse updateEventBridgeRuleTemplateGroup(
            Consumer<UpdateEventBridgeRuleTemplateGroupRequest.Builder> updateEventBridgeRuleTemplateGroupRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return updateEventBridgeRuleTemplateGroup(UpdateEventBridgeRuleTemplateGroupRequest.builder()
                .applyMutation(updateEventBridgeRuleTemplateGroupRequest).build());
    }

    /**
     * Updates an input.
     *
     * @param updateInputRequest
     *        A request to update an input.
     * @return Result of the UpdateInput operation returned by the service.
     * @throws BadRequestException
     *         This request to update the input was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         The requester does not have permission to update an input.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The input was not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The input was unable to be updated at this time due to an issue with input resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateInputResponse updateInput(UpdateInputRequest updateInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates an input.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInputRequest#builder()}
     * </p>
     *
     * @param updateInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateInputRequest.Builder} to create a request. A
     *        request to update an input.
     * @return Result of the UpdateInput operation returned by the service.
     * @throws BadRequestException
     *         This request to update the input was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         The requester does not have permission to update an input.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The input was not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The input was unable to be updated at this time due to an issue with input resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateInputResponse updateInput(Consumer<UpdateInputRequest.Builder> updateInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return updateInput(UpdateInputRequest.builder().applyMutation(updateInputRequest).build());
    }

    /**
     * Updates the parameters for the input device.
     *
     * @param updateInputDeviceRequest
     *        A request to update an input device.
     * @return Result of the UpdateInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Input device failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         The input device you're requesting to does not exist. Check the ID.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateInputDeviceResponse updateInputDevice(UpdateInputDeviceRequest updateInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the parameters for the input device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateInputDeviceRequest#builder()}
     * </p>
     *
     * @param updateInputDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest.Builder} to create a
     *        request. A request to update an input device.
     * @return Result of the UpdateInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Input device failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         The input device you're requesting to does not exist. Check the ID.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateInputDeviceResponse updateInputDevice(Consumer<UpdateInputDeviceRequest.Builder> updateInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return updateInputDevice(UpdateInputDeviceRequest.builder().applyMutation(updateInputDeviceRequest).build());
    }

    /**
     * Update an Input Security Group's Whilelists.
     *
     * @param updateInputSecurityGroupRequest
     *        The request to update some combination of the Input Security Group name and the IPv4 CIDRs the Input
     *        Security Group should allow.
     * @return Result of the UpdateInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to update the Input Security Group was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to update an Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The Input Security Group was not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The Input Security Group was unable to be updated due to an issue with input security group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInputSecurityGroupResponse updateInputSecurityGroup(
            UpdateInputSecurityGroupRequest updateInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an Input Security Group's Whilelists.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param updateInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest.Builder} to create
     *        a request. The request to update some combination of the Input Security Group name and the IPv4 CIDRs the
     *        Input Security Group should allow.
     * @return Result of the UpdateInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to update the Input Security Group was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to update an Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The Input Security Group was not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The Input Security Group was unable to be updated due to an issue with input security group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInputSecurityGroupResponse updateInputSecurityGroup(
            Consumer<UpdateInputSecurityGroupRequest.Builder> updateInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return updateInputSecurityGroup(UpdateInputSecurityGroupRequest.builder().applyMutation(updateInputSecurityGroupRequest)
                .build());
    }

    /**
     * Updates a multiplex.
     *
     * @param updateMultiplexRequest
     *        A request to update a multiplex.
     * @return Result of the UpdateMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The multiplex configuration failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to update the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to update doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The multiplex is unable to update due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMultiplexResponse updateMultiplex(UpdateMultiplexRequest updateMultiplexRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMultiplexRequest#builder()}
     * </p>
     *
     * @param updateMultiplexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest.Builder} to create a
     *        request. A request to update a multiplex.
     * @return Result of the UpdateMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The multiplex configuration failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to update the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to update doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The multiplex is unable to update due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMultiplexResponse updateMultiplex(Consumer<UpdateMultiplexRequest.Builder> updateMultiplexRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return updateMultiplex(UpdateMultiplexRequest.builder().applyMutation(updateMultiplexRequest).build());
    }

    /**
     * Update a program in a multiplex.
     *
     * @param updateMultiplexProgramRequest
     *        A request to update a program in a multiplex.
     * @return Result of the UpdateMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The multiplex program failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to update the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't update the program. The multiplex or the program that you specified doesn’t exist. Check
     *         the IDs and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The multiplex program is unable to update due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMultiplexProgramResponse updateMultiplexProgram(UpdateMultiplexProgramRequest updateMultiplexProgramRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a program in a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param updateMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest.Builder} to create a
     *        request. A request to update a program in a multiplex.
     * @return Result of the UpdateMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The multiplex program failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to update the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't update the program. The multiplex or the program that you specified doesn’t exist. Check
     *         the IDs and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The multiplex program is unable to update due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMultiplexProgramResponse updateMultiplexProgram(
            Consumer<UpdateMultiplexProgramRequest.Builder> updateMultiplexProgramRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return updateMultiplexProgram(UpdateMultiplexProgramRequest.builder().applyMutation(updateMultiplexProgramRequest)
                .build());
    }

    /**
     * Change the settings for a Network.
     *
     * @param updateNetworkRequest
     *        A request to update the network.
     * @return Result of the UpdateNetwork operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the Network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update Network calls to service.
     * @throws ConflictException
     *         The Network is unable to update due to an issue with network resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateNetworkResponse updateNetwork(UpdateNetworkRequest updateNetworkRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Change the settings for a Network.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateNetworkRequest#builder()}
     * </p>
     *
     * @param updateNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateNetworkRequest.Builder} to create a request.
     *        A request to update the network.
     * @return Result of the UpdateNetwork operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the Network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update Network calls to service.
     * @throws ConflictException
     *         The Network is unable to update due to an issue with network resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateNetworkResponse updateNetwork(Consumer<UpdateNetworkRequest.Builder> updateNetworkRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return updateNetwork(UpdateNetworkRequest.builder().applyMutation(updateNetworkRequest).build());
    }

    /**
     * Change the settings for a Node.
     *
     * @param updateNodeRequest
     *        A request to update the node.
     * @return Result of the UpdateNode operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update node calls to the service.
     * @throws ConflictException
     *         The node is unable to update due to an issue with node resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNode" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateNodeResponse updateNode(UpdateNodeRequest updateNodeRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Change the settings for a Node.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNodeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateNodeRequest#builder()}
     * </p>
     *
     * @param updateNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateNodeRequest.Builder} to create a request. A
     *        request to update the node.
     * @return Result of the UpdateNode operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update node calls to the service.
     * @throws ConflictException
     *         The node is unable to update due to an issue with node resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNode" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateNodeResponse updateNode(Consumer<UpdateNodeRequest.Builder> updateNodeRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return updateNode(UpdateNodeRequest.builder().applyMutation(updateNodeRequest).build());
    }

    /**
     * Update the state of a node.
     *
     * @param updateNodeStateRequest
     *        A request to update the state of a node.
     * @return Result of the UpdateNodeState operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The node failed validation and the state could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the state of the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on node calls to service.
     * @throws ConflictException
     *         The node state is unable to updated due to an issue with node resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateNodeState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNodeState" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateNodeStateResponse updateNodeState(UpdateNodeStateRequest updateNodeStateRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update the state of a node.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNodeStateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateNodeStateRequest#builder()}
     * </p>
     *
     * @param updateNodeStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateNodeStateRequest.Builder} to create a
     *        request. A request to update the state of a node.
     * @return Result of the UpdateNodeState operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The node failed validation and the state could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the state of the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on node calls to service.
     * @throws ConflictException
     *         The node state is unable to updated due to an issue with node resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateNodeState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNodeState" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateNodeStateResponse updateNodeState(Consumer<UpdateNodeStateRequest.Builder> updateNodeStateRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return updateNodeState(UpdateNodeStateRequest.builder().applyMutation(updateNodeStateRequest).build());
    }

    /**
     * Update reservation.
     *
     * @param updateReservationRequest
     *        Request to update a reservation
     * @return Result of the UpdateReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to update reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded
     * @throws ConflictException
     *         The reservation could not be updated
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateReservationResponse updateReservation(UpdateReservationRequest updateReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReservationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateReservationRequest#builder()}
     * </p>
     *
     * @param updateReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.medialive.model.UpdateReservationRequest.Builder} to create a
     *        request. Request to update a reservation
     * @return Result of the UpdateReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to update reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded
     * @throws ConflictException
     *         The reservation could not be updated
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateReservationResponse updateReservation(Consumer<UpdateReservationRequest.Builder> updateReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return updateReservation(UpdateReservationRequest.builder().applyMutation(updateReservationRequest).build());
    }

    /**
     * Create an instance of {@link MediaLiveWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link MediaLiveWaiter}
     */
    default MediaLiveWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MediaLiveClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaLiveClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaLiveClient}.
     */
    static MediaLiveClientBuilder builder() {
        return new DefaultMediaLiveClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MediaLiveServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
