/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Archive Container Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveContainerSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ArchiveContainerSettings.Builder, ArchiveContainerSettings> {
    private static final SdkField<M2tsSettings> M2_TS_SETTINGS_FIELD = SdkField.<M2tsSettings> builder(MarshallingType.SDK_POJO)
            .memberName("M2tsSettings").getter(getter(ArchiveContainerSettings::m2tsSettings))
            .setter(setter(Builder::m2tsSettings)).constructor(M2tsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2tsSettings").build()).build();

    private static final SdkField<RawSettings> RAW_SETTINGS_FIELD = SdkField.<RawSettings> builder(MarshallingType.SDK_POJO)
            .memberName("RawSettings").getter(getter(ArchiveContainerSettings::rawSettings)).setter(setter(Builder::rawSettings))
            .constructor(RawSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(M2_TS_SETTINGS_FIELD,
            RAW_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final M2tsSettings m2tsSettings;

    private final RawSettings rawSettings;

    private ArchiveContainerSettings(BuilderImpl builder) {
        this.m2tsSettings = builder.m2tsSettings;
        this.rawSettings = builder.rawSettings;
    }

    /**
     * Returns the value of the M2tsSettings property for this object.
     * 
     * @return The value of the M2tsSettings property for this object.
     */
    public final M2tsSettings m2tsSettings() {
        return m2tsSettings;
    }

    /**
     * Returns the value of the RawSettings property for this object.
     * 
     * @return The value of the RawSettings property for this object.
     */
    public final RawSettings rawSettings() {
        return rawSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(m2tsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(rawSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveContainerSettings)) {
            return false;
        }
        ArchiveContainerSettings other = (ArchiveContainerSettings) obj;
        return Objects.equals(m2tsSettings(), other.m2tsSettings()) && Objects.equals(rawSettings(), other.rawSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveContainerSettings").add("M2tsSettings", m2tsSettings()).add("RawSettings", rawSettings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "M2tsSettings":
            return Optional.ofNullable(clazz.cast(m2tsSettings()));
        case "RawSettings":
            return Optional.ofNullable(clazz.cast(rawSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("m2tsSettings", M2_TS_SETTINGS_FIELD);
        map.put("rawSettings", RAW_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArchiveContainerSettings, T> g) {
        return obj -> g.apply((ArchiveContainerSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveContainerSettings> {
        /**
         * Sets the value of the M2tsSettings property for this object.
         *
         * @param m2tsSettings
         *        The new value for the M2tsSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m2tsSettings(M2tsSettings m2tsSettings);

        /**
         * Sets the value of the M2tsSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link M2tsSettings.Builder} avoiding the need
         * to create one manually via {@link M2tsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2tsSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #m2tsSettings(M2tsSettings)}.
         * 
         * @param m2tsSettings
         *        a consumer that will call methods on {@link M2tsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m2tsSettings(M2tsSettings)
         */
        default Builder m2tsSettings(Consumer<M2tsSettings.Builder> m2tsSettings) {
            return m2tsSettings(M2tsSettings.builder().applyMutation(m2tsSettings).build());
        }

        /**
         * Sets the value of the RawSettings property for this object.
         *
         * @param rawSettings
         *        The new value for the RawSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawSettings(RawSettings rawSettings);

        /**
         * Sets the value of the RawSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RawSettings.Builder} avoiding the need to
         * create one manually via {@link RawSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RawSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #rawSettings(RawSettings)}.
         * 
         * @param rawSettings
         *        a consumer that will call methods on {@link RawSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rawSettings(RawSettings)
         */
        default Builder rawSettings(Consumer<RawSettings.Builder> rawSettings) {
            return rawSettings(RawSettings.builder().applyMutation(rawSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private M2tsSettings m2tsSettings;

        private RawSettings rawSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveContainerSettings model) {
            m2tsSettings(model.m2tsSettings);
            rawSettings(model.rawSettings);
        }

        public final M2tsSettings.Builder getM2tsSettings() {
            return m2tsSettings != null ? m2tsSettings.toBuilder() : null;
        }

        public final void setM2tsSettings(M2tsSettings.BuilderImpl m2tsSettings) {
            this.m2tsSettings = m2tsSettings != null ? m2tsSettings.build() : null;
        }

        @Override
        public final Builder m2tsSettings(M2tsSettings m2tsSettings) {
            this.m2tsSettings = m2tsSettings;
            return this;
        }

        public final RawSettings.Builder getRawSettings() {
            return rawSettings != null ? rawSettings.toBuilder() : null;
        }

        public final void setRawSettings(RawSettings.BuilderImpl rawSettings) {
            this.rawSettings = rawSettings != null ? rawSettings.build() : null;
        }

        @Override
        public final Builder rawSettings(RawSettings rawSettings) {
            this.rawSettings = rawSettings;
            return this;
        }

        @Override
        public ArchiveContainerSettings build() {
            return new ArchiveContainerSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
