/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Archive Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ArchiveGroupSettings.Builder, ArchiveGroupSettings> {
    private static final SdkField<ArchiveCdnSettings> ARCHIVE_CDN_SETTINGS_FIELD = SdkField
            .<ArchiveCdnSettings> builder(MarshallingType.SDK_POJO).memberName("ArchiveCdnSettings")
            .getter(getter(ArchiveGroupSettings::archiveCdnSettings)).setter(setter(Builder::archiveCdnSettings))
            .constructor(ArchiveCdnSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveCdnSettings").build())
            .build();

    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField
            .<OutputLocationRef> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(ArchiveGroupSettings::destination)).setter(setter(Builder::destination))
            .constructor(OutputLocationRef::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<Integer> ROLLOVER_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RolloverInterval").getter(getter(ArchiveGroupSettings::rolloverInterval))
            .setter(setter(Builder::rolloverInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rolloverInterval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_CDN_SETTINGS_FIELD,
            DESTINATION_FIELD, ROLLOVER_INTERVAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ArchiveCdnSettings archiveCdnSettings;

    private final OutputLocationRef destination;

    private final Integer rolloverInterval;

    private ArchiveGroupSettings(BuilderImpl builder) {
        this.archiveCdnSettings = builder.archiveCdnSettings;
        this.destination = builder.destination;
        this.rolloverInterval = builder.rolloverInterval;
    }

    /**
     * Parameters that control interactions with the CDN.
     * 
     * @return Parameters that control interactions with the CDN.
     */
    public final ArchiveCdnSettings archiveCdnSettings() {
        return archiveCdnSettings;
    }

    /**
     * A directory and base filename where archive files should be written.
     * 
     * @return A directory and base filename where archive files should be written.
     */
    public final OutputLocationRef destination() {
        return destination;
    }

    /**
     * Number of seconds to write to archive file before closing and starting a new one.
     * 
     * @return Number of seconds to write to archive file before closing and starting a new one.
     */
    public final Integer rolloverInterval() {
        return rolloverInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(archiveCdnSettings());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(rolloverInterval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveGroupSettings)) {
            return false;
        }
        ArchiveGroupSettings other = (ArchiveGroupSettings) obj;
        return Objects.equals(archiveCdnSettings(), other.archiveCdnSettings())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(rolloverInterval(), other.rolloverInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveGroupSettings").add("ArchiveCdnSettings", archiveCdnSettings())
                .add("Destination", destination()).add("RolloverInterval", rolloverInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveCdnSettings":
            return Optional.ofNullable(clazz.cast(archiveCdnSettings()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "RolloverInterval":
            return Optional.ofNullable(clazz.cast(rolloverInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("archiveCdnSettings", ARCHIVE_CDN_SETTINGS_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("rolloverInterval", ROLLOVER_INTERVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArchiveGroupSettings, T> g) {
        return obj -> g.apply((ArchiveGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveGroupSettings> {
        /**
         * Parameters that control interactions with the CDN.
         * 
         * @param archiveCdnSettings
         *        Parameters that control interactions with the CDN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveCdnSettings(ArchiveCdnSettings archiveCdnSettings);

        /**
         * Parameters that control interactions with the CDN. This is a convenience method that creates an instance of
         * the {@link ArchiveCdnSettings.Builder} avoiding the need to create one manually via
         * {@link ArchiveCdnSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveCdnSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #archiveCdnSettings(ArchiveCdnSettings)}.
         * 
         * @param archiveCdnSettings
         *        a consumer that will call methods on {@link ArchiveCdnSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archiveCdnSettings(ArchiveCdnSettings)
         */
        default Builder archiveCdnSettings(Consumer<ArchiveCdnSettings.Builder> archiveCdnSettings) {
            return archiveCdnSettings(ArchiveCdnSettings.builder().applyMutation(archiveCdnSettings).build());
        }

        /**
         * A directory and base filename where archive files should be written.
         * 
         * @param destination
         *        A directory and base filename where archive files should be written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(OutputLocationRef destination);

        /**
         * A directory and base filename where archive files should be written. This is a convenience method that
         * creates an instance of the {@link OutputLocationRef.Builder} avoiding the need to create one manually via
         * {@link OutputLocationRef#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputLocationRef.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(OutputLocationRef)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link OutputLocationRef.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(OutputLocationRef)
         */
        default Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return destination(OutputLocationRef.builder().applyMutation(destination).build());
        }

        /**
         * Number of seconds to write to archive file before closing and starting a new one.
         * 
         * @param rolloverInterval
         *        Number of seconds to write to archive file before closing and starting a new one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rolloverInterval(Integer rolloverInterval);
    }

    static final class BuilderImpl implements Builder {
        private ArchiveCdnSettings archiveCdnSettings;

        private OutputLocationRef destination;

        private Integer rolloverInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveGroupSettings model) {
            archiveCdnSettings(model.archiveCdnSettings);
            destination(model.destination);
            rolloverInterval(model.rolloverInterval);
        }

        public final ArchiveCdnSettings.Builder getArchiveCdnSettings() {
            return archiveCdnSettings != null ? archiveCdnSettings.toBuilder() : null;
        }

        public final void setArchiveCdnSettings(ArchiveCdnSettings.BuilderImpl archiveCdnSettings) {
            this.archiveCdnSettings = archiveCdnSettings != null ? archiveCdnSettings.build() : null;
        }

        @Override
        public final Builder archiveCdnSettings(ArchiveCdnSettings archiveCdnSettings) {
            this.archiveCdnSettings = archiveCdnSettings;
            return this;
        }

        public final OutputLocationRef.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final Integer getRolloverInterval() {
            return rolloverInterval;
        }

        public final void setRolloverInterval(Integer rolloverInterval) {
            this.rolloverInterval = rolloverInterval;
        }

        @Override
        public final Builder rolloverInterval(Integer rolloverInterval) {
            this.rolloverInterval = rolloverInterval;
            return this;
        }

        @Override
        public ArchiveGroupSettings build() {
            return new ArchiveGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
