/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Avail Blanking
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailBlanking implements SdkPojo, Serializable, ToCopyableBuilder<AvailBlanking.Builder, AvailBlanking> {
    private static final SdkField<InputLocation> AVAIL_BLANKING_IMAGE_FIELD = SdkField
            .<InputLocation> builder(MarshallingType.SDK_POJO).memberName("AvailBlankingImage")
            .getter(getter(AvailBlanking::availBlankingImage)).setter(setter(Builder::availBlankingImage))
            .constructor(InputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availBlankingImage").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(AvailBlanking::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAIL_BLANKING_IMAGE_FIELD,
            STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InputLocation availBlankingImage;

    private final String state;

    private AvailBlanking(BuilderImpl builder) {
        this.availBlankingImage = builder.availBlankingImage;
        this.state = builder.state;
    }

    /**
     * Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported.
     * 
     * @return Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported.
     */
    public final InputLocation availBlankingImage() {
        return availBlankingImage;
    }

    /**
     * When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AvailBlankingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
     * @see AvailBlankingState
     */
    public final AvailBlankingState state() {
        return AvailBlankingState.fromValue(state);
    }

    /**
     * When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AvailBlankingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
     * @see AvailBlankingState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availBlankingImage());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailBlanking)) {
            return false;
        }
        AvailBlanking other = (AvailBlanking) obj;
        return Objects.equals(availBlankingImage(), other.availBlankingImage())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailBlanking").add("AvailBlankingImage", availBlankingImage()).add("State", stateAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailBlankingImage":
            return Optional.ofNullable(clazz.cast(availBlankingImage()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("availBlankingImage", AVAIL_BLANKING_IMAGE_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailBlanking, T> g) {
        return obj -> g.apply((AvailBlanking) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailBlanking> {
        /**
         * Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported.
         * 
         * @param availBlankingImage
         *        Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availBlankingImage(InputLocation availBlankingImage);

        /**
         * Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported. This is a
         * convenience method that creates an instance of the {@link InputLocation.Builder} avoiding the need to create
         * one manually via {@link InputLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #availBlankingImage(InputLocation)}.
         * 
         * @param availBlankingImage
         *        a consumer that will call methods on {@link InputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availBlankingImage(InputLocation)
         */
        default Builder availBlankingImage(Consumer<InputLocation.Builder> availBlankingImage) {
            return availBlankingImage(InputLocation.builder().applyMutation(availBlankingImage).build());
        }

        /**
         * When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
         * 
         * @param state
         *        When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
         * @see AvailBlankingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailBlankingState
         */
        Builder state(String state);

        /**
         * When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
         * 
         * @param state
         *        When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
         * @see AvailBlankingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailBlankingState
         */
        Builder state(AvailBlankingState state);
    }

    static final class BuilderImpl implements Builder {
        private InputLocation availBlankingImage;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailBlanking model) {
            availBlankingImage(model.availBlankingImage);
            state(model.state);
        }

        public final InputLocation.Builder getAvailBlankingImage() {
            return availBlankingImage != null ? availBlankingImage.toBuilder() : null;
        }

        public final void setAvailBlankingImage(InputLocation.BuilderImpl availBlankingImage) {
            this.availBlankingImage = availBlankingImage != null ? availBlankingImage.build() : null;
        }

        @Override
        public final Builder availBlankingImage(InputLocation availBlankingImage) {
            this.availBlankingImage = availBlankingImage;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AvailBlankingState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public AvailBlanking build() {
            return new AvailBlanking(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
