/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to start resources
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStartRequest extends MediaLiveRequest implements
        ToCopyableBuilder<BatchStartRequest.Builder, BatchStartRequest> {
    private static final SdkField<List<String>> CHANNEL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ChannelIds")
            .getter(getter(BatchStartRequest::channelIds))
            .setter(setter(Builder::channelIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MULTIPLEX_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MultiplexIds")
            .getter(getter(BatchStartRequest::multiplexIds))
            .setter(setter(Builder::multiplexIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_IDS_FIELD,
            MULTIPLEX_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> channelIds;

    private final List<String> multiplexIds;

    private BatchStartRequest(BuilderImpl builder) {
        super(builder);
        this.channelIds = builder.channelIds;
        this.multiplexIds = builder.multiplexIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannelIds() {
        return channelIds != null && !(channelIds instanceof SdkAutoConstructList);
    }

    /**
     * List of channel IDs
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelIds} method.
     * </p>
     * 
     * @return List of channel IDs
     */
    public final List<String> channelIds() {
        return channelIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the MultiplexIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMultiplexIds() {
        return multiplexIds != null && !(multiplexIds instanceof SdkAutoConstructList);
    }

    /**
     * List of multiplex IDs
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMultiplexIds} method.
     * </p>
     * 
     * @return List of multiplex IDs
     */
    public final List<String> multiplexIds() {
        return multiplexIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelIds() ? channelIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMultiplexIds() ? multiplexIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStartRequest)) {
            return false;
        }
        BatchStartRequest other = (BatchStartRequest) obj;
        return hasChannelIds() == other.hasChannelIds() && Objects.equals(channelIds(), other.channelIds())
                && hasMultiplexIds() == other.hasMultiplexIds() && Objects.equals(multiplexIds(), other.multiplexIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchStartRequest").add("ChannelIds", hasChannelIds() ? channelIds() : null)
                .add("MultiplexIds", hasMultiplexIds() ? multiplexIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelIds":
            return Optional.ofNullable(clazz.cast(channelIds()));
        case "MultiplexIds":
            return Optional.ofNullable(clazz.cast(multiplexIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelIds", CHANNEL_IDS_FIELD);
        map.put("multiplexIds", MULTIPLEX_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchStartRequest, T> g) {
        return obj -> g.apply((BatchStartRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchStartRequest> {
        /**
         * List of channel IDs
         * 
         * @param channelIds
         *        List of channel IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIds(Collection<String> channelIds);

        /**
         * List of channel IDs
         * 
         * @param channelIds
         *        List of channel IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIds(String... channelIds);

        /**
         * List of multiplex IDs
         * 
         * @param multiplexIds
         *        List of multiplex IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexIds(Collection<String> multiplexIds);

        /**
         * List of multiplex IDs
         * 
         * @param multiplexIds
         *        List of multiplex IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexIds(String... multiplexIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private List<String> channelIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> multiplexIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStartRequest model) {
            super(model);
            channelIds(model.channelIds);
            multiplexIds(model.multiplexIds);
        }

        public final Collection<String> getChannelIds() {
            if (channelIds instanceof SdkAutoConstructList) {
                return null;
            }
            return channelIds;
        }

        public final void setChannelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
        }

        @Override
        public final Builder channelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelIds(String... channelIds) {
            channelIds(Arrays.asList(channelIds));
            return this;
        }

        public final Collection<String> getMultiplexIds() {
            if (multiplexIds instanceof SdkAutoConstructList) {
                return null;
            }
            return multiplexIds;
        }

        public final void setMultiplexIds(Collection<String> multiplexIds) {
            this.multiplexIds = ___listOf__stringCopier.copy(multiplexIds);
        }

        @Override
        public final Builder multiplexIds(Collection<String> multiplexIds) {
            this.multiplexIds = ___listOf__stringCopier.copy(multiplexIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexIds(String... multiplexIds) {
            multiplexIds(Arrays.asList(multiplexIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchStartRequest build() {
            return new BatchStartRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
