/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Cmaf Ingest Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class CmafIngestGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CmafIngestGroupSettings.Builder, CmafIngestGroupSettings> {
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField
            .<OutputLocationRef> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(CmafIngestGroupSettings::destination)).setter(setter(Builder::destination))
            .constructor(OutputLocationRef::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> NIELSEN_ID3_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NielsenId3Behavior").getter(getter(CmafIngestGroupSettings::nielsenId3BehaviorAsString))
            .setter(setter(Builder::nielsenId3Behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3Behavior").build())
            .build();

    private static final SdkField<String> SCTE35_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35Type").getter(getter(CmafIngestGroupSettings::scte35TypeAsString))
            .setter(setter(Builder::scte35Type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Type").build()).build();

    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentLength").getter(getter(CmafIngestGroupSettings::segmentLength))
            .setter(setter(Builder::segmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()).build();

    private static final SdkField<String> SEGMENT_LENGTH_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentLengthUnits").getter(getter(CmafIngestGroupSettings::segmentLengthUnitsAsString))
            .setter(setter(Builder::segmentLengthUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLengthUnits").build())
            .build();

    private static final SdkField<Integer> SEND_DELAY_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SendDelayMs").getter(getter(CmafIngestGroupSettings::sendDelayMs)).setter(setter(Builder::sendDelayMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sendDelayMs").build()).build();

    private static final SdkField<String> KLV_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KlvBehavior").getter(getter(CmafIngestGroupSettings::klvBehaviorAsString))
            .setter(setter(Builder::klvBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("klvBehavior").build()).build();

    private static final SdkField<String> KLV_NAME_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KlvNameModifier").getter(getter(CmafIngestGroupSettings::klvNameModifier))
            .setter(setter(Builder::klvNameModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("klvNameModifier").build()).build();

    private static final SdkField<String> NIELSEN_ID3_NAME_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NielsenId3NameModifier").getter(getter(CmafIngestGroupSettings::nielsenId3NameModifier))
            .setter(setter(Builder::nielsenId3NameModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3NameModifier").build())
            .build();

    private static final SdkField<String> SCTE35_NAME_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35NameModifier").getter(getter(CmafIngestGroupSettings::scte35NameModifier))
            .setter(setter(Builder::scte35NameModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35NameModifier").build())
            .build();

    private static final SdkField<String> ID3_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Id3Behavior").getter(getter(CmafIngestGroupSettings::id3BehaviorAsString))
            .setter(setter(Builder::id3Behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id3Behavior").build()).build();

    private static final SdkField<String> ID3_NAME_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Id3NameModifier").getter(getter(CmafIngestGroupSettings::id3NameModifier))
            .setter(setter(Builder::id3NameModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id3NameModifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            NIELSEN_ID3_BEHAVIOR_FIELD, SCTE35_TYPE_FIELD, SEGMENT_LENGTH_FIELD, SEGMENT_LENGTH_UNITS_FIELD, SEND_DELAY_MS_FIELD,
            KLV_BEHAVIOR_FIELD, KLV_NAME_MODIFIER_FIELD, NIELSEN_ID3_NAME_MODIFIER_FIELD, SCTE35_NAME_MODIFIER_FIELD,
            ID3_BEHAVIOR_FIELD, ID3_NAME_MODIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OutputLocationRef destination;

    private final String nielsenId3Behavior;

    private final String scte35Type;

    private final Integer segmentLength;

    private final String segmentLengthUnits;

    private final Integer sendDelayMs;

    private final String klvBehavior;

    private final String klvNameModifier;

    private final String nielsenId3NameModifier;

    private final String scte35NameModifier;

    private final String id3Behavior;

    private final String id3NameModifier;

    private CmafIngestGroupSettings(BuilderImpl builder) {
        this.destination = builder.destination;
        this.nielsenId3Behavior = builder.nielsenId3Behavior;
        this.scte35Type = builder.scte35Type;
        this.segmentLength = builder.segmentLength;
        this.segmentLengthUnits = builder.segmentLengthUnits;
        this.sendDelayMs = builder.sendDelayMs;
        this.klvBehavior = builder.klvBehavior;
        this.klvNameModifier = builder.klvNameModifier;
        this.nielsenId3NameModifier = builder.nielsenId3NameModifier;
        this.scte35NameModifier = builder.scte35NameModifier;
        this.id3Behavior = builder.id3Behavior;
        this.id3NameModifier = builder.id3NameModifier;
    }

    /**
     * A HTTP destination for the tracks
     * 
     * @return A HTTP destination for the tracks
     */
    public final OutputLocationRef destination() {
        return destination;
    }

    /**
     * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
     * equivalent ID3 tag will be inserted in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenId3Behavior} will return {@link CmafNielsenId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nielsenId3BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and
     *         an equivalent ID3 tag will be inserted in the output.
     * @see CmafNielsenId3Behavior
     */
    public final CmafNielsenId3Behavior nielsenId3Behavior() {
        return CmafNielsenId3Behavior.fromValue(nielsenId3Behavior);
    }

    /**
     * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
     * equivalent ID3 tag will be inserted in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenId3Behavior} will return {@link CmafNielsenId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nielsenId3BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and
     *         an equivalent ID3 tag will be inserted in the output.
     * @see CmafNielsenId3Behavior
     */
    public final String nielsenId3BehaviorAsString() {
        return nielsenId3Behavior;
    }

    /**
     * Type of scte35 track to add. none or scte35WithoutSegmentation
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Type} will
     * return {@link Scte35Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35TypeAsString}.
     * </p>
     * 
     * @return Type of scte35 track to add. none or scte35WithoutSegmentation
     * @see Scte35Type
     */
    public final Scte35Type scte35Type() {
        return Scte35Type.fromValue(scte35Type);
    }

    /**
     * Type of scte35 track to add. none or scte35WithoutSegmentation
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Type} will
     * return {@link Scte35Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35TypeAsString}.
     * </p>
     * 
     * @return Type of scte35 track to add. none or scte35WithoutSegmentation
     * @see Scte35Type
     */
    public final String scte35TypeAsString() {
        return scte35Type;
    }

    /**
     * The nominal duration of segments. The units are specified in SegmentLengthUnits. The segments will end on the
     * next keyframe after the specified duration, so the actual segment length might be longer, and it might be a
     * fraction of the units.
     * 
     * @return The nominal duration of segments. The units are specified in SegmentLengthUnits. The segments will end on
     *         the next keyframe after the specified duration, so the actual segment length might be longer, and it
     *         might be a fraction of the units.
     */
    public final Integer segmentLength() {
        return segmentLength;
    }

    /**
     * Time unit for segment length parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentLengthUnits} will return {@link CmafIngestSegmentLengthUnits#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #segmentLengthUnitsAsString}.
     * </p>
     * 
     * @return Time unit for segment length parameter.
     * @see CmafIngestSegmentLengthUnits
     */
    public final CmafIngestSegmentLengthUnits segmentLengthUnits() {
        return CmafIngestSegmentLengthUnits.fromValue(segmentLengthUnits);
    }

    /**
     * Time unit for segment length parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentLengthUnits} will return {@link CmafIngestSegmentLengthUnits#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #segmentLengthUnitsAsString}.
     * </p>
     * 
     * @return Time unit for segment length parameter.
     * @see CmafIngestSegmentLengthUnits
     */
    public final String segmentLengthUnitsAsString() {
        return segmentLengthUnits;
    }

    /**
     * Number of milliseconds to delay the output from the second pipeline.
     * 
     * @return Number of milliseconds to delay the output from the second pipeline.
     */
    public final Integer sendDelayMs() {
        return sendDelayMs;
    }

    /**
     * If set to passthrough, passes any KLV data from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #klvBehavior} will
     * return {@link CmafKLVBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #klvBehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any KLV data from the input source to this output.
     * @see CmafKLVBehavior
     */
    public final CmafKLVBehavior klvBehavior() {
        return CmafKLVBehavior.fromValue(klvBehavior);
    }

    /**
     * If set to passthrough, passes any KLV data from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #klvBehavior} will
     * return {@link CmafKLVBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #klvBehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any KLV data from the input source to this output.
     * @see CmafKLVBehavior
     */
    public final String klvBehaviorAsString() {
        return klvBehavior;
    }

    /**
     * Change the modifier that MediaLive automatically adds to the Streams() name that identifies a KLV track. The
     * default is "klv", which means the default name will be Streams(klv.cmfm). Any string you enter here will replace
     * the "klv" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-), underscore (_) and
     * period (.) and has a maximum length of 100 characters.
     * 
     * @return Change the modifier that MediaLive automatically adds to the Streams() name that identifies a KLV track.
     *         The default is "klv", which means the default name will be Streams(klv.cmfm). Any string you enter here
     *         will replace the "klv" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-),
     *         underscore (_) and period (.) and has a maximum length of 100 characters.
     */
    public final String klvNameModifier() {
        return klvNameModifier;
    }

    /**
     * Change the modifier that MediaLive automatically adds to the Streams() name that identifies a Nielsen ID3 track.
     * The default is "nid3", which means the default name will be Streams(nid3.cmfm). Any string you enter here will
     * replace the "nid3" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-), underscore (_)
     * and period (.) and has a maximum length of 100 characters.
     * 
     * @return Change the modifier that MediaLive automatically adds to the Streams() name that identifies a Nielsen ID3
     *         track. The default is "nid3", which means the default name will be Streams(nid3.cmfm). Any string you
     *         enter here will replace the "nid3" string.\nThe modifier can only contain: numbers, letters, plus (+),
     *         minus (-), underscore (_) and period (.) and has a maximum length of 100 characters.
     */
    public final String nielsenId3NameModifier() {
        return nielsenId3NameModifier;
    }

    /**
     * Change the modifier that MediaLive automatically adds to the Streams() name for a SCTE 35 track. The default is
     * "scte", which means the default name will be Streams(scte.cmfm). Any string you enter here will replace the
     * "scte" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-), underscore (_) and period
     * (.) and has a maximum length of 100 characters.
     * 
     * @return Change the modifier that MediaLive automatically adds to the Streams() name for a SCTE 35 track. The
     *         default is "scte", which means the default name will be Streams(scte.cmfm). Any string you enter here
     *         will replace the "scte" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-),
     *         underscore (_) and period (.) and has a maximum length of 100 characters.
     */
    public final String scte35NameModifier() {
        return scte35NameModifier;
    }

    /**
     * Set to ENABLED to enable ID3 metadata insertion. To include metadata, you configure other parameters in the
     * output group, or you add an ID3 action to the channel schedule.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #id3Behavior} will
     * return {@link CmafId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #id3BehaviorAsString}.
     * </p>
     * 
     * @return Set to ENABLED to enable ID3 metadata insertion. To include metadata, you configure other parameters in
     *         the output group, or you add an ID3 action to the channel schedule.
     * @see CmafId3Behavior
     */
    public final CmafId3Behavior id3Behavior() {
        return CmafId3Behavior.fromValue(id3Behavior);
    }

    /**
     * Set to ENABLED to enable ID3 metadata insertion. To include metadata, you configure other parameters in the
     * output group, or you add an ID3 action to the channel schedule.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #id3Behavior} will
     * return {@link CmafId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #id3BehaviorAsString}.
     * </p>
     * 
     * @return Set to ENABLED to enable ID3 metadata insertion. To include metadata, you configure other parameters in
     *         the output group, or you add an ID3 action to the channel schedule.
     * @see CmafId3Behavior
     */
    public final String id3BehaviorAsString() {
        return id3Behavior;
    }

    /**
     * Change the modifier that MediaLive automatically adds to the Streams() name that identifies an ID3 track. The
     * default is "id3", which means the default name will be Streams(id3.cmfm). Any string you enter here will replace
     * the "id3" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-), underscore (_) and
     * period (.) and has a maximum length of 100 characters.
     * 
     * @return Change the modifier that MediaLive automatically adds to the Streams() name that identifies an ID3 track.
     *         The default is "id3", which means the default name will be Streams(id3.cmfm). Any string you enter here
     *         will replace the "id3" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-),
     *         underscore (_) and period (.) and has a maximum length of 100 characters.
     */
    public final String id3NameModifier() {
        return id3NameModifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenId3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte35TypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLengthUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sendDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(klvBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(klvNameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenId3NameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(scte35NameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(id3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id3NameModifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafIngestGroupSettings)) {
            return false;
        }
        CmafIngestGroupSettings other = (CmafIngestGroupSettings) obj;
        return Objects.equals(destination(), other.destination())
                && Objects.equals(nielsenId3BehaviorAsString(), other.nielsenId3BehaviorAsString())
                && Objects.equals(scte35TypeAsString(), other.scte35TypeAsString())
                && Objects.equals(segmentLength(), other.segmentLength())
                && Objects.equals(segmentLengthUnitsAsString(), other.segmentLengthUnitsAsString())
                && Objects.equals(sendDelayMs(), other.sendDelayMs())
                && Objects.equals(klvBehaviorAsString(), other.klvBehaviorAsString())
                && Objects.equals(klvNameModifier(), other.klvNameModifier())
                && Objects.equals(nielsenId3NameModifier(), other.nielsenId3NameModifier())
                && Objects.equals(scte35NameModifier(), other.scte35NameModifier())
                && Objects.equals(id3BehaviorAsString(), other.id3BehaviorAsString())
                && Objects.equals(id3NameModifier(), other.id3NameModifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CmafIngestGroupSettings").add("Destination", destination())
                .add("NielsenId3Behavior", nielsenId3BehaviorAsString()).add("Scte35Type", scte35TypeAsString())
                .add("SegmentLength", segmentLength()).add("SegmentLengthUnits", segmentLengthUnitsAsString())
                .add("SendDelayMs", sendDelayMs()).add("KlvBehavior", klvBehaviorAsString())
                .add("KlvNameModifier", klvNameModifier()).add("NielsenId3NameModifier", nielsenId3NameModifier())
                .add("Scte35NameModifier", scte35NameModifier()).add("Id3Behavior", id3BehaviorAsString())
                .add("Id3NameModifier", id3NameModifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "NielsenId3Behavior":
            return Optional.ofNullable(clazz.cast(nielsenId3BehaviorAsString()));
        case "Scte35Type":
            return Optional.ofNullable(clazz.cast(scte35TypeAsString()));
        case "SegmentLength":
            return Optional.ofNullable(clazz.cast(segmentLength()));
        case "SegmentLengthUnits":
            return Optional.ofNullable(clazz.cast(segmentLengthUnitsAsString()));
        case "SendDelayMs":
            return Optional.ofNullable(clazz.cast(sendDelayMs()));
        case "KlvBehavior":
            return Optional.ofNullable(clazz.cast(klvBehaviorAsString()));
        case "KlvNameModifier":
            return Optional.ofNullable(clazz.cast(klvNameModifier()));
        case "NielsenId3NameModifier":
            return Optional.ofNullable(clazz.cast(nielsenId3NameModifier()));
        case "Scte35NameModifier":
            return Optional.ofNullable(clazz.cast(scte35NameModifier()));
        case "Id3Behavior":
            return Optional.ofNullable(clazz.cast(id3BehaviorAsString()));
        case "Id3NameModifier":
            return Optional.ofNullable(clazz.cast(id3NameModifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destination", DESTINATION_FIELD);
        map.put("nielsenId3Behavior", NIELSEN_ID3_BEHAVIOR_FIELD);
        map.put("scte35Type", SCTE35_TYPE_FIELD);
        map.put("segmentLength", SEGMENT_LENGTH_FIELD);
        map.put("segmentLengthUnits", SEGMENT_LENGTH_UNITS_FIELD);
        map.put("sendDelayMs", SEND_DELAY_MS_FIELD);
        map.put("klvBehavior", KLV_BEHAVIOR_FIELD);
        map.put("klvNameModifier", KLV_NAME_MODIFIER_FIELD);
        map.put("nielsenId3NameModifier", NIELSEN_ID3_NAME_MODIFIER_FIELD);
        map.put("scte35NameModifier", SCTE35_NAME_MODIFIER_FIELD);
        map.put("id3Behavior", ID3_BEHAVIOR_FIELD);
        map.put("id3NameModifier", ID3_NAME_MODIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CmafIngestGroupSettings, T> g) {
        return obj -> g.apply((CmafIngestGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CmafIngestGroupSettings> {
        /**
         * A HTTP destination for the tracks
         * 
         * @param destination
         *        A HTTP destination for the tracks
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(OutputLocationRef destination);

        /**
         * A HTTP destination for the tracks This is a convenience method that creates an instance of the
         * {@link OutputLocationRef.Builder} avoiding the need to create one manually via
         * {@link OutputLocationRef#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputLocationRef.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(OutputLocationRef)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link OutputLocationRef.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(OutputLocationRef)
         */
        default Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return destination(OutputLocationRef.builder().applyMutation(destination).build());
        }

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
         * equivalent ID3 tag will be inserted in the output.
         * 
         * @param nielsenId3Behavior
         *        If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio
         *        and an equivalent ID3 tag will be inserted in the output.
         * @see CmafNielsenId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafNielsenId3Behavior
         */
        Builder nielsenId3Behavior(String nielsenId3Behavior);

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
         * equivalent ID3 tag will be inserted in the output.
         * 
         * @param nielsenId3Behavior
         *        If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio
         *        and an equivalent ID3 tag will be inserted in the output.
         * @see CmafNielsenId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafNielsenId3Behavior
         */
        Builder nielsenId3Behavior(CmafNielsenId3Behavior nielsenId3Behavior);

        /**
         * Type of scte35 track to add. none or scte35WithoutSegmentation
         * 
         * @param scte35Type
         *        Type of scte35 track to add. none or scte35WithoutSegmentation
         * @see Scte35Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35Type
         */
        Builder scte35Type(String scte35Type);

        /**
         * Type of scte35 track to add. none or scte35WithoutSegmentation
         * 
         * @param scte35Type
         *        Type of scte35 track to add. none or scte35WithoutSegmentation
         * @see Scte35Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35Type
         */
        Builder scte35Type(Scte35Type scte35Type);

        /**
         * The nominal duration of segments. The units are specified in SegmentLengthUnits. The segments will end on the
         * next keyframe after the specified duration, so the actual segment length might be longer, and it might be a
         * fraction of the units.
         * 
         * @param segmentLength
         *        The nominal duration of segments. The units are specified in SegmentLengthUnits. The segments will end
         *        on the next keyframe after the specified duration, so the actual segment length might be longer, and
         *        it might be a fraction of the units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentLength(Integer segmentLength);

        /**
         * Time unit for segment length parameter.
         * 
         * @param segmentLengthUnits
         *        Time unit for segment length parameter.
         * @see CmafIngestSegmentLengthUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafIngestSegmentLengthUnits
         */
        Builder segmentLengthUnits(String segmentLengthUnits);

        /**
         * Time unit for segment length parameter.
         * 
         * @param segmentLengthUnits
         *        Time unit for segment length parameter.
         * @see CmafIngestSegmentLengthUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafIngestSegmentLengthUnits
         */
        Builder segmentLengthUnits(CmafIngestSegmentLengthUnits segmentLengthUnits);

        /**
         * Number of milliseconds to delay the output from the second pipeline.
         * 
         * @param sendDelayMs
         *        Number of milliseconds to delay the output from the second pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendDelayMs(Integer sendDelayMs);

        /**
         * If set to passthrough, passes any KLV data from the input source to this output.
         * 
         * @param klvBehavior
         *        If set to passthrough, passes any KLV data from the input source to this output.
         * @see CmafKLVBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafKLVBehavior
         */
        Builder klvBehavior(String klvBehavior);

        /**
         * If set to passthrough, passes any KLV data from the input source to this output.
         * 
         * @param klvBehavior
         *        If set to passthrough, passes any KLV data from the input source to this output.
         * @see CmafKLVBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafKLVBehavior
         */
        Builder klvBehavior(CmafKLVBehavior klvBehavior);

        /**
         * Change the modifier that MediaLive automatically adds to the Streams() name that identifies a KLV track. The
         * default is "klv", which means the default name will be Streams(klv.cmfm). Any string you enter here will
         * replace the "klv" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-), underscore
         * (_) and period (.) and has a maximum length of 100 characters.
         * 
         * @param klvNameModifier
         *        Change the modifier that MediaLive automatically adds to the Streams() name that identifies a KLV
         *        track. The default is "klv", which means the default name will be Streams(klv.cmfm). Any string you
         *        enter here will replace the "klv" string.\nThe modifier can only contain: numbers, letters, plus (+),
         *        minus (-), underscore (_) and period (.) and has a maximum length of 100 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder klvNameModifier(String klvNameModifier);

        /**
         * Change the modifier that MediaLive automatically adds to the Streams() name that identifies a Nielsen ID3
         * track. The default is "nid3", which means the default name will be Streams(nid3.cmfm). Any string you enter
         * here will replace the "nid3" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-),
         * underscore (_) and period (.) and has a maximum length of 100 characters.
         * 
         * @param nielsenId3NameModifier
         *        Change the modifier that MediaLive automatically adds to the Streams() name that identifies a Nielsen
         *        ID3 track. The default is "nid3", which means the default name will be Streams(nid3.cmfm). Any string
         *        you enter here will replace the "nid3" string.\nThe modifier can only contain: numbers, letters, plus
         *        (+), minus (-), underscore (_) and period (.) and has a maximum length of 100 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nielsenId3NameModifier(String nielsenId3NameModifier);

        /**
         * Change the modifier that MediaLive automatically adds to the Streams() name for a SCTE 35 track. The default
         * is "scte", which means the default name will be Streams(scte.cmfm). Any string you enter here will replace
         * the "scte" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-), underscore (_) and
         * period (.) and has a maximum length of 100 characters.
         * 
         * @param scte35NameModifier
         *        Change the modifier that MediaLive automatically adds to the Streams() name for a SCTE 35 track. The
         *        default is "scte", which means the default name will be Streams(scte.cmfm). Any string you enter here
         *        will replace the "scte" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-),
         *        underscore (_) and period (.) and has a maximum length of 100 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35NameModifier(String scte35NameModifier);

        /**
         * Set to ENABLED to enable ID3 metadata insertion. To include metadata, you configure other parameters in the
         * output group, or you add an ID3 action to the channel schedule.
         * 
         * @param id3Behavior
         *        Set to ENABLED to enable ID3 metadata insertion. To include metadata, you configure other parameters
         *        in the output group, or you add an ID3 action to the channel schedule.
         * @see CmafId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafId3Behavior
         */
        Builder id3Behavior(String id3Behavior);

        /**
         * Set to ENABLED to enable ID3 metadata insertion. To include metadata, you configure other parameters in the
         * output group, or you add an ID3 action to the channel schedule.
         * 
         * @param id3Behavior
         *        Set to ENABLED to enable ID3 metadata insertion. To include metadata, you configure other parameters
         *        in the output group, or you add an ID3 action to the channel schedule.
         * @see CmafId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafId3Behavior
         */
        Builder id3Behavior(CmafId3Behavior id3Behavior);

        /**
         * Change the modifier that MediaLive automatically adds to the Streams() name that identifies an ID3 track. The
         * default is "id3", which means the default name will be Streams(id3.cmfm). Any string you enter here will
         * replace the "id3" string.\nThe modifier can only contain: numbers, letters, plus (+), minus (-), underscore
         * (_) and period (.) and has a maximum length of 100 characters.
         * 
         * @param id3NameModifier
         *        Change the modifier that MediaLive automatically adds to the Streams() name that identifies an ID3
         *        track. The default is "id3", which means the default name will be Streams(id3.cmfm). Any string you
         *        enter here will replace the "id3" string.\nThe modifier can only contain: numbers, letters, plus (+),
         *        minus (-), underscore (_) and period (.) and has a maximum length of 100 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id3NameModifier(String id3NameModifier);
    }

    static final class BuilderImpl implements Builder {
        private OutputLocationRef destination;

        private String nielsenId3Behavior;

        private String scte35Type;

        private Integer segmentLength;

        private String segmentLengthUnits;

        private Integer sendDelayMs;

        private String klvBehavior;

        private String klvNameModifier;

        private String nielsenId3NameModifier;

        private String scte35NameModifier;

        private String id3Behavior;

        private String id3NameModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafIngestGroupSettings model) {
            destination(model.destination);
            nielsenId3Behavior(model.nielsenId3Behavior);
            scte35Type(model.scte35Type);
            segmentLength(model.segmentLength);
            segmentLengthUnits(model.segmentLengthUnits);
            sendDelayMs(model.sendDelayMs);
            klvBehavior(model.klvBehavior);
            klvNameModifier(model.klvNameModifier);
            nielsenId3NameModifier(model.nielsenId3NameModifier);
            scte35NameModifier(model.scte35NameModifier);
            id3Behavior(model.id3Behavior);
            id3NameModifier(model.id3NameModifier);
        }

        public final OutputLocationRef.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final String getNielsenId3Behavior() {
            return nielsenId3Behavior;
        }

        public final void setNielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
        }

        @Override
        public final Builder nielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
            return this;
        }

        @Override
        public final Builder nielsenId3Behavior(CmafNielsenId3Behavior nielsenId3Behavior) {
            this.nielsenId3Behavior(nielsenId3Behavior == null ? null : nielsenId3Behavior.toString());
            return this;
        }

        public final String getScte35Type() {
            return scte35Type;
        }

        public final void setScte35Type(String scte35Type) {
            this.scte35Type = scte35Type;
        }

        @Override
        public final Builder scte35Type(String scte35Type) {
            this.scte35Type = scte35Type;
            return this;
        }

        @Override
        public final Builder scte35Type(Scte35Type scte35Type) {
            this.scte35Type(scte35Type == null ? null : scte35Type.toString());
            return this;
        }

        public final Integer getSegmentLength() {
            return segmentLength;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final String getSegmentLengthUnits() {
            return segmentLengthUnits;
        }

        public final void setSegmentLengthUnits(String segmentLengthUnits) {
            this.segmentLengthUnits = segmentLengthUnits;
        }

        @Override
        public final Builder segmentLengthUnits(String segmentLengthUnits) {
            this.segmentLengthUnits = segmentLengthUnits;
            return this;
        }

        @Override
        public final Builder segmentLengthUnits(CmafIngestSegmentLengthUnits segmentLengthUnits) {
            this.segmentLengthUnits(segmentLengthUnits == null ? null : segmentLengthUnits.toString());
            return this;
        }

        public final Integer getSendDelayMs() {
            return sendDelayMs;
        }

        public final void setSendDelayMs(Integer sendDelayMs) {
            this.sendDelayMs = sendDelayMs;
        }

        @Override
        public final Builder sendDelayMs(Integer sendDelayMs) {
            this.sendDelayMs = sendDelayMs;
            return this;
        }

        public final String getKlvBehavior() {
            return klvBehavior;
        }

        public final void setKlvBehavior(String klvBehavior) {
            this.klvBehavior = klvBehavior;
        }

        @Override
        public final Builder klvBehavior(String klvBehavior) {
            this.klvBehavior = klvBehavior;
            return this;
        }

        @Override
        public final Builder klvBehavior(CmafKLVBehavior klvBehavior) {
            this.klvBehavior(klvBehavior == null ? null : klvBehavior.toString());
            return this;
        }

        public final String getKlvNameModifier() {
            return klvNameModifier;
        }

        public final void setKlvNameModifier(String klvNameModifier) {
            this.klvNameModifier = klvNameModifier;
        }

        @Override
        public final Builder klvNameModifier(String klvNameModifier) {
            this.klvNameModifier = klvNameModifier;
            return this;
        }

        public final String getNielsenId3NameModifier() {
            return nielsenId3NameModifier;
        }

        public final void setNielsenId3NameModifier(String nielsenId3NameModifier) {
            this.nielsenId3NameModifier = nielsenId3NameModifier;
        }

        @Override
        public final Builder nielsenId3NameModifier(String nielsenId3NameModifier) {
            this.nielsenId3NameModifier = nielsenId3NameModifier;
            return this;
        }

        public final String getScte35NameModifier() {
            return scte35NameModifier;
        }

        public final void setScte35NameModifier(String scte35NameModifier) {
            this.scte35NameModifier = scte35NameModifier;
        }

        @Override
        public final Builder scte35NameModifier(String scte35NameModifier) {
            this.scte35NameModifier = scte35NameModifier;
            return this;
        }

        public final String getId3Behavior() {
            return id3Behavior;
        }

        public final void setId3Behavior(String id3Behavior) {
            this.id3Behavior = id3Behavior;
        }

        @Override
        public final Builder id3Behavior(String id3Behavior) {
            this.id3Behavior = id3Behavior;
            return this;
        }

        @Override
        public final Builder id3Behavior(CmafId3Behavior id3Behavior) {
            this.id3Behavior(id3Behavior == null ? null : id3Behavior.toString());
            return this;
        }

        public final String getId3NameModifier() {
            return id3NameModifier;
        }

        public final void setId3NameModifier(String id3NameModifier) {
            this.id3NameModifier = id3NameModifier;
        }

        @Override
        public final Builder id3NameModifier(String id3NameModifier) {
            this.id3NameModifier = id3NameModifier;
            return this;
        }

        @Override
        public CmafIngestGroupSettings build() {
            return new CmafIngestGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
