/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Property of encoderSettings. Controls color conversion when you are using 3D LUT files to perform color conversion on
 * video.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColorCorrectionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ColorCorrectionSettings.Builder, ColorCorrectionSettings> {
    private static final SdkField<List<ColorCorrection>> GLOBAL_COLOR_CORRECTIONS_FIELD = SdkField
            .<List<ColorCorrection>> builder(MarshallingType.LIST)
            .memberName("GlobalColorCorrections")
            .getter(getter(ColorCorrectionSettings::globalColorCorrections))
            .setter(setter(Builder::globalColorCorrections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalColorCorrections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColorCorrection> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColorCorrection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GLOBAL_COLOR_CORRECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ColorCorrection> globalColorCorrections;

    private ColorCorrectionSettings(BuilderImpl builder) {
        this.globalColorCorrections = builder.globalColorCorrections;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalColorCorrections property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGlobalColorCorrections() {
        return globalColorCorrections != null && !(globalColorCorrections instanceof SdkAutoConstructList);
    }

    /**
     * An array of colorCorrections that applies when you are using 3D LUT files to perform color conversion on video.
     * Each colorCorrection contains one 3D LUT file (that defines the color mapping for converting an input color space
     * to an output color space), and the input/output combination that this 3D LUT file applies to. MediaLive reads the
     * color space in the input metadata, determines the color space that you have specified for the output, and finds
     * and uses the LUT file that applies to this combination.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalColorCorrections} method.
     * </p>
     * 
     * @return An array of colorCorrections that applies when you are using 3D LUT files to perform color conversion on
     *         video. Each colorCorrection contains one 3D LUT file (that defines the color mapping for converting an
     *         input color space to an output color space), and the input/output combination that this 3D LUT file
     *         applies to. MediaLive reads the color space in the input metadata, determines the color space that you
     *         have specified for the output, and finds and uses the LUT file that applies to this combination.
     */
    public final List<ColorCorrection> globalColorCorrections() {
        return globalColorCorrections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalColorCorrections() ? globalColorCorrections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorCorrectionSettings)) {
            return false;
        }
        ColorCorrectionSettings other = (ColorCorrectionSettings) obj;
        return hasGlobalColorCorrections() == other.hasGlobalColorCorrections()
                && Objects.equals(globalColorCorrections(), other.globalColorCorrections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColorCorrectionSettings")
                .add("GlobalColorCorrections", hasGlobalColorCorrections() ? globalColorCorrections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalColorCorrections":
            return Optional.ofNullable(clazz.cast(globalColorCorrections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("globalColorCorrections", GLOBAL_COLOR_CORRECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColorCorrectionSettings, T> g) {
        return obj -> g.apply((ColorCorrectionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColorCorrectionSettings> {
        /**
         * An array of colorCorrections that applies when you are using 3D LUT files to perform color conversion on
         * video. Each colorCorrection contains one 3D LUT file (that defines the color mapping for converting an input
         * color space to an output color space), and the input/output combination that this 3D LUT file applies to.
         * MediaLive reads the color space in the input metadata, determines the color space that you have specified for
         * the output, and finds and uses the LUT file that applies to this combination.
         * 
         * @param globalColorCorrections
         *        An array of colorCorrections that applies when you are using 3D LUT files to perform color conversion
         *        on video. Each colorCorrection contains one 3D LUT file (that defines the color mapping for converting
         *        an input color space to an output color space), and the input/output combination that this 3D LUT file
         *        applies to. MediaLive reads the color space in the input metadata, determines the color space that you
         *        have specified for the output, and finds and uses the LUT file that applies to this combination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalColorCorrections(Collection<ColorCorrection> globalColorCorrections);

        /**
         * An array of colorCorrections that applies when you are using 3D LUT files to perform color conversion on
         * video. Each colorCorrection contains one 3D LUT file (that defines the color mapping for converting an input
         * color space to an output color space), and the input/output combination that this 3D LUT file applies to.
         * MediaLive reads the color space in the input metadata, determines the color space that you have specified for
         * the output, and finds and uses the LUT file that applies to this combination.
         * 
         * @param globalColorCorrections
         *        An array of colorCorrections that applies when you are using 3D LUT files to perform color conversion
         *        on video. Each colorCorrection contains one 3D LUT file (that defines the color mapping for converting
         *        an input color space to an output color space), and the input/output combination that this 3D LUT file
         *        applies to. MediaLive reads the color space in the input metadata, determines the color space that you
         *        have specified for the output, and finds and uses the LUT file that applies to this combination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalColorCorrections(ColorCorrection... globalColorCorrections);

        /**
         * An array of colorCorrections that applies when you are using 3D LUT files to perform color conversion on
         * video. Each colorCorrection contains one 3D LUT file (that defines the color mapping for converting an input
         * color space to an output color space), and the input/output combination that this 3D LUT file applies to.
         * MediaLive reads the color space in the input metadata, determines the color space that you have specified for
         * the output, and finds and uses the LUT file that applies to this combination. This is a convenience method
         * that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.ColorCorrection.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.medialive.model.ColorCorrection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.ColorCorrection.Builder#build()} is called immediately
         * and its result is passed to {@link #globalColorCorrections(List<ColorCorrection>)}.
         * 
         * @param globalColorCorrections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.ColorCorrection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalColorCorrections(java.util.Collection<ColorCorrection>)
         */
        Builder globalColorCorrections(Consumer<ColorCorrection.Builder>... globalColorCorrections);
    }

    static final class BuilderImpl implements Builder {
        private List<ColorCorrection> globalColorCorrections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColorCorrectionSettings model) {
            globalColorCorrections(model.globalColorCorrections);
        }

        public final List<ColorCorrection.Builder> getGlobalColorCorrections() {
            List<ColorCorrection.Builder> result = ___listOfColorCorrectionCopier.copyToBuilder(this.globalColorCorrections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalColorCorrections(Collection<ColorCorrection.BuilderImpl> globalColorCorrections) {
            this.globalColorCorrections = ___listOfColorCorrectionCopier.copyFromBuilder(globalColorCorrections);
        }

        @Override
        public final Builder globalColorCorrections(Collection<ColorCorrection> globalColorCorrections) {
            this.globalColorCorrections = ___listOfColorCorrectionCopier.copy(globalColorCorrections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalColorCorrections(ColorCorrection... globalColorCorrections) {
            globalColorCorrections(Arrays.asList(globalColorCorrections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalColorCorrections(Consumer<ColorCorrection.Builder>... globalColorCorrections) {
            globalColorCorrections(Stream.of(globalColorCorrections).map(c -> ColorCorrection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ColorCorrectionSettings build() {
            return new ColorCorrectionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
