/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to create a new node registration script.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNodeRegistrationScriptRequest extends MediaLiveRequest implements
        ToCopyableBuilder<CreateNodeRegistrationScriptRequest.Builder, CreateNodeRegistrationScriptRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(CreateNodeRegistrationScriptRequest::clusterId))
            .setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateNodeRegistrationScriptRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateNodeRegistrationScriptRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<NodeInterfaceMapping>> NODE_INTERFACE_MAPPINGS_FIELD = SdkField
            .<List<NodeInterfaceMapping>> builder(MarshallingType.LIST)
            .memberName("NodeInterfaceMappings")
            .getter(getter(CreateNodeRegistrationScriptRequest::nodeInterfaceMappings))
            .setter(setter(Builder::nodeInterfaceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInterfaceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeInterfaceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeInterfaceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestId")
            .getter(getter(CreateNodeRegistrationScriptRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateNodeRegistrationScriptRequest::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, ID_FIELD,
            NAME_FIELD, NODE_INTERFACE_MAPPINGS_FIELD, REQUEST_ID_FIELD, ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterId;

    private final String id;

    private final String name;

    private final List<NodeInterfaceMapping> nodeInterfaceMappings;

    private final String requestId;

    private final String role;

    private CreateNodeRegistrationScriptRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.id = builder.id;
        this.name = builder.name;
        this.nodeInterfaceMappings = builder.nodeInterfaceMappings;
        this.requestId = builder.requestId;
        this.role = builder.role;
    }

    /**
     * The ID of the cluster
     * 
     * @return The ID of the cluster
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * If you're generating a re-registration script for an already existing node, this is where you provide the id.
     * 
     * @return If you're generating a re-registration script for an already existing node, this is where you provide the
     *         id.
     */
    public final String id() {
        return id;
    }

    /**
     * Specify a pattern for MediaLive Anywhere to use to assign a name to each Node in the Cluster. The pattern can
     * include the variables $hn (hostname of the node hardware) and $ts for the date and time that the Node is created,
     * in UTC (for example, 2024-08-20T23:35:12Z).
     * 
     * @return Specify a pattern for MediaLive Anywhere to use to assign a name to each Node in the Cluster. The pattern
     *         can include the variables $hn (hostname of the node hardware) and $ts for the date and time that the Node
     *         is created, in UTC (for example, 2024-08-20T23:35:12Z).
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeInterfaceMappings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNodeInterfaceMappings() {
        return nodeInterfaceMappings != null && !(nodeInterfaceMappings instanceof SdkAutoConstructList);
    }

    /**
     * Documentation update needed
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeInterfaceMappings} method.
     * </p>
     * 
     * @return Documentation update needed
     */
    public final List<NodeInterfaceMapping> nodeInterfaceMappings() {
        return nodeInterfaceMappings;
    }

    /**
     * An ID that you assign to a create request. This ID ensures idempotency when creating resources.
     * 
     * @return An ID that you assign to a create request. This ID ensures idempotency when creating resources.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means the
     * Node is a redundant Node and might get used if an ACTIVE Node fails.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link NodeRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
     *         means the Node is a redundant Node and might get used if an ACTIVE Node fails.
     * @see NodeRole
     */
    public final NodeRole role() {
        return NodeRole.fromValue(role);
    }

    /**
     * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means the
     * Node is a redundant Node and might get used if an ACTIVE Node fails.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link NodeRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
     *         means the Node is a redundant Node and might get used if an ACTIVE Node fails.
     * @see NodeRole
     */
    public final String roleAsString() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeInterfaceMappings() ? nodeInterfaceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodeRegistrationScriptRequest)) {
            return false;
        }
        CreateNodeRegistrationScriptRequest other = (CreateNodeRegistrationScriptRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && hasNodeInterfaceMappings() == other.hasNodeInterfaceMappings()
                && Objects.equals(nodeInterfaceMappings(), other.nodeInterfaceMappings())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(roleAsString(), other.roleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNodeRegistrationScriptRequest").add("ClusterId", clusterId()).add("Id", id())
                .add("Name", name()).add("NodeInterfaceMappings", hasNodeInterfaceMappings() ? nodeInterfaceMappings() : null)
                .add("RequestId", requestId()).add("Role", roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NodeInterfaceMappings":
            return Optional.ofNullable(clazz.cast(nodeInterfaceMappings()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("nodeInterfaceMappings", NODE_INTERFACE_MAPPINGS_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("role", ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNodeRegistrationScriptRequest, T> g) {
        return obj -> g.apply((CreateNodeRegistrationScriptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateNodeRegistrationScriptRequest> {
        /**
         * The ID of the cluster
         * 
         * @param clusterId
         *        The ID of the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * If you're generating a re-registration script for an already existing node, this is where you provide the id.
         * 
         * @param id
         *        If you're generating a re-registration script for an already existing node, this is where you provide
         *        the id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Specify a pattern for MediaLive Anywhere to use to assign a name to each Node in the Cluster. The pattern can
         * include the variables $hn (hostname of the node hardware) and $ts for the date and time that the Node is
         * created, in UTC (for example, 2024-08-20T23:35:12Z).
         * 
         * @param name
         *        Specify a pattern for MediaLive Anywhere to use to assign a name to each Node in the Cluster. The
         *        pattern can include the variables $hn (hostname of the node hardware) and $ts for the date and time
         *        that the Node is created, in UTC (for example, 2024-08-20T23:35:12Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Documentation update needed
         * 
         * @param nodeInterfaceMappings
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInterfaceMappings(Collection<NodeInterfaceMapping> nodeInterfaceMappings);

        /**
         * Documentation update needed
         * 
         * @param nodeInterfaceMappings
         *        Documentation update needed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInterfaceMappings(NodeInterfaceMapping... nodeInterfaceMappings);

        /**
         * Documentation update needed This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMapping.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #nodeInterfaceMappings(List<NodeInterfaceMapping>)}.
         * 
         * @param nodeInterfaceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.NodeInterfaceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeInterfaceMappings(java.util.Collection<NodeInterfaceMapping>)
         */
        Builder nodeInterfaceMappings(Consumer<NodeInterfaceMapping.Builder>... nodeInterfaceMappings);

        /**
         * An ID that you assign to a create request. This ID ensures idempotency when creating resources.
         * 
         * @param requestId
         *        An ID that you assign to a create request. This ID ensures idempotency when creating resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means
         * the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * 
         * @param role
         *        The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
         *        means the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * @see NodeRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeRole
         */
        Builder role(String role);

        /**
         * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means
         * the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * 
         * @param role
         *        The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
         *        means the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * @see NodeRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeRole
         */
        Builder role(NodeRole role);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String clusterId;

        private String id;

        private String name;

        private List<NodeInterfaceMapping> nodeInterfaceMappings = DefaultSdkAutoConstructList.getInstance();

        private String requestId;

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodeRegistrationScriptRequest model) {
            super(model);
            clusterId(model.clusterId);
            id(model.id);
            name(model.name);
            nodeInterfaceMappings(model.nodeInterfaceMappings);
            requestId(model.requestId);
            role(model.role);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<NodeInterfaceMapping.Builder> getNodeInterfaceMappings() {
            List<NodeInterfaceMapping.Builder> result = ___listOfNodeInterfaceMappingCopier
                    .copyToBuilder(this.nodeInterfaceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeInterfaceMappings(Collection<NodeInterfaceMapping.BuilderImpl> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCopier.copyFromBuilder(nodeInterfaceMappings);
        }

        @Override
        public final Builder nodeInterfaceMappings(Collection<NodeInterfaceMapping> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCopier.copy(nodeInterfaceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(NodeInterfaceMapping... nodeInterfaceMappings) {
            nodeInterfaceMappings(Arrays.asList(nodeInterfaceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(Consumer<NodeInterfaceMapping.Builder>... nodeInterfaceMappings) {
            nodeInterfaceMappings(Stream.of(nodeInterfaceMappings)
                    .map(c -> NodeInterfaceMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(NodeRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNodeRegistrationScriptRequest build() {
            return new CreateNodeRegistrationScriptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
