/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for CreateSignalMapRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSignalMapRequest extends MediaLiveRequest implements
        ToCopyableBuilder<CreateSignalMapRequest.Builder, CreateSignalMapRequest> {
    private static final SdkField<List<String>> CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CloudWatchAlarmTemplateGroupIdentifiers")
            .getter(getter(CreateSignalMapRequest::cloudWatchAlarmTemplateGroupIdentifiers))
            .setter(setter(Builder::cloudWatchAlarmTemplateGroupIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("cloudWatchAlarmTemplateGroupIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateSignalMapRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISCOVERY_ENTRY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryEntryPointArn").getter(getter(CreateSignalMapRequest::discoveryEntryPointArn))
            .setter(setter(Builder::discoveryEntryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryEntryPointArn").build())
            .build();

    private static final SdkField<List<String>> EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventBridgeRuleTemplateGroupIdentifiers")
            .getter(getter(CreateSignalMapRequest::eventBridgeRuleTemplateGroupIdentifiers))
            .setter(setter(Builder::eventBridgeRuleTemplateGroupIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("eventBridgeRuleTemplateGroupIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateSignalMapRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateSignalMapRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestId")
            .getter(getter(CreateSignalMapRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIERS_FIELD, DESCRIPTION_FIELD, DISCOVERY_ENTRY_POINT_ARN_FIELD,
            EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIERS_FIELD, NAME_FIELD, TAGS_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> cloudWatchAlarmTemplateGroupIdentifiers;

    private final String description;

    private final String discoveryEntryPointArn;

    private final List<String> eventBridgeRuleTemplateGroupIdentifiers;

    private final String name;

    private final Map<String, String> tags;

    private final String requestId;

    private CreateSignalMapRequest(BuilderImpl builder) {
        super(builder);
        this.cloudWatchAlarmTemplateGroupIdentifiers = builder.cloudWatchAlarmTemplateGroupIdentifiers;
        this.description = builder.description;
        this.discoveryEntryPointArn = builder.discoveryEntryPointArn;
        this.eventBridgeRuleTemplateGroupIdentifiers = builder.eventBridgeRuleTemplateGroupIdentifiers;
        this.name = builder.name;
        this.tags = builder.tags;
        this.requestId = builder.requestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudWatchAlarmTemplateGroupIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCloudWatchAlarmTemplateGroupIdentifiers() {
        return cloudWatchAlarmTemplateGroupIdentifiers != null
                && !(cloudWatchAlarmTemplateGroupIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the CloudWatchAlarmTemplateGroupIdentifiers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasCloudWatchAlarmTemplateGroupIdentifiers} method.
     * </p>
     * 
     * @return The value of the CloudWatchAlarmTemplateGroupIdentifiers property for this object.
     */
    public final List<String> cloudWatchAlarmTemplateGroupIdentifiers() {
        return cloudWatchAlarmTemplateGroupIdentifiers;
    }

    /**
     * A resource's optional description.
     * 
     * @return A resource's optional description.
     */
    public final String description() {
        return description;
    }

    /**
     * A top-level supported AWS resource ARN to discovery a signal map from.
     * 
     * @return A top-level supported AWS resource ARN to discovery a signal map from.
     */
    public final String discoveryEntryPointArn() {
        return discoveryEntryPointArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventBridgeRuleTemplateGroupIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasEventBridgeRuleTemplateGroupIdentifiers() {
        return eventBridgeRuleTemplateGroupIdentifiers != null
                && !(eventBridgeRuleTemplateGroupIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the EventBridgeRuleTemplateGroupIdentifiers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasEventBridgeRuleTemplateGroupIdentifiers} method.
     * </p>
     * 
     * @return The value of the EventBridgeRuleTemplateGroupIdentifiers property for this object.
     */
    public final List<String> eventBridgeRuleTemplateGroupIdentifiers() {
        return eventBridgeRuleTemplateGroupIdentifiers;
    }

    /**
     * A resource's name. Names must be unique within the scope of a resource type in a specific region.
     * 
     * @return A resource's name. Names must be unique within the scope of a resource type in a specific region.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * An ID that you assign to a create request. This ID ensures idempotency when creating resources.
     * 
     * @return An ID that you assign to a create request. This ID ensures idempotency when creating resources.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasCloudWatchAlarmTemplateGroupIdentifiers() ? cloudWatchAlarmTemplateGroupIdentifiers()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryEntryPointArn());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasEventBridgeRuleTemplateGroupIdentifiers() ? eventBridgeRuleTemplateGroupIdentifiers()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSignalMapRequest)) {
            return false;
        }
        CreateSignalMapRequest other = (CreateSignalMapRequest) obj;
        return hasCloudWatchAlarmTemplateGroupIdentifiers() == other.hasCloudWatchAlarmTemplateGroupIdentifiers()
                && Objects.equals(cloudWatchAlarmTemplateGroupIdentifiers(), other.cloudWatchAlarmTemplateGroupIdentifiers())
                && Objects.equals(description(), other.description())
                && Objects.equals(discoveryEntryPointArn(), other.discoveryEntryPointArn())
                && hasEventBridgeRuleTemplateGroupIdentifiers() == other.hasEventBridgeRuleTemplateGroupIdentifiers()
                && Objects.equals(eventBridgeRuleTemplateGroupIdentifiers(), other.eventBridgeRuleTemplateGroupIdentifiers())
                && Objects.equals(name(), other.name()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateSignalMapRequest")
                .add("CloudWatchAlarmTemplateGroupIdentifiers",
                        hasCloudWatchAlarmTemplateGroupIdentifiers() ? cloudWatchAlarmTemplateGroupIdentifiers() : null)
                .add("Description", description())
                .add("DiscoveryEntryPointArn", discoveryEntryPointArn())
                .add("EventBridgeRuleTemplateGroupIdentifiers",
                        hasEventBridgeRuleTemplateGroupIdentifiers() ? eventBridgeRuleTemplateGroupIdentifiers() : null)
                .add("Name", name()).add("Tags", hasTags() ? tags() : null).add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchAlarmTemplateGroupIdentifiers":
            return Optional.ofNullable(clazz.cast(cloudWatchAlarmTemplateGroupIdentifiers()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DiscoveryEntryPointArn":
            return Optional.ofNullable(clazz.cast(discoveryEntryPointArn()));
        case "EventBridgeRuleTemplateGroupIdentifiers":
            return Optional.ofNullable(clazz.cast(eventBridgeRuleTemplateGroupIdentifiers()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudWatchAlarmTemplateGroupIdentifiers", CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIERS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("discoveryEntryPointArn", DISCOVERY_ENTRY_POINT_ARN_FIELD);
        map.put("eventBridgeRuleTemplateGroupIdentifiers", EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIERS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSignalMapRequest, T> g) {
        return obj -> g.apply((CreateSignalMapRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSignalMapRequest> {
        /**
         * Sets the value of the CloudWatchAlarmTemplateGroupIdentifiers property for this object.
         *
         * @param cloudWatchAlarmTemplateGroupIdentifiers
         *        The new value for the CloudWatchAlarmTemplateGroupIdentifiers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchAlarmTemplateGroupIdentifiers(Collection<String> cloudWatchAlarmTemplateGroupIdentifiers);

        /**
         * Sets the value of the CloudWatchAlarmTemplateGroupIdentifiers property for this object.
         *
         * @param cloudWatchAlarmTemplateGroupIdentifiers
         *        The new value for the CloudWatchAlarmTemplateGroupIdentifiers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchAlarmTemplateGroupIdentifiers(String... cloudWatchAlarmTemplateGroupIdentifiers);

        /**
         * A resource's optional description.
         * 
         * @param description
         *        A resource's optional description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * A top-level supported AWS resource ARN to discovery a signal map from.
         * 
         * @param discoveryEntryPointArn
         *        A top-level supported AWS resource ARN to discovery a signal map from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryEntryPointArn(String discoveryEntryPointArn);

        /**
         * Sets the value of the EventBridgeRuleTemplateGroupIdentifiers property for this object.
         *
         * @param eventBridgeRuleTemplateGroupIdentifiers
         *        The new value for the EventBridgeRuleTemplateGroupIdentifiers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeRuleTemplateGroupIdentifiers(Collection<String> eventBridgeRuleTemplateGroupIdentifiers);

        /**
         * Sets the value of the EventBridgeRuleTemplateGroupIdentifiers property for this object.
         *
         * @param eventBridgeRuleTemplateGroupIdentifiers
         *        The new value for the EventBridgeRuleTemplateGroupIdentifiers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeRuleTemplateGroupIdentifiers(String... eventBridgeRuleTemplateGroupIdentifiers);

        /**
         * A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * 
         * @param name
         *        A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * An ID that you assign to a create request. This ID ensures idempotency when creating resources.
         * 
         * @param requestId
         *        An ID that you assign to a create request. This ID ensures idempotency when creating resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private List<String> cloudWatchAlarmTemplateGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String discoveryEntryPointArn;

        private List<String> eventBridgeRuleTemplateGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSignalMapRequest model) {
            super(model);
            cloudWatchAlarmTemplateGroupIdentifiers(model.cloudWatchAlarmTemplateGroupIdentifiers);
            description(model.description);
            discoveryEntryPointArn(model.discoveryEntryPointArn);
            eventBridgeRuleTemplateGroupIdentifiers(model.eventBridgeRuleTemplateGroupIdentifiers);
            name(model.name);
            tags(model.tags);
            requestId(model.requestId);
        }

        public final Collection<String> getCloudWatchAlarmTemplateGroupIdentifiers() {
            if (cloudWatchAlarmTemplateGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return cloudWatchAlarmTemplateGroupIdentifiers;
        }

        public final void setCloudWatchAlarmTemplateGroupIdentifiers(Collection<String> cloudWatchAlarmTemplateGroupIdentifiers) {
            this.cloudWatchAlarmTemplateGroupIdentifiers = ___listOf__stringPatternSCopier
                    .copy(cloudWatchAlarmTemplateGroupIdentifiers);
        }

        @Override
        public final Builder cloudWatchAlarmTemplateGroupIdentifiers(Collection<String> cloudWatchAlarmTemplateGroupIdentifiers) {
            this.cloudWatchAlarmTemplateGroupIdentifiers = ___listOf__stringPatternSCopier
                    .copy(cloudWatchAlarmTemplateGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplateGroupIdentifiers(String... cloudWatchAlarmTemplateGroupIdentifiers) {
            cloudWatchAlarmTemplateGroupIdentifiers(Arrays.asList(cloudWatchAlarmTemplateGroupIdentifiers));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDiscoveryEntryPointArn() {
            return discoveryEntryPointArn;
        }

        public final void setDiscoveryEntryPointArn(String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
        }

        @Override
        public final Builder discoveryEntryPointArn(String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
            return this;
        }

        public final Collection<String> getEventBridgeRuleTemplateGroupIdentifiers() {
            if (eventBridgeRuleTemplateGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return eventBridgeRuleTemplateGroupIdentifiers;
        }

        public final void setEventBridgeRuleTemplateGroupIdentifiers(Collection<String> eventBridgeRuleTemplateGroupIdentifiers) {
            this.eventBridgeRuleTemplateGroupIdentifiers = ___listOf__stringPatternSCopier
                    .copy(eventBridgeRuleTemplateGroupIdentifiers);
        }

        @Override
        public final Builder eventBridgeRuleTemplateGroupIdentifiers(Collection<String> eventBridgeRuleTemplateGroupIdentifiers) {
            this.eventBridgeRuleTemplateGroupIdentifiers = ___listOf__stringPatternSCopier
                    .copy(eventBridgeRuleTemplateGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBridgeRuleTemplateGroupIdentifiers(String... eventBridgeRuleTemplateGroupIdentifiers) {
            eventBridgeRuleTemplateGroupIdentifiers(Arrays.asList(eventBridgeRuleTemplateGroupIdentifiers));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSignalMapRequest build() {
            return new CreateSignalMapRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
