/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for InputAttachment
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputAttachment implements SdkPojo, Serializable, ToCopyableBuilder<InputAttachment.Builder, InputAttachment> {
    private static final SdkField<AutomaticInputFailoverSettings> AUTOMATIC_INPUT_FAILOVER_SETTINGS_FIELD = SdkField
            .<AutomaticInputFailoverSettings> builder(MarshallingType.SDK_POJO)
            .memberName("AutomaticInputFailoverSettings")
            .getter(getter(InputAttachment::automaticInputFailoverSettings))
            .setter(setter(Builder::automaticInputFailoverSettings))
            .constructor(AutomaticInputFailoverSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticInputFailoverSettings")
                    .build()).build();

    private static final SdkField<String> INPUT_ATTACHMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputAttachmentName").getter(getter(InputAttachment::inputAttachmentName))
            .setter(setter(Builder::inputAttachmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachmentName").build())
            .build();

    private static final SdkField<String> INPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputId").getter(getter(InputAttachment::inputId)).setter(setter(Builder::inputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputId").build()).build();

    private static final SdkField<InputSettings> INPUT_SETTINGS_FIELD = SdkField
            .<InputSettings> builder(MarshallingType.SDK_POJO).memberName("InputSettings")
            .getter(getter(InputAttachment::inputSettings)).setter(setter(Builder::inputSettings))
            .constructor(InputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSettings").build()).build();

    private static final SdkField<List<String>> LOGICAL_INTERFACE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogicalInterfaceNames")
            .getter(getter(InputAttachment::logicalInterfaceNames))
            .setter(setter(Builder::logicalInterfaceNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalInterfaceNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATIC_INPUT_FAILOVER_SETTINGS_FIELD, INPUT_ATTACHMENT_NAME_FIELD, INPUT_ID_FIELD, INPUT_SETTINGS_FIELD,
            LOGICAL_INTERFACE_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomaticInputFailoverSettings automaticInputFailoverSettings;

    private final String inputAttachmentName;

    private final String inputId;

    private final InputSettings inputSettings;

    private final List<String> logicalInterfaceNames;

    private InputAttachment(BuilderImpl builder) {
        this.automaticInputFailoverSettings = builder.automaticInputFailoverSettings;
        this.inputAttachmentName = builder.inputAttachmentName;
        this.inputId = builder.inputId;
        this.inputSettings = builder.inputSettings;
        this.logicalInterfaceNames = builder.logicalInterfaceNames;
    }

    /**
     * User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over
     * to a different input.
     * 
     * @return User-specified settings for defining what the conditions are for declaring the input unhealthy and
     *         failing over to a different input.
     */
    public final AutomaticInputFailoverSettings automaticInputFailoverSettings() {
        return automaticInputFailoverSettings;
    }

    /**
     * User-specified name for the attachment. This is required if the user wants to use this input in an input switch
     * action.
     * 
     * @return User-specified name for the attachment. This is required if the user wants to use this input in an input
     *         switch action.
     */
    public final String inputAttachmentName() {
        return inputAttachmentName;
    }

    /**
     * The ID of the input
     * 
     * @return The ID of the input
     */
    public final String inputId() {
        return inputId;
    }

    /**
     * Settings of an input (caption selector, etc.)
     * 
     * @return Settings of an input (caption selector, etc.)
     */
    public final InputSettings inputSettings() {
        return inputSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogicalInterfaceNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogicalInterfaceNames() {
        return logicalInterfaceNames != null && !(logicalInterfaceNames instanceof SdkAutoConstructList);
    }

    /**
     * Optional assignment of an input to a logical interface on the Node. Only applies to on premises channels.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogicalInterfaceNames} method.
     * </p>
     * 
     * @return Optional assignment of an input to a logical interface on the Node. Only applies to on premises channels.
     */
    public final List<String> logicalInterfaceNames() {
        return logicalInterfaceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticInputFailoverSettings());
        hashCode = 31 * hashCode + Objects.hashCode(inputAttachmentName());
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(inputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogicalInterfaceNames() ? logicalInterfaceNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputAttachment)) {
            return false;
        }
        InputAttachment other = (InputAttachment) obj;
        return Objects.equals(automaticInputFailoverSettings(), other.automaticInputFailoverSettings())
                && Objects.equals(inputAttachmentName(), other.inputAttachmentName())
                && Objects.equals(inputId(), other.inputId()) && Objects.equals(inputSettings(), other.inputSettings())
                && hasLogicalInterfaceNames() == other.hasLogicalInterfaceNames()
                && Objects.equals(logicalInterfaceNames(), other.logicalInterfaceNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputAttachment").add("AutomaticInputFailoverSettings", automaticInputFailoverSettings())
                .add("InputAttachmentName", inputAttachmentName()).add("InputId", inputId())
                .add("InputSettings", inputSettings())
                .add("LogicalInterfaceNames", hasLogicalInterfaceNames() ? logicalInterfaceNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticInputFailoverSettings":
            return Optional.ofNullable(clazz.cast(automaticInputFailoverSettings()));
        case "InputAttachmentName":
            return Optional.ofNullable(clazz.cast(inputAttachmentName()));
        case "InputId":
            return Optional.ofNullable(clazz.cast(inputId()));
        case "InputSettings":
            return Optional.ofNullable(clazz.cast(inputSettings()));
        case "LogicalInterfaceNames":
            return Optional.ofNullable(clazz.cast(logicalInterfaceNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("automaticInputFailoverSettings", AUTOMATIC_INPUT_FAILOVER_SETTINGS_FIELD);
        map.put("inputAttachmentName", INPUT_ATTACHMENT_NAME_FIELD);
        map.put("inputId", INPUT_ID_FIELD);
        map.put("inputSettings", INPUT_SETTINGS_FIELD);
        map.put("logicalInterfaceNames", LOGICAL_INTERFACE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputAttachment, T> g) {
        return obj -> g.apply((InputAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputAttachment> {
        /**
         * User-specified settings for defining what the conditions are for declaring the input unhealthy and failing
         * over to a different input.
         * 
         * @param automaticInputFailoverSettings
         *        User-specified settings for defining what the conditions are for declaring the input unhealthy and
         *        failing over to a different input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticInputFailoverSettings(AutomaticInputFailoverSettings automaticInputFailoverSettings);

        /**
         * User-specified settings for defining what the conditions are for declaring the input unhealthy and failing
         * over to a different input. This is a convenience method that creates an instance of the
         * {@link AutomaticInputFailoverSettings.Builder} avoiding the need to create one manually via
         * {@link AutomaticInputFailoverSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomaticInputFailoverSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #automaticInputFailoverSettings(AutomaticInputFailoverSettings)}.
         * 
         * @param automaticInputFailoverSettings
         *        a consumer that will call methods on {@link AutomaticInputFailoverSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automaticInputFailoverSettings(AutomaticInputFailoverSettings)
         */
        default Builder automaticInputFailoverSettings(
                Consumer<AutomaticInputFailoverSettings.Builder> automaticInputFailoverSettings) {
            return automaticInputFailoverSettings(AutomaticInputFailoverSettings.builder()
                    .applyMutation(automaticInputFailoverSettings).build());
        }

        /**
         * User-specified name for the attachment. This is required if the user wants to use this input in an input
         * switch action.
         * 
         * @param inputAttachmentName
         *        User-specified name for the attachment. This is required if the user wants to use this input in an
         *        input switch action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachmentName(String inputAttachmentName);

        /**
         * The ID of the input
         * 
         * @param inputId
         *        The ID of the input
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * Settings of an input (caption selector, etc.)
         * 
         * @param inputSettings
         *        Settings of an input (caption selector, etc.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSettings(InputSettings inputSettings);

        /**
         * Settings of an input (caption selector, etc.) This is a convenience method that creates an instance of the
         * {@link InputSettings.Builder} avoiding the need to create one manually via {@link InputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSettings(InputSettings)}.
         * 
         * @param inputSettings
         *        a consumer that will call methods on {@link InputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSettings(InputSettings)
         */
        default Builder inputSettings(Consumer<InputSettings.Builder> inputSettings) {
            return inputSettings(InputSettings.builder().applyMutation(inputSettings).build());
        }

        /**
         * Optional assignment of an input to a logical interface on the Node. Only applies to on premises channels.
         * 
         * @param logicalInterfaceNames
         *        Optional assignment of an input to a logical interface on the Node. Only applies to on premises
         *        channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalInterfaceNames(Collection<String> logicalInterfaceNames);

        /**
         * Optional assignment of an input to a logical interface on the Node. Only applies to on premises channels.
         * 
         * @param logicalInterfaceNames
         *        Optional assignment of an input to a logical interface on the Node. Only applies to on premises
         *        channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalInterfaceNames(String... logicalInterfaceNames);
    }

    static final class BuilderImpl implements Builder {
        private AutomaticInputFailoverSettings automaticInputFailoverSettings;

        private String inputAttachmentName;

        private String inputId;

        private InputSettings inputSettings;

        private List<String> logicalInterfaceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputAttachment model) {
            automaticInputFailoverSettings(model.automaticInputFailoverSettings);
            inputAttachmentName(model.inputAttachmentName);
            inputId(model.inputId);
            inputSettings(model.inputSettings);
            logicalInterfaceNames(model.logicalInterfaceNames);
        }

        public final AutomaticInputFailoverSettings.Builder getAutomaticInputFailoverSettings() {
            return automaticInputFailoverSettings != null ? automaticInputFailoverSettings.toBuilder() : null;
        }

        public final void setAutomaticInputFailoverSettings(
                AutomaticInputFailoverSettings.BuilderImpl automaticInputFailoverSettings) {
            this.automaticInputFailoverSettings = automaticInputFailoverSettings != null ? automaticInputFailoverSettings.build()
                    : null;
        }

        @Override
        public final Builder automaticInputFailoverSettings(AutomaticInputFailoverSettings automaticInputFailoverSettings) {
            this.automaticInputFailoverSettings = automaticInputFailoverSettings;
            return this;
        }

        public final String getInputAttachmentName() {
            return inputAttachmentName;
        }

        public final void setInputAttachmentName(String inputAttachmentName) {
            this.inputAttachmentName = inputAttachmentName;
        }

        @Override
        public final Builder inputAttachmentName(String inputAttachmentName) {
            this.inputAttachmentName = inputAttachmentName;
            return this;
        }

        public final String getInputId() {
            return inputId;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final InputSettings.Builder getInputSettings() {
            return inputSettings != null ? inputSettings.toBuilder() : null;
        }

        public final void setInputSettings(InputSettings.BuilderImpl inputSettings) {
            this.inputSettings = inputSettings != null ? inputSettings.build() : null;
        }

        @Override
        public final Builder inputSettings(InputSettings inputSettings) {
            this.inputSettings = inputSettings;
            return this;
        }

        public final Collection<String> getLogicalInterfaceNames() {
            if (logicalInterfaceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return logicalInterfaceNames;
        }

        public final void setLogicalInterfaceNames(Collection<String> logicalInterfaceNames) {
            this.logicalInterfaceNames = ___listOf__stringCopier.copy(logicalInterfaceNames);
        }

        @Override
        public final Builder logicalInterfaceNames(Collection<String> logicalInterfaceNames) {
            this.logicalInterfaceNames = ___listOf__stringCopier.copy(logicalInterfaceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logicalInterfaceNames(String... logicalInterfaceNames) {
            logicalInterfaceNames(Arrays.asList(logicalInterfaceNames));
            return this;
        }

        @Override
        public InputAttachment build() {
            return new InputAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
