/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for MaintenanceCreateSettings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceCreateSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceCreateSettings.Builder, MaintenanceCreateSettings> {
    private static final SdkField<String> MAINTENANCE_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceDay").getter(getter(MaintenanceCreateSettings::maintenanceDayAsString))
            .setter(setter(Builder::maintenanceDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceDay").build()).build();

    private static final SdkField<String> MAINTENANCE_START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceStartTime").getter(getter(MaintenanceCreateSettings::maintenanceStartTime))
            .setter(setter(Builder::maintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceStartTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_DAY_FIELD,
            MAINTENANCE_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String maintenanceDay;

    private final String maintenanceStartTime;

    private MaintenanceCreateSettings(BuilderImpl builder) {
        this.maintenanceDay = builder.maintenanceDay;
        this.maintenanceStartTime = builder.maintenanceStartTime;
    }

    /**
     * Choose one day of the week for maintenance. The chosen day is used for all future maintenance windows.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceDay}
     * will return {@link MaintenanceDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maintenanceDayAsString}.
     * </p>
     * 
     * @return Choose one day of the week for maintenance. The chosen day is used for all future maintenance windows.
     * @see MaintenanceDay
     */
    public final MaintenanceDay maintenanceDay() {
        return MaintenanceDay.fromValue(maintenanceDay);
    }

    /**
     * Choose one day of the week for maintenance. The chosen day is used for all future maintenance windows.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceDay}
     * will return {@link MaintenanceDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maintenanceDayAsString}.
     * </p>
     * 
     * @return Choose one day of the week for maintenance. The chosen day is used for all future maintenance windows.
     * @see MaintenanceDay
     */
    public final String maintenanceDayAsString() {
        return maintenanceDay;
    }

    /**
     * Choose the hour that maintenance will start. The chosen time is used for all future maintenance windows.
     * 
     * @return Choose the hour that maintenance will start. The chosen time is used for all future maintenance windows.
     */
    public final String maintenanceStartTime() {
        return maintenanceStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceDayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceCreateSettings)) {
            return false;
        }
        MaintenanceCreateSettings other = (MaintenanceCreateSettings) obj;
        return Objects.equals(maintenanceDayAsString(), other.maintenanceDayAsString())
                && Objects.equals(maintenanceStartTime(), other.maintenanceStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceCreateSettings").add("MaintenanceDay", maintenanceDayAsString())
                .add("MaintenanceStartTime", maintenanceStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaintenanceDay":
            return Optional.ofNullable(clazz.cast(maintenanceDayAsString()));
        case "MaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(maintenanceStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maintenanceDay", MAINTENANCE_DAY_FIELD);
        map.put("maintenanceStartTime", MAINTENANCE_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceCreateSettings, T> g) {
        return obj -> g.apply((MaintenanceCreateSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceCreateSettings> {
        /**
         * Choose one day of the week for maintenance. The chosen day is used for all future maintenance windows.
         * 
         * @param maintenanceDay
         *        Choose one day of the week for maintenance. The chosen day is used for all future maintenance windows.
         * @see MaintenanceDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceDay
         */
        Builder maintenanceDay(String maintenanceDay);

        /**
         * Choose one day of the week for maintenance. The chosen day is used for all future maintenance windows.
         * 
         * @param maintenanceDay
         *        Choose one day of the week for maintenance. The chosen day is used for all future maintenance windows.
         * @see MaintenanceDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceDay
         */
        Builder maintenanceDay(MaintenanceDay maintenanceDay);

        /**
         * Choose the hour that maintenance will start. The chosen time is used for all future maintenance windows.
         * 
         * @param maintenanceStartTime
         *        Choose the hour that maintenance will start. The chosen time is used for all future maintenance
         *        windows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceStartTime(String maintenanceStartTime);
    }

    static final class BuilderImpl implements Builder {
        private String maintenanceDay;

        private String maintenanceStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceCreateSettings model) {
            maintenanceDay(model.maintenanceDay);
            maintenanceStartTime(model.maintenanceStartTime);
        }

        public final String getMaintenanceDay() {
            return maintenanceDay;
        }

        public final void setMaintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
        }

        @Override
        public final Builder maintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
            return this;
        }

        @Override
        public final Builder maintenanceDay(MaintenanceDay maintenanceDay) {
            this.maintenanceDay(maintenanceDay == null ? null : maintenanceDay.toString());
            return this;
        }

        public final String getMaintenanceStartTime() {
            return maintenanceStartTime;
        }

        public final void setMaintenanceStartTime(String maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
        }

        @Override
        public final Builder maintenanceStartTime(String maintenanceStartTime) {
            this.maintenanceStartTime = maintenanceStartTime;
            return this;
        }

        @Override
        public MaintenanceCreateSettings build() {
            return new MaintenanceCreateSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
