/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * MediaPackage Output Destination Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaPackageOutputDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaPackageOutputDestinationSettings.Builder, MediaPackageOutputDestinationSettings> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(MediaPackageOutputDestinationSettings::channelId))
            .setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()).build();

    private static final SdkField<String> CHANNEL_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroup").getter(getter(MediaPackageOutputDestinationSettings::channelGroup))
            .setter(setter(Builder::channelGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelGroup").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(MediaPackageOutputDestinationSettings::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            CHANNEL_GROUP_FIELD, CHANNEL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String channelId;

    private final String channelGroup;

    private final String channelName;

    private MediaPackageOutputDestinationSettings(BuilderImpl builder) {
        this.channelId = builder.channelId;
        this.channelGroup = builder.channelGroup;
        this.channelName = builder.channelName;
    }

    /**
     * ID of the channel in MediaPackage that is the destination for this output group. You do not need to specify the
     * individual inputs in MediaPackage; MediaLive will handle the connection of the two MediaLive pipelines to the two
     * MediaPackage inputs. The MediaPackage channel and MediaLive channel must be in the same region.
     * 
     * @return ID of the channel in MediaPackage that is the destination for this output group. You do not need to
     *         specify the individual inputs in MediaPackage; MediaLive will handle the connection of the two MediaLive
     *         pipelines to the two MediaPackage inputs. The MediaPackage channel and MediaLive channel must be in the
     *         same region.
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * Name of the channel group in MediaPackageV2. Only use if you are sending CMAF Ingest output to a CMAF ingest
     * endpoint on a MediaPackage channel that uses MediaPackage v2.
     * 
     * @return Name of the channel group in MediaPackageV2. Only use if you are sending CMAF Ingest output to a CMAF
     *         ingest endpoint on a MediaPackage channel that uses MediaPackage v2.
     */
    public final String channelGroup() {
        return channelGroup;
    }

    /**
     * Name of the channel in MediaPackageV2. Only use if you are sending CMAF Ingest output to a CMAF ingest endpoint
     * on a MediaPackage channel that uses MediaPackage v2.
     * 
     * @return Name of the channel in MediaPackageV2. Only use if you are sending CMAF Ingest output to a CMAF ingest
     *         endpoint on a MediaPackage channel that uses MediaPackage v2.
     */
    public final String channelName() {
        return channelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(channelGroup());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPackageOutputDestinationSettings)) {
            return false;
        }
        MediaPackageOutputDestinationSettings other = (MediaPackageOutputDestinationSettings) obj;
        return Objects.equals(channelId(), other.channelId()) && Objects.equals(channelGroup(), other.channelGroup())
                && Objects.equals(channelName(), other.channelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaPackageOutputDestinationSettings").add("ChannelId", channelId())
                .add("ChannelGroup", channelGroup()).add("ChannelName", channelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "ChannelGroup":
            return Optional.ofNullable(clazz.cast(channelGroup()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelId", CHANNEL_ID_FIELD);
        map.put("channelGroup", CHANNEL_GROUP_FIELD);
        map.put("channelName", CHANNEL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaPackageOutputDestinationSettings, T> g) {
        return obj -> g.apply((MediaPackageOutputDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaPackageOutputDestinationSettings> {
        /**
         * ID of the channel in MediaPackage that is the destination for this output group. You do not need to specify
         * the individual inputs in MediaPackage; MediaLive will handle the connection of the two MediaLive pipelines to
         * the two MediaPackage inputs. The MediaPackage channel and MediaLive channel must be in the same region.
         * 
         * @param channelId
         *        ID of the channel in MediaPackage that is the destination for this output group. You do not need to
         *        specify the individual inputs in MediaPackage; MediaLive will handle the connection of the two
         *        MediaLive pipelines to the two MediaPackage inputs. The MediaPackage channel and MediaLive channel
         *        must be in the same region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * Name of the channel group in MediaPackageV2. Only use if you are sending CMAF Ingest output to a CMAF ingest
         * endpoint on a MediaPackage channel that uses MediaPackage v2.
         * 
         * @param channelGroup
         *        Name of the channel group in MediaPackageV2. Only use if you are sending CMAF Ingest output to a CMAF
         *        ingest endpoint on a MediaPackage channel that uses MediaPackage v2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroup(String channelGroup);

        /**
         * Name of the channel in MediaPackageV2. Only use if you are sending CMAF Ingest output to a CMAF ingest
         * endpoint on a MediaPackage channel that uses MediaPackage v2.
         * 
         * @param channelName
         *        Name of the channel in MediaPackageV2. Only use if you are sending CMAF Ingest output to a CMAF ingest
         *        endpoint on a MediaPackage channel that uses MediaPackage v2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);
    }

    static final class BuilderImpl implements Builder {
        private String channelId;

        private String channelGroup;

        private String channelName;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPackageOutputDestinationSettings model) {
            channelId(model.channelId);
            channelGroup(model.channelGroup);
            channelName(model.channelName);
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getChannelGroup() {
            return channelGroup;
        }

        public final void setChannelGroup(String channelGroup) {
            this.channelGroup = channelGroup;
        }

        @Override
        public final Builder channelGroup(String channelGroup) {
            this.channelGroup = channelGroup;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        @Override
        public MediaPackageOutputDestinationSettings build() {
            return new MediaPackageOutputDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
