/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Multiplex Program settings configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexProgramSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexProgramSettings.Builder, MultiplexProgramSettings> {
    private static final SdkField<String> PREFERRED_CHANNEL_PIPELINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredChannelPipeline").getter(getter(MultiplexProgramSettings::preferredChannelPipelineAsString))
            .setter(setter(Builder::preferredChannelPipeline))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredChannelPipeline").build())
            .build();

    private static final SdkField<Integer> PROGRAM_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramNumber").getter(getter(MultiplexProgramSettings::programNumber))
            .setter(setter(Builder::programNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNumber").build()).build();

    private static final SdkField<MultiplexProgramServiceDescriptor> SERVICE_DESCRIPTOR_FIELD = SdkField
            .<MultiplexProgramServiceDescriptor> builder(MarshallingType.SDK_POJO).memberName("ServiceDescriptor")
            .getter(getter(MultiplexProgramSettings::serviceDescriptor)).setter(setter(Builder::serviceDescriptor))
            .constructor(MultiplexProgramServiceDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDescriptor").build()).build();

    private static final SdkField<MultiplexVideoSettings> VIDEO_SETTINGS_FIELD = SdkField
            .<MultiplexVideoSettings> builder(MarshallingType.SDK_POJO).memberName("VideoSettings")
            .getter(getter(MultiplexProgramSettings::videoSettings)).setter(setter(Builder::videoSettings))
            .constructor(MultiplexVideoSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREFERRED_CHANNEL_PIPELINE_FIELD, PROGRAM_NUMBER_FIELD, SERVICE_DESCRIPTOR_FIELD, VIDEO_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String preferredChannelPipeline;

    private final Integer programNumber;

    private final MultiplexProgramServiceDescriptor serviceDescriptor;

    private final MultiplexVideoSettings videoSettings;

    private MultiplexProgramSettings(BuilderImpl builder) {
        this.preferredChannelPipeline = builder.preferredChannelPipeline;
        this.programNumber = builder.programNumber;
        this.serviceDescriptor = builder.serviceDescriptor;
        this.videoSettings = builder.videoSettings;
    }

    /**
     * Indicates which pipeline is preferred by the multiplex for program ingest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #preferredChannelPipeline} will return {@link PreferredChannelPipeline#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #preferredChannelPipelineAsString}.
     * </p>
     * 
     * @return Indicates which pipeline is preferred by the multiplex for program ingest.
     * @see PreferredChannelPipeline
     */
    public final PreferredChannelPipeline preferredChannelPipeline() {
        return PreferredChannelPipeline.fromValue(preferredChannelPipeline);
    }

    /**
     * Indicates which pipeline is preferred by the multiplex for program ingest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #preferredChannelPipeline} will return {@link PreferredChannelPipeline#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #preferredChannelPipelineAsString}.
     * </p>
     * 
     * @return Indicates which pipeline is preferred by the multiplex for program ingest.
     * @see PreferredChannelPipeline
     */
    public final String preferredChannelPipelineAsString() {
        return preferredChannelPipeline;
    }

    /**
     * Unique program number.
     * 
     * @return Unique program number.
     */
    public final Integer programNumber() {
        return programNumber;
    }

    /**
     * Transport stream service descriptor configuration for the Multiplex program.
     * 
     * @return Transport stream service descriptor configuration for the Multiplex program.
     */
    public final MultiplexProgramServiceDescriptor serviceDescriptor() {
        return serviceDescriptor;
    }

    /**
     * Program video settings configuration.
     * 
     * @return Program video settings configuration.
     */
    public final MultiplexVideoSettings videoSettings() {
        return videoSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(preferredChannelPipelineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(serviceDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(videoSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexProgramSettings)) {
            return false;
        }
        MultiplexProgramSettings other = (MultiplexProgramSettings) obj;
        return Objects.equals(preferredChannelPipelineAsString(), other.preferredChannelPipelineAsString())
                && Objects.equals(programNumber(), other.programNumber())
                && Objects.equals(serviceDescriptor(), other.serviceDescriptor())
                && Objects.equals(videoSettings(), other.videoSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiplexProgramSettings").add("PreferredChannelPipeline", preferredChannelPipelineAsString())
                .add("ProgramNumber", programNumber()).add("ServiceDescriptor", serviceDescriptor())
                .add("VideoSettings", videoSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreferredChannelPipeline":
            return Optional.ofNullable(clazz.cast(preferredChannelPipelineAsString()));
        case "ProgramNumber":
            return Optional.ofNullable(clazz.cast(programNumber()));
        case "ServiceDescriptor":
            return Optional.ofNullable(clazz.cast(serviceDescriptor()));
        case "VideoSettings":
            return Optional.ofNullable(clazz.cast(videoSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("preferredChannelPipeline", PREFERRED_CHANNEL_PIPELINE_FIELD);
        map.put("programNumber", PROGRAM_NUMBER_FIELD);
        map.put("serviceDescriptor", SERVICE_DESCRIPTOR_FIELD);
        map.put("videoSettings", VIDEO_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiplexProgramSettings, T> g) {
        return obj -> g.apply((MultiplexProgramSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexProgramSettings> {
        /**
         * Indicates which pipeline is preferred by the multiplex for program ingest.
         * 
         * @param preferredChannelPipeline
         *        Indicates which pipeline is preferred by the multiplex for program ingest.
         * @see PreferredChannelPipeline
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreferredChannelPipeline
         */
        Builder preferredChannelPipeline(String preferredChannelPipeline);

        /**
         * Indicates which pipeline is preferred by the multiplex for program ingest.
         * 
         * @param preferredChannelPipeline
         *        Indicates which pipeline is preferred by the multiplex for program ingest.
         * @see PreferredChannelPipeline
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreferredChannelPipeline
         */
        Builder preferredChannelPipeline(PreferredChannelPipeline preferredChannelPipeline);

        /**
         * Unique program number.
         * 
         * @param programNumber
         *        Unique program number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programNumber(Integer programNumber);

        /**
         * Transport stream service descriptor configuration for the Multiplex program.
         * 
         * @param serviceDescriptor
         *        Transport stream service descriptor configuration for the Multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDescriptor(MultiplexProgramServiceDescriptor serviceDescriptor);

        /**
         * Transport stream service descriptor configuration for the Multiplex program. This is a convenience method
         * that creates an instance of the {@link MultiplexProgramServiceDescriptor.Builder} avoiding the need to create
         * one manually via {@link MultiplexProgramServiceDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiplexProgramServiceDescriptor.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceDescriptor(MultiplexProgramServiceDescriptor)}.
         * 
         * @param serviceDescriptor
         *        a consumer that will call methods on {@link MultiplexProgramServiceDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceDescriptor(MultiplexProgramServiceDescriptor)
         */
        default Builder serviceDescriptor(Consumer<MultiplexProgramServiceDescriptor.Builder> serviceDescriptor) {
            return serviceDescriptor(MultiplexProgramServiceDescriptor.builder().applyMutation(serviceDescriptor).build());
        }

        /**
         * Program video settings configuration.
         * 
         * @param videoSettings
         *        Program video settings configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoSettings(MultiplexVideoSettings videoSettings);

        /**
         * Program video settings configuration. This is a convenience method that creates an instance of the
         * {@link MultiplexVideoSettings.Builder} avoiding the need to create one manually via
         * {@link MultiplexVideoSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiplexVideoSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #videoSettings(MultiplexVideoSettings)}.
         * 
         * @param videoSettings
         *        a consumer that will call methods on {@link MultiplexVideoSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoSettings(MultiplexVideoSettings)
         */
        default Builder videoSettings(Consumer<MultiplexVideoSettings.Builder> videoSettings) {
            return videoSettings(MultiplexVideoSettings.builder().applyMutation(videoSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String preferredChannelPipeline;

        private Integer programNumber;

        private MultiplexProgramServiceDescriptor serviceDescriptor;

        private MultiplexVideoSettings videoSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexProgramSettings model) {
            preferredChannelPipeline(model.preferredChannelPipeline);
            programNumber(model.programNumber);
            serviceDescriptor(model.serviceDescriptor);
            videoSettings(model.videoSettings);
        }

        public final String getPreferredChannelPipeline() {
            return preferredChannelPipeline;
        }

        public final void setPreferredChannelPipeline(String preferredChannelPipeline) {
            this.preferredChannelPipeline = preferredChannelPipeline;
        }

        @Override
        public final Builder preferredChannelPipeline(String preferredChannelPipeline) {
            this.preferredChannelPipeline = preferredChannelPipeline;
            return this;
        }

        @Override
        public final Builder preferredChannelPipeline(PreferredChannelPipeline preferredChannelPipeline) {
            this.preferredChannelPipeline(preferredChannelPipeline == null ? null : preferredChannelPipeline.toString());
            return this;
        }

        public final Integer getProgramNumber() {
            return programNumber;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final MultiplexProgramServiceDescriptor.Builder getServiceDescriptor() {
            return serviceDescriptor != null ? serviceDescriptor.toBuilder() : null;
        }

        public final void setServiceDescriptor(MultiplexProgramServiceDescriptor.BuilderImpl serviceDescriptor) {
            this.serviceDescriptor = serviceDescriptor != null ? serviceDescriptor.build() : null;
        }

        @Override
        public final Builder serviceDescriptor(MultiplexProgramServiceDescriptor serviceDescriptor) {
            this.serviceDescriptor = serviceDescriptor;
            return this;
        }

        public final MultiplexVideoSettings.Builder getVideoSettings() {
            return videoSettings != null ? videoSettings.toBuilder() : null;
        }

        public final void setVideoSettings(MultiplexVideoSettings.BuilderImpl videoSettings) {
            this.videoSettings = videoSettings != null ? videoSettings.build() : null;
        }

        @Override
        public final Builder videoSettings(MultiplexVideoSettings videoSettings) {
            this.videoSettings = videoSettings;
            return this;
        }

        @Override
        public MultiplexProgramSettings build() {
            return new MultiplexProgramSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
